/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.util.EnumSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@Test(groups={"functional"}, testName="server.hotrod.HotRodSingleClusteredTest")
@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u0017\t!\u0003j\u001c;S_\u0012\u001c\u0016N\\4mK\u000ecWo\u001d;fe\u0016$gj\u001c8M_>\u0004(-Y2l)\u0016\u001cHO\u0003\u0002\u0004\t\u00051\u0001n\u001c;s_\u0012T!!\u0002\u0004\u0002\rM,'O^3s\u0015\t9\u0001\"\u0001\u0006j]\u001aLg.[:qC:T\u0011!C\u0001\u0004_J<7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q!a\u0004\u0004\u0002\tQ,7\u000f^\u0005\u0003#9\u0011\u0011$T;mi&\u0004H.Z\"bG\",W*\u00198bO\u0016\u00148\u000fV3ti\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\n1\u0001\u0001\r\u00111A\u0005\ne\tA\u0002[8u%>$7+\u001a:wKJ,\u0012A\u0007\t\u0003-mI!\u0001\b\u0002\u0003\u0019!{GOU8e'\u0016\u0014h/\u001a:\t\u0013y\u0001\u0001\u0019!a\u0001\n\u0013y\u0012\u0001\u00055piJ{GmU3sm\u0016\u0014x\fJ3r)\t\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0003V]&$\bbB\u0014\u001e\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004BB\u0015\u0001A\u0003&!$A\u0007i_R\u0014v\u000eZ*feZ,'\u000f\t\u0005\nW\u0001\u0001\r\u00111A\u0005\n1\nA\u0002[8u%>$7\t\\5f]R,\u0012!\f\t\u0003]Aj\u0011a\f\u0006\u0003\u001f\tI!!M\u0018\u0003\u0019!{GOU8e\u00072LWM\u001c;\t\u0013M\u0002\u0001\u0019!a\u0001\n\u0013!\u0014\u0001\u00055piJ{Gm\u00117jK:$x\fJ3r)\t\u0001S\u0007C\u0004(e\u0005\u0005\t\u0019A\u0017\t\r]\u0002\u0001\u0015)\u0003.\u00035Aw\u000e\u001e*pI\u000ec\u0017.\u001a8uA!9\u0011\b\u0001b\u0001\n\u0013Q\u0014!C2bG\",g*Y7f+\u0005Y\u0004C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\u0011a\u0017M\\4\u000b\u0003\u0001\u000bAA[1wC&\u0011!)\u0010\u0002\u0007'R\u0014\u0018N\\4\t\r\u0011\u0003\u0001\u0015!\u0003<\u0003)\u0019\u0017m\u00195f\u001d\u0006lW\r\t\u0005\u0006\r\u0002!\teR\u0001\u0014GJ,\u0017\r^3DC\u000eDW-T1oC\u001e,'o\u001d\u000b\u0002A!\"Q)S)S!\tQu*D\u0001L\u0015\taU*A\u0006b]:|G/\u0019;j_:\u001c(B\u0001(\t\u0003\u0019!Xm\u001d;oO&\u0011\u0001k\u0013\u0002\u0005)\u0016\u001cH/A\u0004f]\u0006\u0014G.\u001a3\u001a\u0003\u0001AQ\u0001\u0016\u0001\u0005B\u001d\u000b\u0011c\u0019:fCR,')\u001a4pe\u0016\u001cE.Y:tQ\u0011\u0019\u0016*\u0015*)\tM;&l\u0017\t\u0003\u0015bK!!W&\u0003\u0017\t+gm\u001c:f\u00072\f7o]\u0001\nC2<\u0018-_:Sk:L\u0012!\u0001\u0005\u0006;\u0002!\teR\u0001\bI\u0016\u001cHO]8zQ\u0011avLW.\u0011\u0005)\u0003\u0017BA1L\u0005)\te\r^3s\u00072\f7o\u001d\u0005\u0006G\u0002!\t\u0001Z\u0001#i\u0016\u001cHOT8o\u0019>|\u0007OY1dWB+Ho\u00148Qe>$Xm\u0019;fI\u000e\u000b7\r[3\u0015\u0005\u0001*\u0007\"\u00024c\u0001\u00049\u0017!A7\u0011\u0005!\\W\"A5\u000b\u0005)l\u0014a\u0002:fM2,7\r^\u0005\u0003Y&\u0014a!T3uQ>$\u0007F\u0002\u0001J]>\u00148/\u0001\u0004he>,\bo\u001d\u0017\u0002a\u0006\n\u0011/\u0001\u0006gk:\u001cG/[8oC2\f\u0001\u0002^3ti:\u000bW.Z\u0011\u0002i\u000693/\u001a:wKJt\u0003n\u001c;s_\u0012t\u0003j\u001c;S_\u0012\u001c\u0016N\\4mK\u000ecWo\u001d;fe\u0016$G+Z:u\u0001")
public class HotRodSingleClusteredNonLoopbackTest
extends MultipleCacheManagersTest {
    private HotRodServer hotRodServer;
    private HotRodClient hotRodClient;
    private final String cacheName;

    private HotRodServer hotRodServer() {
        return this.hotRodServer;
    }

    private void hotRodServer_$eq(HotRodServer x$1) {
        this.hotRodServer = x$1;
    }

    private HotRodClient hotRodClient() {
        return this.hotRodClient;
    }

    private void hotRodClient_$eq(HotRodClient x$1) {
        this.hotRodClient = x$1;
    }

    private String cacheName() {
        return this.cacheName;
    }

    @Test(enabled=false)
    public void createCacheManagers() {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration());
        this.cacheManagers.add(cm);
        ConfigurationBuilder builder = HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration(AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        cm.defineConfiguration(this.cacheName(), builder.build());
    }

    @BeforeClass(alwaysRun=true)
    @Test(enabled=false)
    public void createBeforeClass() {
        super.createBeforeClass();
        NetworkInterface iface = (NetworkInterface)HotRodTestingUtil$.MODULE$.findNetworkInterfaces(false).next();
        String address = iface.getInetAddresses().nextElement().getHostAddress();
        this.hotRodServer_$eq(HotRodTestingUtil$.MODULE$.startHotRodServer((EmbeddedCacheManager)this.cacheManagers.get(0), address, HotRodTestingUtil$.MODULE$.serverPort(), 0L, HotRodTestingUtil$.MODULE$.getDefaultHotRodConfiguration()));
        this.hotRodClient_$eq(new HotRodClient(address, this.hotRodServer().getPort(), this.cacheName(), 60, 20));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        this.log.debug((Object)"Test finished, close client, server, and cache managers");
        HotRodTestingUtil$.MODULE$.killClient(this.hotRodClient());
        ServerTestingUtil.killServer((AbstractProtocolServer)this.hotRodServer());
        super.destroy();
    }

    public void testNonLoopbackPutOnProtectedCache(Method m) {
        InternalCacheRegistry internalCacheRegistry = (InternalCacheRegistry)this.manager(0).getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        internalCacheRegistry.registerInternalCache("MyInternalCache", new ConfigurationBuilder().build(), EnumSet.of(InternalCacheRegistry.Flag.USER, InternalCacheRegistry.Flag.PROTECTED));
        TestErrorResponse resp = (TestErrorResponse)this.hotRodClient().execute(160, (byte)1, "MyInternalCache", HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 0L, (byte)1, 0);
        Assert.assertTrue((boolean)resp.msg.contains("protected caches only over loopback"));
        Assert.assertEquals((Object)resp.status, (Object)OperationStatus.ParseError, (String)new StringBuilder().append((Object)"Status should have been 'ParseError' but instead was: ").append((Object)resp.status).toString());
        this.hotRodClient().assertPut(m);
    }

    public HotRodSingleClusteredNonLoopbackTest() {
        this.cacheName = "HotRodCache";
    }
}

