/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.hash.Hash;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;
import org.infinispan.distribution.group.PartitionerConsistentHash;
import org.infinispan.distribution.group.impl.GroupingPartitioner;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.AbstractEncoder1x;
import org.infinispan.server.hotrod.AbstractHashDistAwareResponse;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.HashDistAware11Response;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.util.KeyValuePair;

abstract class AbstractTopologyAwareEncoder1x
extends AbstractEncoder1x {
    AbstractTopologyAwareEncoder1x() {
    }

    @Override
    protected AbstractHashDistAwareResponse createHashDistAwareResp(int topologyId, Map<Address, ServerAddress> serverEndpointsMap, Configuration cfg) {
        return new HashDistAware11Response(topologyId, serverEndpointsMap, cfg.clustering().hash().numOwners(), 2, Integer.MAX_VALUE, 1);
    }

    @Override
    void writeHashTopologyUpdate(AbstractHashDistAwareResponse h, HotRodServer server, Response r, ByteBuf buffer) {
        if (!(h instanceof HashDistAware11Response)) {
            throw new IllegalStateException("Expected version 1.1 specific response: " + h);
        }
        this.writeHashTopologyUpdate11((HashDistAware11Response)h, server, r, buffer);
    }

    void writeHashTopologyUpdate11(HashDistAware11Response h, HotRodServer server, Response r, ByteBuf buf) {
        this.log.tracef("Write hash distribution change response header %s", h);
        if (h.hashFunction == 0) {
            this.writeLimitedHashTopologyUpdate(h, buf);
            return;
        }
        AdvancedCache cache = server.getCacheInstance(r.cacheName, server.getCacheManager(), false, true);
        DistributionManager distManager = cache.getDistributionManager();
        ConsistentHash ch = distManager.getReadConsistentHash();
        int numSegments = ch.getNumSegments();
        ArrayList<KeyValuePair> hashIds = new ArrayList<KeyValuePair>(numSegments);
        List<Integer>[] allDenormalizedHashIds = this.denormalizeSegmentHashIds(ch);
        for (int segmentIdx = 0; segmentIdx < numSegments; ++segmentIdx) {
            List<Integer> denormalizedSegmentHashIds = allDenormalizedHashIds[segmentIdx];
            List segmentOwners = ch.locateOwnersForSegment(segmentIdx);
            for (int ownerIdx = 0; ownerIdx < segmentOwners.size(); ++ownerIdx) {
                Address address = (Address)segmentOwners.get(ownerIdx % segmentOwners.size());
                ServerAddress serverAddress = (ServerAddress)h.serverEndpointsMap.get(address);
                if (serverAddress != null) {
                    Integer hashId = denormalizedSegmentHashIds.get(ownerIdx);
                    hashIds.add(new KeyValuePair((Object)serverAddress, (Object)hashId));
                    continue;
                }
                this.log.tracef("Could not find member %s in the address cache", address);
            }
        }
        this.writeCommonHashTopologyHeader(buf, h.topologyId, h.numOwners, h.hashFunction, h.hashSpace, hashIds.size());
        ExtendedByteBuf.writeUnsignedInt(1, buf);
        for (KeyValuePair serverHash : hashIds) {
            this.log.tracef("Writing hash id %d for %s:%s", serverHash.getValue(), ((ServerAddress)serverHash.getKey()).getHost(), ((ServerAddress)serverHash.getKey()).getPort());
            ExtendedByteBuf.writeString(((ServerAddress)serverHash.getKey()).getHost(), buf);
            ExtendedByteBuf.writeUnsignedShort(((ServerAddress)serverHash.getKey()).getPort(), buf);
            buf.writeInt(((Integer)serverHash.getValue()).intValue());
        }
    }

    @Override
    void writeLimitedHashTopologyUpdate(AbstractTopologyResponse t, ByteBuf buffer) {
        this.log.tracef("Return limited hash distribution aware header in spite of having a hash aware client %s", t);
        this.writeCommonHashTopologyHeader(buffer, t.topologyId, 0, (byte)0, 0, t.serverEndpointsMap.size());
        ExtendedByteBuf.writeUnsignedInt(1, buffer);
        for (ServerAddress address : t.serverEndpointsMap.values()) {
            ExtendedByteBuf.writeString(address.getHost(), buffer);
            ExtendedByteBuf.writeUnsignedShort(address.getPort(), buffer);
            buffer.writeInt(0);
        }
    }

    List<Integer>[] denormalizeSegmentHashIds(ConsistentHash ch) {
        double leewayFraction = 2.0E-4;
        int numOwners = ch.getNumOwners();
        int numSegments = ch.getNumSegments();
        int segmentSize = (int)Math.ceil(2.147483647E9 / (double)numSegments);
        int leeway = (int)(leewayFraction * (double)segmentSize);
        assert (leeway > 2 * numOwners);
        Object[] ownerHashes = new Map[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            ownerHashes[i] = new HashMap();
        }
        KeyPartitioner keyPartitioner = ((PartitionerConsistentHash)ch).getKeyPartitioner();
        this.extractHash(keyPartitioner).ifPresent(arg_0 -> AbstractTopologyAwareEncoder1x.lambda$denormalizeSegmentHashIds$0(numSegments, segmentSize, leeway, (Map[])ownerHashes, numOwners, arg_0));
        this.log.tracef("Found denormalized hashes: %s", ownerHashes);
        List[] results = new List[ownerHashes.length];
        int i = 0;
        for (Object ownerHash : ownerHashes) {
            results[i++] = ownerHash.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList());
        }
        return results;
    }

    Optional<Hash> extractHash(KeyPartitioner keyPartitioner) {
        if (keyPartitioner instanceof HashFunctionPartitioner) {
            return Optional.of(((HashFunctionPartitioner)keyPartitioner).getHash());
        }
        if (keyPartitioner instanceof GroupingPartitioner) {
            return this.extractHash(((GroupingPartitioner)keyPartitioner).unwrap());
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$denormalizeSegmentHashIds$0(int numSegments, int segmentSize, int leeway, Map[] ownerHashes, int numOwners, Hash h) {
        int i = 0;
        int segmentsLeft = numSegments;
        while (segmentsLeft != 0) {
            int nextSegmentIdx;
            int segmentIdx;
            Map segmentHashes;
            int normalizedHash = h.hash(i) & Integer.MAX_VALUE;
            if (normalizedHash % segmentSize < leeway && (segmentHashes = ownerHashes[segmentIdx = ((nextSegmentIdx = normalizedHash / segmentSize) - 1 + numSegments) % numSegments]).size() < numOwners) {
                segmentHashes.put(normalizedHash, i);
                if (segmentHashes.size() == numOwners) {
                    --segmentsLeft;
                }
            }
            ++i;
        }
    }
}

