/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.group.ChannelGroup;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.HotRodTestingUtils;
import org.infinispan.server.hotrod.test.TestAuthMechListResponse;
import org.infinispan.server.hotrod.test.TestAuthResponse;
import org.infinispan.server.hotrod.test.TestCallbackHandler;
import org.infinispan.test.TestingUtil;
import org.jboss.sasl.JBossSaslProvider;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.hotrod.HotRodAuthenticationTest")
@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u0017\tA\u0002j\u001c;S_\u0012\fU\u000f\u001e5f]RL7-\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011A\u00025piJ|GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\t!\u0002j\u001c;S_\u0012\u001c\u0016N\\4mK:{G-\u001a+fgRDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u00055\u0001\u0001bB\u000b\u0001\u0005\u0004%\tAF\u0001\u0012U\n|7o]*bg2\u0004&o\u001c<jI\u0016\u0014X#A\f\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012\u0001B:bg2T!\u0001\b\u0005\u0002\u000b)\u0014wn]:\n\u0005yI\"!\u0005&C_N\u001c8+Y:m!J|g/\u001b3fe\"1\u0001\u0005\u0001Q\u0001\n]\t!C\u001b2pgN\u001c\u0016m\u001d7Qe>4\u0018\u000eZ3sA!)!\u0005\u0001C!G\u000592M]3bi\u0016\u001cF/\u0019:u\u0011>$(k\u001c3TKJ4XM\u001d\u000b\u0003I\u001d\u0002\"!D\u0013\n\u0005\u0019\u0012!\u0001\u0004%piJ{GmU3sm\u0016\u0014\b\"\u0002\u0015\"\u0001\u0004I\u0013\u0001D2bG\",W*\u00198bO\u0016\u0014\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u001di\u0017M\\1hKJL!AL\u0016\u0003)\u0015k'-\u001a3eK\u0012\u001c\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003A!Xm\u001d;BkRDW*Z2i\u0019&\u001cH\u000f\u0006\u00023qA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t!QK\\5u\u0011\u0015It\u00061\u0001;\u0003\u0005i\u0007CA\u001eC\u001b\u0005a$BA\u001f?\u0003\u001d\u0011XM\u001a7fGRT!a\u0010!\u0002\t1\fgn\u001a\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019EH\u0001\u0004NKRDw\u000e\u001a\u0005\u0006\u000b\u0002!\tAR\u0001\ti\u0016\u001cH/Q;uQR\u0011!g\u0012\u0005\u0006s\u0011\u0003\rA\u000f\u0005\u0006\u0013\u0002!\tAS\u0001\"i\u0016\u001cH/\u00168bkRDwN]5{K\u0012|\u0005o\u00117pg\u0016\u001cuN\u001c8fGRLwN\u001c\u000b\u0003e-CQ!\u000f%A\u0002iBc\u0001A'V-fS\u0006C\u0001(T\u001b\u0005y%B\u0001)R\u0003-\tgN\\8uCRLwN\\:\u000b\u0005IC\u0011A\u0002;fgRtw-\u0003\u0002U\u001f\n!A+Z:u\u0003\u00199'o\\;qg2\nq+I\u0001Y\u0003)1WO\\2uS>t\u0017\r\\\u0001\ti\u0016\u001cHOT1nK\u0006\n1,\u0001\u0014tKJ4XM\u001d\u0018i_R\u0014x\u000e\u001a\u0018I_R\u0014v\u000eZ!vi\",g\u000e^5dCRLwN\u001c+fgR\u0004")
public class HotRodAuthenticationTest
extends HotRodSingleNodeTest {
    private final JBossSaslProvider jbossSaslProvider = new JBossSaslProvider();

    public JBossSaslProvider jbossSaslProvider() {
        return this.jbossSaslProvider;
    }

    @Override
    public HotRodServer createStartHotRodServer(EmbeddedCacheManager cacheManager) {
        SimpleServerAuthenticationProvider ssap = new SimpleServerAuthenticationProvider();
        ssap.addUser("user", "realm", "password".toCharArray(), new String[]{null});
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.authentication().enable().addAllowedMech("CRAM-MD5").serverAuthenticationProvider((ServerAuthenticationProvider)ssap).serverName("localhost").addMechProperty("javax.security.sasl.policy.noanonymous", "true");
        return HotRodTestingUtil$.MODULE$.startHotRodServer(cacheManager, HotRodTestingUtils.serverPort(), 0L, builder);
    }

    public void testAuthMechList(Method m) {
        TestAuthMechListResponse a = this.client().authMechList();
        AssertJUnit.assertEquals((int)1, (int)a.mechs.size());
        AssertJUnit.assertTrue((boolean)a.mechs.contains("CRAM-MD5"));
        AssertJUnit.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.server().getDecoder().getTransport().getNumberOfLocalConnections());
    }

    public void testAuth(Method m) {
        HashMap props = new HashMap();
        SaslClient sc = Sasl.createSaslClient((String[])((Object[])new String[]{"CRAM-MD5"}), null, "hotrod", "localhost", props, new TestCallbackHandler("user", "realm", "password".toCharArray()));
        TestAuthResponse res = this.client().auth(sc);
        AssertJUnit.assertTrue((boolean)res.complete);
        AssertJUnit.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.server().getDecoder().getTransport().getNumberOfLocalConnections());
    }

    public void testUnauthorizedOpCloseConnection(Method m) {
        ChannelGroup acceptedChannels = (ChannelGroup)TestingUtil.extractField((Object)this.server().getDecoder().getTransport(), (String)"acceptedChannels");
        acceptedChannels.close().awaitUninterruptibly();
        try {
            this.client().assertPutFail(m);
            return;
        }
        finally {
            AssertJUnit.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.server().getDecoder().getTransport().getNumberOfLocalConnections());
        }
    }
}

