/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.function.Consumer;
import org.infinispan.configuration.cache.ClusterLoaderConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.Stoppable;
import org.infinispan.server.hotrod.HotRodConfigurationTest$;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Function2;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Test(groups={"functional"}, testName="server.hotrod.HotRodConfigurationTest")
@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u0017\t9\u0002j\u001c;S_\u0012\u001cuN\u001c4jOV\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001[8ue>$'BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!BA\b\u0007\u0003\u0011!Xm\u001d;\n\u0005Eq!AF!cgR\u0014\u0018m\u0019;J]\u001aLg.[:qC:$Vm\u001d;\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012a\u0006;fgR,6/\u001a:EK\u001aLg.\u001a3US6,w.\u001e;t)\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"\u0001B+oSRDQ!\t\u0001\u0005\u0002e\tA\u0003^3ti2\u000b'0\u001f'pC\u0012$v\u000e]8m_\u001eL\b\"B\u0012\u0001\t\u0013!\u0013aE<ji\"\u001cE.^:uKJ,GmU3sm\u0016\u0014HCA\u00137)\tQb\u0005C\u0003(E\u0001\u0007\u0001&\u0001\u0004bgN,'\u000f\u001e\t\u00067%Z3GG\u0005\u0003Uq\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013!B2bG\",'B\u0001\u0019\u0007\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011!'\f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\u0005m!\u0014BA\u001b\u001d\u0005\u0011auN\\4\t\u000b]\u0012\u0003\u0019\u0001\u001d\u0002\u000f\t,\u0018\u000e\u001c3feB\u0011\u0011hO\u0007\u0002u)\u0011\u0001GA\u0005\u0003yi\u0012\u0001\u0005S8u%>$7+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\n+\u0018\u000e\u001c3fe\"2\u0001A\u0010$H\u0015.\u0003\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u0003\u0007\"\ta\u0001^3ti:<\u0017BA#A\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\u0005A\u0015%A%\u0002\u0015\u0019,hn\u0019;j_:\fG.\u0001\u0005uKN$h*Y7fC\u0005a\u0015!J:feZ,'O\f5piJ|GM\f%piJ{GmQ8oM&<WO]1uS>tG+Z:u\u0001")
public class HotRodConfigurationTest
extends AbstractInfinispanTest {
    public void testUserDefinedTimeouts() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyLockTimeout(26000L).topologyReplTimeout(31000L);
        this.withClusteredServer(builder, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.locking().lockAcquisitionTimeout(), (long)26000L);
                Assert.assertEquals((long)cfg.clustering().remoteTimeout(), (long)31000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                Assert.assertEquals((long)cfg.clustering().stateTransfer().timeout(), (long)(31000L + distSyncTimeout));
                Assert.assertTrue((boolean)cfg.persistence().stores().isEmpty());
            }
        });
    }

    public void testLazyLoadTopology() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.topologyStateTransfer(false).topologyReplTimeout(43000L);
        this.withClusteredServer(builder, (Function2<Configuration, Object, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Configuration cfg, long distSyncTimeout) {
                Assert.assertEquals((long)cfg.clustering().remoteTimeout(), (long)43000L);
                Assert.assertTrue((boolean)cfg.clustering().stateTransfer().fetchInMemoryState());
                ClusterLoaderConfiguration clcfg = (ClusterLoaderConfiguration)cfg.persistence().stores().get(0);
                Assert.assertNotNull((Object)clcfg);
                Assert.assertEquals((long)clcfg.remoteCallTimeout(), (long)43000L);
            }
        });
    }

    private void withClusteredServer(HotRodServerConfigurationBuilder builder, Function2<Configuration, Object, BoxedUnit> function2) {
        Stoppable.useCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil$.MODULE$.hotRodCacheConfiguration()), (Consumer)new Consumer<EmbeddedCacheManager>(this, builder, function2){
            private final HotRodServerConfigurationBuilder builder$1;
            public final Function2 assert$1;

            public void accept(EmbeddedCacheManager cm) {
                Stoppable.useServer((AbstractProtocolServer)HotRodTestingUtil$.MODULE$.startHotRodServer(cm, HotRodTestingUtil$.MODULE$.serverPort(), this.builder$1), (Consumer)new Consumer<HotRodServer>(this, cm){
                    private final /* synthetic */ $anon$1 $outer;
                    private final EmbeddedCacheManager cm$1;

                    public void accept(HotRodServer server) {
                        Configuration cfg = this.cm$1.getCacheConfiguration(((HotRodServerConfiguration)server.getConfiguration()).topologyCacheName());
                        this.$outer.assert$1.apply((Object)cfg, (Object)BoxesRunTime.boxToLong((long)this.cm$1.getCacheManagerConfiguration().transport().distributedSyncTimeout()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.cm$1 = cm$1;
                    }
                });
            }
            {
                this.builder$1 = builder$1;
                this.assert$1 = assert$1;
            }
        });
    }
}

