/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil$;
import org.infinispan.server.hotrod.test.Op;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.Null$;

@Test(groups={"functional"}, testName="server.hotrod.HotRodSniFunctionalTest")
@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0001\u0003\u0001-\u0011q\u0003S8u%>$7K\\5Gk:\u001cG/[8oC2$Vm\u001d;\u000b\u0005\r!\u0011A\u00025piJ|GM\u0003\u0002\u0006\r\u000511/\u001a:wKJT!a\u0002\u0005\u0002\u0015%tg-\u001b8jgB\fgNC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\t!\u0002j\u001c;S_\u0012\u001c\u0016N\\4mK:{G-\u001a+fgRDQ!\u0005\u0001\u0005\u0002I\ta\u0001P5oSRtD#A\n\u0011\u00055\u0001\u0001bB\u000b\u0001\u0005\u0004%IAF\u0001\u0016I\u00164\u0017-\u001e7u'\u0016\u0014h/\u001a:LKf\u001cHo\u001c:f+\u00059\u0002C\u0001\r\u001e\u001b\u0005I\"B\u0001\u000e\u001c\u0003\u0011a\u0017M\\4\u000b\u0003q\tAA[1wC&\u0011a$\u0007\u0002\u0007'R\u0014\u0018N\\4\t\r\u0001\u0002\u0001\u0015!\u0003\u0018\u0003Y!WMZ1vYR\u001cVM\u001d<fe.+\u0017p\u001d;pe\u0016\u0004\u0003b\u0002\u0012\u0001\u0005\u0004%IAF\u0001\u0012g:L7+\u001a:wKJ\\U-_:u_J,\u0007B\u0002\u0013\u0001A\u0003%q#\u0001\nt]&\u001cVM\u001d<fe.+\u0017p\u001d;pe\u0016\u0004\u0003b\u0002\u0014\u0001\u0005\u0004%IAF\u0001\"]>\fU\u000f\u001e5pe&TX\rZ\"mS\u0016tGo]*feZ,'oS3zgR|'/\u001a\u0005\u0007Q\u0001\u0001\u000b\u0011B\f\u0002E9|\u0017)\u001e;i_JL'0\u001a3DY&,g\u000e^:TKJ4XM]&fsN$xN]3!\u0011\u001dQ\u0003A1A\u0005\nY\ta\u0004Z3gCVdG\u000f\u0016:vgR,Gm\u00117jK:$HK];tiN$xN]3\t\r1\u0002\u0001\u0015!\u0003\u0018\u0003}!WMZ1vYR$&/^:uK\u0012\u001cE.[3oiR\u0013Xo\u001d;ti>\u0014X\r\t\u0005\b]\u0001\u0011\r\u0011\"\u0003\u0017\u0003i\u0019h.\u001b+skN$X\rZ\"mS\u0016tG\u000f\u0016:vgR\u001cHo\u001c:f\u0011\u0019\u0001\u0004\u0001)A\u0005/\u0005Y2O\\5UeV\u001cH/\u001a3DY&,g\u000e\u001e+skN$8\u000f^8sK\u0002BQA\r\u0001\u0005\u0002M\n1\"\u00194uKJlU\r\u001e5pIR\tA\u0007\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0003V]&$\bFA\u0019<!\ta\u0014)D\u0001>\u0015\tqt(A\u0006b]:|G/\u0019;j_:\u001c(B\u0001!\t\u0003\u0019!Xm\u001d;oO&\u0011!)\u0010\u0002\f\u0003\u001a$XM]'fi\"|G\rC\u0003E\u0001\u0011\u0005Q)\u0001\u0015uKN$8+\u001a:wKJ\fe\u000eZ\"mS\u0016tGoV5uQ\u0012+g-Y;miN\u001bHnQ8oi\u0016DH\u000f\u0006\u00025\r\")qi\u0011a\u0001\u0011\u0006\tQ\u000e\u0005\u0002J\u00196\t!J\u0003\u0002L3\u00059!/\u001a4mK\u000e$\u0018BA'K\u0005\u0019iU\r\u001e5pI\")q\n\u0001C\u0001!\u0006!C/Z:u'\u0016\u0014h/\u001a:B]\u0012\u001cE.[3oi^KG\u000f[*oSN\u001bHnQ8oi\u0016DH\u000f\u0006\u00025#\")qI\u0014a\u0001\u0011\")1\u000b\u0001C\u0001)\u0006\u0001D/Z:u'\u0016\u0014h/\u001a:XSRDgj\u001c;NCR\u001c\u0007.\u001b8h\t\u00164\u0017-\u001e7u\u0003:$7\t\\5f]R<\u0016\u000e\u001e5T\u001d&#\"\u0001N+\t\u000b\u001d\u0013\u0006\u0019\u0001%\t\u000b]\u0003A\u0011\u000b-\u0002/\r\u0014X-\u0019;f'R\f'\u000f\u001e%piJ{GmU3sm\u0016\u0014HCA-]!\t)$,\u0003\u0002\\m\t!a*\u001e7m\u0011\u0015if\u000b1\u0001_\u00031\u0019\u0017m\u00195f\u001b\u0006t\u0017mZ3s!\ty&-D\u0001a\u0015\t\tg!A\u0004nC:\fw-\u001a:\n\u0005\r\u0004'\u0001F#nE\u0016$G-\u001a3DC\u000eDW-T1oC\u001e,'\u000fC\u0003f\u0001\u0011Ec-A\u0007d_:tWm\u0019;DY&,g\u000e^\u000b\u00023\u001a!\u0001\u000e\u0001\u0001j\u0005MAu\u000e\u001e:pI\u000ec\u0017.\u001a8u\u0005VLG\u000eZ3s'\t9'\u000e\u0005\u00026W&\u0011AN\u000e\u0002\u0007\u0003:L(+\u001a4\t\u00119<'\u0011!Q\u0001\n=\fA\u0002[8u%>$7+\u001a:wKJ\u0004\"!\u00049\n\u0005E\u0014!\u0001\u0004%piJ{GmU3sm\u0016\u0014\b\"B\th\t\u0003\u0019HC\u0001;w!\t)x-D\u0001\u0001\u0011\u0015q'\u000f1\u0001p\u0011%Ax\r1AA\u0002\u0013\u0005\u00110\u0001\u0006tg2\u001cuN\u001c;fqR,\u0012A\u001f\t\u0004w\u0006\u0015Q\"\u0001?\u000b\u0005ut\u0018aA:tY*\u0019q0!\u0001\u0002\u00079,GO\u0003\u0002\u0002\u0004\u0005)!.\u0019<bq&\u0019\u0011q\u0001?\u0003\u0015M\u001bFjQ8oi\u0016DH\u000fC\u0006\u0002\f\u001d\u0004\r\u00111A\u0005\u0002\u00055\u0011AD:tY\u000e{g\u000e^3yi~#S-\u001d\u000b\u0004i\u0005=\u0001\"CA\t\u0003\u0013\t\t\u00111\u0001{\u0003\rAH%\r\u0005\b\u0003+9\u0007\u0015)\u0003{\u0003-\u00198\u000f\\\"p]R,\u0007\u0010\u001e\u0011\t\u0017\u0005eq\r1AA\u0002\u0013\u0005\u00111D\u0001\ngNdWI\\4j]\u0016,\"!!\b\u0011\u0007m\fy\"C\u0002\u0002\"q\u0014\u0011bU*M\u000b:<\u0017N\\3\t\u0017\u0005\u0015r\r1AA\u0002\u0013\u0005\u0011qE\u0001\u000egNdWI\\4j]\u0016|F%Z9\u0015\u0007Q\nI\u0003\u0003\u0006\u0002\u0012\u0005\r\u0012\u0011!a\u0001\u0003;A\u0001\"!\fhA\u0003&\u0011QD\u0001\u000bgNdWI\\4j]\u0016\u0004\u0003bBA\u0019O\u0012\u0005\u00111G\u0001\u0014kN,7k\u001d7D_:4\u0017nZ;sCRLwN\u001c\u000b\ni\u0006U\u0012QIA%\u0003\u001bB\u0001\"a\u000e\u00020\u0001\u0007\u0011\u0011H\u0001\u0011W\u0016L8\u000f^8sK\u001aKG.\u001a(b[\u0016\u0004B!a\u000f\u0002B9\u0019Q'!\u0010\n\u0007\u0005}b'\u0001\u0004Qe\u0016$WMZ\u0005\u0004=\u0005\r#bAA m!A\u0011qIA\u0018\u0001\u0004\tI$A\tlKf\u001cHo\u001c:f!\u0006\u001c8o\\<pe\u0012D\u0001\"a\u0013\u00020\u0001\u0007\u0011\u0011H\u0001\u0013iJ,8\u000f^:u_J,g)\u001b7f\u001d\u0006lW\r\u0003\u0005\u0002P\u0005=\u0002\u0019AA\u001d\u0003I!(/^:ugR|'/\u001a)bgN<xN\u001d3\t\u000f\u0005Ms\r\"\u0001\u0002V\u0005a\u0011\r\u001a3T]&$u.\\1j]R\u0019A/a\u0016\t\u0011\u0005e\u0013\u0011\u000ba\u0001\u00037\n\u0001b\u001d8j\u001d\u0006lWm\u001d\t\u0006k\u0005u\u0013\u0011H\u0005\u0004\u0003?2$A\u0003\u001fsKB,\u0017\r^3e}!9\u00111M4\u0005\u0002\u0005\u0015\u0014!\u00022vS2$GCAA4!\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7\u0005\u0005!A/Z:u\u0013\u0011\t\t(a\u001b\u0003\u0019!{GOU8e\u00072LWM\u001c;\u0007\r\u0005U\u0004\u0001AA<\u0005MAu\u000e\u001e:pIN+'O^3s\u0005VLG\u000eZ3s'\r\t\u0019H\u001b\u0005\b#\u0005MD\u0011AA>)\t\ti\bE\u0002v\u0003gB\u0011\"!!\u0002t\t\u0007I\u0011\u0001\f\u0002\u0005%\u0004\b\u0002CAC\u0003g\u0002\u000b\u0011B\f\u0002\u0007%\u0004\b\u0005\u0003\u0006\u0002\n\u0006M$\u0019!C\u0001\u0003\u0017\u000bqAY;jY\u0012,'/\u0006\u0002\u0002\u000eB!\u0011qRAK\u001b\t\t\tJC\u0002\u0002\u0014\n\tQbY8oM&<WO]1uS>t\u0017\u0002BAL\u0003#\u0013\u0001\u0005S8u%>$7+\u001a:wKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]\n+\u0018\u000e\u001c3fe\"I\u00111TA:A\u0003%\u0011QR\u0001\tEVLG\u000eZ3sA!A\u00111KA:\t\u0003\ty\n\u0006\u0007\u0002~\u0005\u0005\u0016QUAT\u0003S\u000bY\u000b\u0003\u0005\u0002$\u0006u\u0005\u0019AA\u001d\u0003\u0019!w.\\1j]\"A\u0011qGAO\u0001\u0004\tI\u0004\u0003\u0005\u0002H\u0005u\u0005\u0019AA\u001d\u0011!\tY%!(A\u0002\u0005e\u0002\u0002CA(\u0003;\u0003\r!!\u000f\t\u0011\u0005\r\u00141\u000fC\u0001\u0003_#\u0012a\u001c\u0005\r\u0003g\u0003\u0001\u0013!A\u0001\u0002\u0013\u0005\u0011QW\u0001\u0017aJ|G/Z2uK\u0012$3-Y2iK6\u000bg.Y4feR\u0019a,a.\t\u0013\u0005E\u0011\u0011WA\u0001\u0002\u0004\u0019\u0002f\u0003\u0001\u0002<\u0006\u0005\u00171YAe\u0003\u0017\u00042\u0001PA_\u0013\r\ty,\u0010\u0002\u0005)\u0016\u001cH/\u0001\u0004he>,\bo\u001d\u0017\u0003\u0003\u000b\f#!a2\u0002\u0015\u0019,hn\u0019;j_:\fG.\u0001\u0005uKN$h*Y7fC\t\ti-A\u0013tKJ4XM\u001d\u0018i_R\u0014x\u000e\u001a\u0018I_R\u0014v\u000eZ*oS\u001a+hn\u0019;j_:\fG\u000eV3ti\u0002")
public class HotRodSniFunctionalTest
extends HotRodSingleNodeTest {
    private final String defaultServerKeystore = ((Object)((Object)this)).getClass().getClassLoader().getResource("default_server_keystore.jks").getPath();
    private final String sniServerKeystore = ((Object)((Object)this)).getClass().getClassLoader().getResource("sni_server_keystore.jks").getPath();
    private final String noAuthorizedClientsServerKeystore = ((Object)((Object)this)).getClass().getClassLoader().getResource("no_trusted_clients_keystore.jks").getPath();
    private final String defaultTrustedClientTruststore = ((Object)((Object)this)).getClass().getClassLoader().getResource("default_client_truststore.jks").getPath();
    private final String sniTrustedClientTruststore = ((Object)((Object)this)).getClass().getClassLoader().getResource("sni_client_truststore.jks").getPath();

    public /* synthetic */ EmbeddedCacheManager protected$cacheManager(HotRodSniFunctionalTest x$1) {
        return x$1.cacheManager;
    }

    private String defaultServerKeystore() {
        return this.defaultServerKeystore;
    }

    private String sniServerKeystore() {
        return this.sniServerKeystore;
    }

    private String noAuthorizedClientsServerKeystore() {
        return this.noAuthorizedClientsServerKeystore;
    }

    private String defaultTrustedClientTruststore() {
        return this.defaultTrustedClientTruststore;
    }

    private String sniTrustedClientTruststore() {
        return this.sniTrustedClientTruststore;
    }

    @AfterMethod
    public void afterMethod() {
        HotRodTestingUtil$.MODULE$.killClient(this.hotRodClient());
        ServerTestingUtil.killServer((AbstractProtocolServer)this.hotRodServer());
    }

    public void testServerAndClientWithDefaultSslContext(Method m) {
        this.hotRodServer_$eq(new HotrodServerBuilder().addSniDomain("*", this.defaultServerKeystore(), "secret", this.defaultTrustedClientTruststore(), "secret").build());
        this.hotRodClient_$eq(new HotrodClientBuilder(this, this.hotRodServer()).useSslConfiguration(this.defaultServerKeystore(), "secret", this.defaultTrustedClientTruststore(), "secret").build());
        this.client().assertPut(m);
        HotRodTestingUtil$.MODULE$.assertSuccess(this.client().assertGet(m), HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testServerAndClientWithSniSslContext(Method m) {
        this.hotRodServer_$eq(new HotrodServerBuilder().addSniDomain("*", this.noAuthorizedClientsServerKeystore(), "secret", this.sniTrustedClientTruststore(), "secret").addSniDomain("sni", this.sniServerKeystore(), "secret", this.sniTrustedClientTruststore(), "secret").build());
        this.hotRodClient_$eq(new HotrodClientBuilder(this, this.hotRodServer()).useSslConfiguration(this.sniServerKeystore(), "secret", this.sniTrustedClientTruststore(), "secret").addSniDomain((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sni"})).build());
        this.client().assertPut(m);
        HotRodTestingUtil$.MODULE$.assertSuccess(this.client().assertGet(m), HotRodTestingUtil$.MODULE$.v(m));
    }

    public void testServerWithNotMatchingDefaultAndClientWithSNI(Method m) {
        this.hotRodServer_$eq(new HotrodServerBuilder().addSniDomain("*", this.noAuthorizedClientsServerKeystore(), "secret", this.sniTrustedClientTruststore(), "secret").build());
        this.hotRodClient_$eq(new HotrodClientBuilder(this, this.hotRodServer()).useSslConfiguration(this.sniServerKeystore(), "secret", this.sniTrustedClientTruststore(), "secret").addSniDomain((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sni"})).build());
        Op op = new Op(160, 1, 20, this.client().defaultCacheName(), HotRodTestingUtil$.MODULE$.k(m), 0, 0, HotRodTestingUtil$.MODULE$.v(m), 0, 0L, 1, 0);
        boolean success = this.client().writeOp(op, false);
        Assert.assertFalse((boolean)success);
    }

    public Null$ createStartHotRodServer(EmbeddedCacheManager cacheManager) {
        return null;
    }

    public Null$ connectClient() {
        return null;
    }

    public class HotrodServerBuilder {
        private final String ip;
        private final HotRodServerConfigurationBuilder builder;

        public String ip() {
            return this.ip;
        }

        public HotRodServerConfigurationBuilder builder() {
            return this.builder;
        }

        public HotrodServerBuilder addSniDomain(String domain, String keystoreFileName, String keystorePassoword, String truststoreFileName, String truststorePassword) {
            this.builder().ssl().enable().sniHostName(domain).keyStoreFileName(keystoreFileName).keyStorePassword(keystorePassoword.toCharArray()).trustStoreFileName(truststoreFileName).trustStorePassword(truststorePassword.toCharArray());
            return this;
        }

        public HotRodServer build() {
            return HotRodTestingUtil$.MODULE$.startHotRodServer(this.org$infinispan$server$hotrod$HotRodSniFunctionalTest$HotrodServerBuilder$$$outer().protected$cacheManager(this.org$infinispan$server$hotrod$HotRodSniFunctionalTest$HotrodServerBuilder$$$outer()), HotRodTestingUtil$.MODULE$.serverPort(), -1L, this.builder());
        }

        public /* synthetic */ HotRodSniFunctionalTest org$infinispan$server$hotrod$HotRodSniFunctionalTest$HotrodServerBuilder$$$outer() {
            return HotRodSniFunctionalTest.this;
        }

        public HotrodServerBuilder() {
            if (HotRodSniFunctionalTest.this == null) {
                throw null;
            }
            this.ip = "127.0.0.1";
            this.builder = (HotRodServerConfigurationBuilder)new HotRodServerConfigurationBuilder().proxyHost("127.0.0.1").proxyPort(HotRodTestingUtil$.MODULE$.serverPort()).idleTimeout(0);
        }
    }

    public class HotrodClientBuilder {
        private final HotRodServer hotRodServer;
        private SSLContext sslContext;
        private SSLEngine sslEngine;
        public final /* synthetic */ HotRodSniFunctionalTest $outer;

        public SSLContext sslContext() {
            return this.sslContext;
        }

        public void sslContext_$eq(SSLContext x$1) {
            this.sslContext = x$1;
        }

        public SSLEngine sslEngine() {
            return this.sslEngine;
        }

        public void sslEngine_$eq(SSLEngine x$1) {
            this.sslEngine = x$1;
        }

        public HotrodClientBuilder useSslConfiguration(String keystoreFileName, String keystorePassoword, String truststoreFileName, String truststorePassword) {
            this.sslContext_$eq(SslContextFactory.getContext((String)keystoreFileName, (char[])keystorePassoword.toCharArray(), (String)truststoreFileName, (char[])truststorePassword.toCharArray()));
            this.sslEngine_$eq(SslContextFactory.getEngine((SSLContext)this.sslContext(), (boolean)true, (boolean)false));
            return this;
        }

        public HotrodClientBuilder addSniDomain(Seq<String> sniNames) {
            if (sniNames.nonEmpty()) {
                SSLParameters sslParameters = this.sslEngine().getSSLParameters();
                List hosts = ((TraversableOnce)sniNames.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SNIHostName apply(String s) {
                        return new SNIHostName(s);
                    }
                }, Seq$.MODULE$.canBuildFrom())).toList();
                sslParameters.setServerNames((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)hosts).asJava());
                this.sslEngine().setSSLParameters(sslParameters);
            }
            return this;
        }

        public HotRodClient build() {
            return new HotRodClient("127.0.0.1", this.hotRodServer.getPort(), this.org$infinispan$server$hotrod$HotRodSniFunctionalTest$HotrodClientBuilder$$$outer().cacheName(), 60, 20, this.sslEngine());
        }

        public /* synthetic */ HotRodSniFunctionalTest org$infinispan$server$hotrod$HotRodSniFunctionalTest$HotrodClientBuilder$$$outer() {
            return this.$outer;
        }

        public HotrodClientBuilder(HotRodSniFunctionalTest $outer, HotRodServer hotRodServer) {
            this.hotRodServer = hotRodServer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

