/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.test.TestClientListener;
import org.infinispan.server.hotrod.test.TestCustomEvent;
import org.infinispan.server.hotrod.test.TestKeyEvent;
import org.infinispan.server.hotrod.test.TestKeyWithVersionEvent;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.TestingUtil;

class ClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Log log = (Log)LogFactory.getLog(ClientHandler.class, Log.class);
    final int rspTimeoutSeconds;
    private Map<Long, TestResponse> responses = new ConcurrentHashMap<Long, TestResponse>();
    private Map<WrappedByteArray, TestClientListener> clientListeners = new ConcurrentHashMap<WrappedByteArray, TestClientListener>();

    ClientHandler(int rspTimeoutSeconds) {
        this.rspTimeoutSeconds = rspTimeoutSeconds;
    }

    void addClientListener(TestClientListener listener) {
        this.clientListeners.put(new WrappedByteArray(listener.getId()), listener);
    }

    void removeClientListener(byte[] listenerId) {
        this.clientListeners.remove(new WrappedByteArray(listenerId));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof TestKeyWithVersionEvent) {
            TestKeyWithVersionEvent e = (TestKeyWithVersionEvent)((Object)msg);
            switch (e.getOperation()) {
                case CACHE_ENTRY_CREATED_EVENT: {
                    this.clientListeners.get(new WrappedByteArray(e.listenerId)).onCreated(e);
                    break;
                }
                case CACHE_ENTRY_MODIFIED_EVENT: {
                    this.clientListeners.get(new WrappedByteArray(e.listenerId)).onModified(e);
                }
            }
        } else if (msg instanceof TestKeyEvent) {
            TestKeyEvent e = (TestKeyEvent)((Object)msg);
            this.clientListeners.get(new WrappedByteArray(e.listenerId)).onRemoved(e);
        } else if (msg instanceof TestCustomEvent) {
            TestCustomEvent e = (TestCustomEvent)((Object)msg);
            this.clientListeners.get(new WrappedByteArray(e.listenerId)).onCustom(e);
        } else if (msg instanceof TestResponse) {
            TestResponse resp = (TestResponse)((Object)msg);
            log.tracef("Put %s in responses", (Object)resp);
            this.responses.put(resp.getMessageId(), resp);
        } else {
            throw new IllegalArgumentException("Unsupport object: " + msg);
        }
    }

    TestResponse getResponse(long messageId) {
        TestResponse v;
        int i = 0;
        do {
            if ((v = this.responses.get(messageId)) != null) continue;
            TestingUtil.sleepThread((long)100L);
            ++i;
        } while (v == null && i < this.rspTimeoutSeconds * 10);
        return v;
    }
}

