/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import io.netty.util.concurrent.Future;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtils;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public abstract class HotRodSingleNodeTest
extends SingleCacheManagerTest {
    public static final String cacheName = "HotRodCache";
    protected HotRodServer hotRodServer;
    HotRodClient hotRodClient;
    AdvancedCache<byte[], byte[]> advancedCache;
    private final String hotRodJmxDomain = ((Object)((Object)this)).getClass().getSimpleName();

    protected EmbeddedCacheManager createCacheManager() {
        EmbeddedCacheManager cacheManager = this.createTestCacheManager();
        Cache cache = cacheManager.getCache(cacheName);
        this.advancedCache = cache.getAdvancedCache();
        return cacheManager;
    }

    @Test(enabled=false)
    protected void setup() throws Exception {
        super.setup();
        this.hotRodServer = this.createStartHotRodServer(this.cacheManager);
        this.hotRodClient = this.connectClient();
    }

    protected EmbeddedCacheManager createTestCacheManager() {
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtils.hotRodCacheConfiguration());
    }

    protected HotRodServer createStartHotRodServer(EmbeddedCacheManager cacheManager) {
        return HotRodTestingUtils.startHotRodServer(cacheManager);
    }

    @AfterClass(alwaysRun=true)
    public void destroyAfterClass() {
        this.log.debug((Object)"Test finished, close cache, client and Hot Rod server");
        super.destroyAfterClass();
        this.shutdownClient().awaitUninterruptibly();
        ServerTestingUtil.killServer((AbstractProtocolServer)this.hotRodServer);
    }

    protected HotRodServer server() {
        return this.hotRodServer;
    }

    protected HotRodClient client() {
        return this.hotRodClient;
    }

    protected String jmxDomain() {
        return this.hotRodJmxDomain;
    }

    protected Future<?> shutdownClient() {
        return HotRodTestingUtils.killClient(this.hotRodClient);
    }

    protected HotRodClient connectClient() {
        return new HotRodClient("127.0.0.1", this.hotRodServer.getPort(), cacheName, 60, 21);
    }
}

