/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unstable"}, testName="server.hotrod.HotRod10ReplicationTest", description="ISPN-3804")
public class HotRod10ReplicationTest
extends HotRodMultiNodeTest {
    @Override
    protected String cacheName() {
        return "hotRodReplSync";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        ConfigurationBuilder config = HotRodTestingUtil.hotRodCacheConfiguration(HotRod10ReplicationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        config.clustering().stateTransfer().fetchInMemoryState(true);
        return config;
    }

    @Override
    protected byte protocolVersion() {
        return 10;
    }

    public void testReplicatedPut(Method m) {
        TestResponse resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
    }

    public void testReplicatedPutIfAbsent(Method m) {
        HotRodTestingUtil.assertKeyDoesNotExist(this.clients().get(0).assertGet(m));
        HotRodTestingUtil.assertKeyDoesNotExist(this.clients().get(1).assertGet(m));
        TestResponse resp = this.clients().get(0).putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(this.clients().get(1).putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-")), OperationStatus.OperationNotExecuted);
    }

    public void testReplicatedReplace(Method m) {
        TestResponse resp = this.clients().get(0).replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.OperationNotExecuted);
        resp = this.clients().get(1).replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.OperationNotExecuted);
        this.clients().get(1).assertPut(m);
        resp = this.clients().get(1).replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(this.clients().get(0).assertGet(m), HotRodTestingUtil.v(m, "v1-"));
        resp = this.clients().get(0).replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(this.clients().get(1).assertGet(m), HotRodTestingUtil.v(m, "v2-"));
    }

    public void testPingWithTopologyAwareClient() {
        TestResponse resp = this.clients().get(0).ping();
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        resp = this.clients().get(1).ping((byte)1, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        resp = this.clients().get(0).ping((byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = this.clients().get(1).ping((byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = this.clients().get(1).ping((byte)2, 1 + 2 * this.nodeCount());
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplicatedPutWithTopologyChanges(Method m) {
        TestResponse resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), (byte)1, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
        resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = this.clients().get(1).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), (byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertTopologyReceived(resp.topologyResponse, this.servers(), this.currentServerTopologyId());
        resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v3-"), (byte)2, 1 + 2 * this.nodeCount());
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v3-"));
        HotRodServer newServer = this.startClusteredServer(this.servers().get(1).getPort() + 25);
        try {
            resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v4-"), (byte)2, 1 + 2 * this.nodeCount());
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            AssertJUnit.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
            AbstractTestTopologyAwareResponse topoResp = resp.asTopologyAwareResponse();
            AssertJUnit.assertEquals((int)topoResp.members.size(), (int)(this.nodeCount() + 1));
            Stream.concat(Stream.of(newServer), this.servers().stream()).map(HotRodServer::getAddress).forEach(addr -> AssertJUnit.assertTrue((boolean)topoResp.members.contains(addr)));
            HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v4-"));
        }
        catch (Throwable throwable) {
            this.stopClusteredServer(newServer);
            TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            throw throwable;
        }
        this.stopClusteredServer(newServer);
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v5-"), (byte)2, 1 + 2 * this.nodeCount() + 2);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
        AbstractTestTopologyAwareResponse topoResp1 = resp.asTopologyAwareResponse();
        AssertJUnit.assertEquals((int)topoResp1.members.size(), (int)this.nodeCount());
        this.servers().stream().map(HotRodServer::getAddress).forEach(addr -> AssertJUnit.assertTrue((boolean)topoResp1.members.contains(addr)));
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v5-"));
        HotRodServer crashingServer = this.startClusteredServer(this.servers().get(1).getPort() + 25);
        try {
            resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v6-"), (byte)2, 1 + 2 * this.nodeCount() + 4);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            AssertJUnit.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
            AbstractTestTopologyAwareResponse topoResp2 = resp.asTopologyAwareResponse();
            AssertJUnit.assertEquals((int)topoResp2.members.size(), (int)(this.nodeCount() + 1));
            Stream.concat(Stream.of(crashingServer), this.servers().stream()).map(HotRodServer::getAddress).forEach(addr -> AssertJUnit.assertTrue((boolean)topoResp2.members.contains(addr)));
            HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v6-"));
        }
        catch (Throwable throwable) {
            this.stopClusteredServer(crashingServer);
            TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
            throw throwable;
        }
        this.stopClusteredServer(crashingServer);
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0, this.cacheName()), this.cache(1, this.cacheName())});
        resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v7-"), (byte)2, 1 + 2 * this.nodeCount() + 6);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((int)resp.topologyResponse.topologyId, (int)this.currentServerTopologyId());
        AbstractTestTopologyAwareResponse topoResp3 = resp.asTopologyAwareResponse();
        AssertJUnit.assertEquals((int)topoResp3.members.size(), (int)this.nodeCount());
        this.servers().stream().map(HotRodServer::getAddress).forEach(addr -> AssertJUnit.assertTrue((boolean)topoResp3.members.contains(addr)));
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v7-"));
        resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v8-"), (byte)3, 1 + this.nodeCount());
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        this.checkTopologyReceived(resp.topologyResponse, this.servers(), this.cacheName());
        HotRodTestingUtil.assertSuccess(this.clients().get(1).get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v8-"));
    }

    protected void checkTopologyReceived(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName) {
        HotRodTestingUtil.assertNoHashTopologyReceived(topoResp, servers, cacheName, this.currentServerTopologyId());
    }
}

