/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodAsymmetricClusterTest")
public class HotRodAsymmetricClusterTest
extends HotRodMultiNodeTest {
    @Override
    protected String cacheName() {
        return "asymmetricCache";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        return HotRodTestingUtil.hotRodCacheConfiguration(HotRodAsymmetricClusterTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
    }

    @Override
    protected void createCacheManagers() {
        for (int i = 0; i < 2; ++i) {
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
            this.cacheManagers.add(cm);
            if (i != 0) continue;
            cm.defineConfiguration(this.cacheName(), this.createCacheConfig().build());
        }
    }

    public void testPutInCacheDefinedNode(Method m) {
        TestResponse resp = this.clients().get(0).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
    }

    public void testPutInNonCacheDefinedNode(Method m) {
        TestResponse resp = this.clients().get(1).put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.ParseError);
    }
}

