/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.group.ChannelGroup;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestAuthMechListResponse;
import org.infinispan.server.hotrod.test.TestAuthResponse;
import org.infinispan.server.hotrod.test.TestCallbackHandler;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodAuthenticationTest")
public class HotRodAuthenticationTest
extends HotRodSingleNodeTest {
    @Override
    public HotRodServer createStartHotRodServer(EmbeddedCacheManager cacheManager) {
        SimpleServerAuthenticationProvider ssap = new SimpleServerAuthenticationProvider();
        ssap.addUser("user", "realm", "password".toCharArray(), new String[0]);
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.authentication().enable().addAllowedMech("CRAM-MD5").serverAuthenticationProvider((ServerAuthenticationProvider)ssap).serverName("localhost").addMechProperty("javax.security.sasl.policy.noanonymous", "true");
        return HotRodTestingUtil.startHotRodServer(cacheManager, HotRodTestingUtil.serverPort(), 0L, builder);
    }

    public void testAuthMechList(Method m) {
        TestAuthMechListResponse a = this.client().authMechList();
        AssertJUnit.assertEquals((int)1, (int)a.mechs.size());
        AssertJUnit.assertTrue((boolean)a.mechs.contains("CRAM-MD5"));
        AssertJUnit.assertEquals((int)1, (int)this.server().getDecoder().getTransport().getNumberOfLocalConnections());
    }

    public void testAuth(Method m) throws SaslException {
        HashMap props = new HashMap();
        SaslClient sc = Sasl.createSaslClient(new String[]{"CRAM-MD5"}, null, "hotrod", "localhost", props, new TestCallbackHandler("user", "realm", "password".toCharArray()));
        TestAuthResponse res = this.client().auth(sc);
        AssertJUnit.assertTrue((boolean)res.complete);
        AssertJUnit.assertEquals((int)1, (int)this.server().getDecoder().getTransport().getNumberOfLocalConnections());
    }

    public void testUnauthorizedOpCloseConnection(Method m) {
        ChannelGroup acceptedChannels = (ChannelGroup)TestingUtil.extractField((Object)this.server().getDecoder().getTransport(), (String)"acceptedChannels");
        acceptedChannels.close().awaitUninterruptibly();
        try {
            this.client().assertPutFail(m);
        }
        finally {
            AssertJUnit.assertEquals((int)0, (int)this.server().getDecoder().getTransport().getNumberOfLocalConnections());
        }
    }
}

