/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestBulkGetKeysResponse;
import org.infinispan.server.hotrod.test.TestBulkGetResponse;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestGetResponse;
import org.infinispan.server.hotrod.test.TestGetWithVersionResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestResponseWithPrevious;
import org.infinispan.server.hotrod.test.TestSizeResponse;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodFunctionalTest")
public class HotRodFunctionalTest
extends HotRodSingleNodeTest {
    public void testUnknownCommand(Method m) {
        OperationStatus status = this.client().execute((int)160, (byte)121, (String)this.cacheName, (byte[])HotRodTestingUtil.k((Method)m), (int)0, (int)0, (byte[])HotRodTestingUtil.v((Method)m), (long)0L, (byte)1, (int)0).status;
        Assert.assertEquals((Object)status, (Object)OperationStatus.UnknownOperation, (String)("Status should have been 'UnknownOperation' but instead was: " + status));
    }

    public void testUnknownMagic(Method m) {
        this.client().assertPut(m);
        OperationStatus status = this.client().executeExpectBadMagic((int)102, (byte)1, (String)this.cacheName, (byte[])HotRodTestingUtil.k((Method)m), (int)0, (int)0, (byte[])HotRodTestingUtil.v((Method)m), (long)0L).status;
        Assert.assertEquals((Object)status, (Object)OperationStatus.InvalidMagicOrMsgId, (String)("Status should have been 'InvalidMagicOrMsgId' but instead was: " + status));
    }

    public void testPutBasic(Method m) {
        this.client().assertPut(m);
    }

    public void testPutOnDefaultCache(Method m) {
        TestResponse resp = this.client().execute(160, (byte)1, "", HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, (byte)1, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertHotRodEquals(this.cacheManager, HotRodTestingUtil.k(m), HotRodTestingUtil.v(m));
    }

    public void testPutOnUndefinedCache(Method m) {
        TestErrorResponse resp = (TestErrorResponse)this.client().execute(160, (byte)1, "boomooo", HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, (byte)1, 0);
        AssertJUnit.assertTrue((boolean)resp.msg.contains("CacheNotFoundException"));
        Assert.assertEquals((Object)resp.status, (Object)OperationStatus.ParseError, (String)("Status should have been 'ParseError' but instead was: " + resp.status));
        this.client().assertPut(m);
    }

    public void testPutOnTopologyCache(Method m) {
        TestErrorResponse resp = (TestErrorResponse)this.client().execute(160, (byte)1, "___hotRodTopologyCache", HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, (byte)1, 0);
        AssertJUnit.assertTrue((boolean)resp.msg.contains("CacheNotFoundException"));
        Assert.assertEquals((Object)resp.status, (Object)OperationStatus.ParseError, (String)("Status should have been 'ParseError' but instead was: " + resp.status));
        this.client().assertPut(m);
    }

    public void testPutWithLifespan(Method m) throws InterruptedException {
        this.client().assertPut(m, 1, 0);
        Thread.sleep(1100L);
        HotRodTestingUtil.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testPutWithMaxIdle(Method m) throws InterruptedException {
        this.client().assertPut(m, 0, 1);
        Thread.sleep(1100L);
        HotRodTestingUtil.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testPutWithPreviousValue(Method m) {
        TestResponseWithPrevious resp = (TestResponseWithPrevious)this.client().put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 1);
        this.assertSuccessPrevious(resp, null);
        resp = (TestResponseWithPrevious)this.client().put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), 1);
        this.assertSuccessPrevious(resp, HotRodTestingUtil.v(m));
    }

    public void testGetBasic(Method m) {
        this.client().assertPut(m);
        HotRodTestingUtil.assertSuccess(this.client().assertGet(m), HotRodTestingUtil.v(m));
    }

    public void testGetDoesNotExist(Method m) {
        HotRodTestingUtil.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testPutIfAbsentNotExist(Method m) {
        TestResponse resp = this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
    }

    public void testPutIfAbsentExist(Method m) {
        this.client().assertPut(m);
        TestResponse resp = this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.OperationNotExecuted);
    }

    public void testPutIfAbsentWithLifespan(Method m) throws InterruptedException {
        TestResponse resp = this.client().putIfAbsent(HotRodTestingUtil.k(m), 1, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        Thread.sleep(1100L);
        HotRodTestingUtil.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testPutIfAbsentWithMaxIdle(Method m) throws InterruptedException {
        TestResponse resp = this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 1, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        Thread.sleep(1100L);
        HotRodTestingUtil.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testPutIfAbsentWithPreviousValue(Method m) {
        TestResponse resp1 = this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0);
        HotRodTestingUtil.assertStatus(resp1, OperationStatus.Success);
        TestResponseWithPrevious resp2 = (TestResponseWithPrevious)this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), 1);
        this.assertNotExecutedPrevious(resp2, HotRodTestingUtil.v(m));
    }

    public void testReplaceBasic(Method m) {
        this.client().assertPut(m);
        TestResponse resp = this.client().replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertSuccess(this.client().assertGet(m), HotRodTestingUtil.v(m, "v1-"));
    }

    public void testNotReplaceIfNotPresent(Method m) {
        TestResponse resp = this.client().replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.OperationNotExecuted);
    }

    public void testReplaceWithLifespan(Method m) throws InterruptedException {
        this.client().assertPut(m);
        TestResponse resp = this.client().replace(HotRodTestingUtil.k(m), 1, 0, HotRodTestingUtil.v(m, "v1-"));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        Thread.sleep(1100L);
        HotRodTestingUtil.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testReplaceWithMaxIdle(Method m) throws InterruptedException {
        this.client().assertPut(m);
        TestResponse resp = this.client().replace(HotRodTestingUtil.k(m), 0, 1, HotRodTestingUtil.v(m, "v1-"));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        Thread.sleep(1100L);
        HotRodTestingUtil.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testReplaceWithPreviousValue(Method m) {
        TestResponse resp = this.client().replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.OperationNotExecuted);
        TestResponseWithPrevious resp2 = (TestResponseWithPrevious)this.client().put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), 1);
        this.assertSuccessPrevious(resp2, null);
        TestResponseWithPrevious resp3 = (TestResponseWithPrevious)this.client().replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v3-"), 1);
        this.assertSuccessPrevious(resp3, HotRodTestingUtil.v(m, "v2-"));
    }

    public void testGetWithVersionBasic(Method m) {
        this.client().assertPut(m);
        HotRodTestingUtil.assertSuccess(this.client().getWithVersion(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m), 0);
    }

    public void testGetWithVersionDoesNotExist(Method m) {
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertKeyDoesNotExist(resp);
        AssertJUnit.assertTrue((resp.dataVersion == 0L ? 1 : 0) != 0);
    }

    public void testGetWithMetadata(Method m) {
        this.client().assertPut(m);
        HotRodTestingUtil.assertSuccess(this.client().assertGet(m), HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertSuccess(this.client().getWithMetadata(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m), -1, -1);
        this.client().remove(HotRodTestingUtil.k(m));
        this.client().assertPut(m, 10, 5);
        HotRodTestingUtil.assertSuccess(this.client().getWithMetadata(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m), 10, 5);
    }

    public void testReplaceIfUnmodifiedBasic(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(resp, HotRodTestingUtil.v(m), 0);
        TestResponse resp2 = this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"), resp.dataVersion);
        HotRodTestingUtil.assertStatus(resp2, OperationStatus.Success);
    }

    public void testReplaceIfUnmodifiedNotFound(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(resp, HotRodTestingUtil.v(m), 0);
        TestResponse resp2 = this.client().replaceIfUnmodified(HotRodTestingUtil.k(m, "k1-"), 0, 0, HotRodTestingUtil.v(m, "v1-"), resp.dataVersion);
        HotRodTestingUtil.assertStatus(resp2, OperationStatus.KeyDoesNotExist);
    }

    public void testReplaceIfUnmodifiedNotExecuted(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(resp, HotRodTestingUtil.v(m), 0);
        TestResponse resp2 = this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"), resp.dataVersion);
        HotRodTestingUtil.assertStatus(resp2, OperationStatus.Success);
        TestGetWithVersionResponse resp3 = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(resp3, HotRodTestingUtil.v(m, "v1-"), 0);
        AssertJUnit.assertTrue((resp.dataVersion != resp3.dataVersion ? 1 : 0) != 0);
        TestResponse resp4 = this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), resp.dataVersion);
        HotRodTestingUtil.assertStatus(resp4, OperationStatus.OperationNotExecuted);
        TestResponse resp5 = this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), resp3.dataVersion);
        HotRodTestingUtil.assertStatus(resp5, OperationStatus.Success);
    }

    public void testReplaceIfUnmodifiedWithPreviousValue(Method m) {
        TestResponse resp = this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 999L, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.KeyDoesNotExist);
        this.client().assertPut(m);
        TestGetWithVersionResponse getResp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(getResp, HotRodTestingUtil.v(m), 0);
        TestResponseWithPrevious resp2 = (TestResponseWithPrevious)this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), 888L, 1);
        this.assertNotExecutedPrevious(resp2, HotRodTestingUtil.v(m));
        TestResponseWithPrevious resp3 = (TestResponseWithPrevious)this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v3-"), getResp.dataVersion, 1);
        this.assertSuccessPrevious(resp3, HotRodTestingUtil.v(m));
    }

    public void testReplaceIfUnmodifiedWithExpiry(Method m) throws InterruptedException {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(resp, HotRodTestingUtil.v(m), 0);
        AssertJUnit.assertTrue((resp.dataVersion != 0L ? 1 : 0) != 0);
        int lifespanSecs = 2;
        long lifespan = TimeUnit.SECONDS.toMillis(lifespanSecs);
        long startTime = System.currentTimeMillis();
        TestResponse resp2 = this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), lifespanSecs, 0, HotRodTestingUtil.v(m, "v1-"), resp.dataVersion);
        HotRodTestingUtil.assertStatus(resp2, OperationStatus.Success);
        while (System.currentTimeMillis() < startTime + lifespan) {
            TestGetResponse getResponse = this.client().assertGet(m);
            if (System.currentTimeMillis() >= startTime + lifespan) continue;
            HotRodTestingUtil.assertSuccess(getResponse, HotRodTestingUtil.v(m, "v1-"));
            Thread.sleep(100L);
        }
        this.waitNotFound(startTime, lifespan, m);
        HotRodTestingUtil.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    private void waitNotFound(long startTime, long lifespan, Method m) throws InterruptedException {
        while (System.currentTimeMillis() < startTime + lifespan + 20000L && OperationStatus.Success == this.client().assertGet(m).getStatus()) {
            Thread.sleep(50L);
        }
    }

    public void testRemoveBasic(Method m) {
        this.client().assertPut(m);
        TestResponse resp = this.client().remove(HotRodTestingUtil.k(m));
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testRemoveDoesNotExist(Method m) {
        HotRodTestingUtil.assertStatus(this.client().remove(HotRodTestingUtil.k(m)), OperationStatus.KeyDoesNotExist);
    }

    public void testRemoveWithPreviousValue(Method m) {
        TestResponse resp = this.client().remove(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.KeyDoesNotExist);
        this.client().assertPut(m);
        TestResponseWithPrevious resp2 = (TestResponseWithPrevious)this.client().remove(HotRodTestingUtil.k(m), 1);
        this.assertSuccessPrevious(resp2, HotRodTestingUtil.v(m));
    }

    public void testRemoveIfUnmodifiedBasic(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(resp, HotRodTestingUtil.v(m), 0);
        AssertJUnit.assertTrue((resp.dataVersion != 0L ? 1 : 0) != 0);
        TestResponse resp2 = this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"), resp.dataVersion);
        HotRodTestingUtil.assertStatus(resp2, OperationStatus.Success);
        HotRodTestingUtil.assertKeyDoesNotExist(this.client().assertGet(m));
    }

    public void testRemoveIfUnmodifiedNotFound(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(resp, HotRodTestingUtil.v(m), 0);
        TestResponse resp2 = this.client().removeIfUnmodified(HotRodTestingUtil.k(m, "k1-"), 0, 0, HotRodTestingUtil.v(m, "v1-"), resp.dataVersion);
        HotRodTestingUtil.assertStatus(resp2, OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertSuccess(this.client().assertGet(m), HotRodTestingUtil.v(m));
    }

    public void testRemoveIfUnmodifiedNotExecuted(Method m) {
        this.client().assertPut(m);
        TestGetWithVersionResponse resp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(resp, HotRodTestingUtil.v(m), 0);
        TestResponse resp2 = this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"), resp.dataVersion);
        HotRodTestingUtil.assertStatus(resp2, OperationStatus.Success);
        TestGetWithVersionResponse resp3 = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(resp3, HotRodTestingUtil.v(m, "v1-"), 0);
        AssertJUnit.assertTrue((resp.dataVersion != resp3.dataVersion ? 1 : 0) != 0);
        TestResponse resp4 = this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), resp.dataVersion);
        HotRodTestingUtil.assertStatus(resp4, OperationStatus.OperationNotExecuted);
        TestResponse resp5 = this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), resp3.dataVersion);
        HotRodTestingUtil.assertStatus(resp5, OperationStatus.Success);
    }

    public void testRemoveIfUmodifiedWithPreviousValue(Method m) {
        TestResponse resp = this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 999L, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.KeyDoesNotExist);
        this.client().assertPut(m);
        TestGetWithVersionResponse getResp = this.client().getWithVersion(HotRodTestingUtil.k(m), 0);
        HotRodTestingUtil.assertSuccess(getResp, HotRodTestingUtil.v(m), 0);
        TestResponseWithPrevious resp2 = (TestResponseWithPrevious)this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 888L, 1);
        this.assertNotExecutedPrevious(resp2, HotRodTestingUtil.v(m));
        TestResponseWithPrevious resp3 = (TestResponseWithPrevious)this.client().removeIfUnmodified(HotRodTestingUtil.k(m), getResp.dataVersion, 1);
        this.assertSuccessPrevious(resp3, HotRodTestingUtil.v(m));
    }

    public void testContainsKeyBasic(Method m) {
        this.client().assertPut(m);
        HotRodTestingUtil.assertStatus(this.client().containsKey(HotRodTestingUtil.k(m), 0), OperationStatus.Success);
    }

    public void testContainsKeyDoesNotExist(Method m) {
        HotRodTestingUtil.assertStatus(this.client().containsKey(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
    }

    public void testClear(Method m) {
        byte[] key;
        int i;
        for (i = 1; i <= 5; ++i) {
            key = HotRodTestingUtil.k(m, "k" + i + "-");
            byte[] value = HotRodTestingUtil.v(m, "v" + i + "-");
            HotRodTestingUtil.assertStatus(this.client().put(key, 0, 0, value), OperationStatus.Success);
            HotRodTestingUtil.assertStatus(this.client().containsKey(key, 0), OperationStatus.Success);
        }
        HotRodTestingUtil.assertStatus(this.client().clear(), OperationStatus.Success);
        for (i = 1; i <= 5; ++i) {
            key = HotRodTestingUtil.k(m, "k" + i + "-");
            HotRodTestingUtil.assertStatus(this.client().containsKey(key, 0), OperationStatus.KeyDoesNotExist);
        }
    }

    public void testStatsDisabled(Method m) {
        Map<String, String> s = this.client().stats();
        Assert.assertEquals((String)s.get("timeSinceStart"), (String)"-1");
        Assert.assertEquals((String)s.get("currentNumberOfEntries"), (String)"-1");
        Assert.assertEquals((String)s.get("totalNumberOfEntries"), (String)"-1");
        Assert.assertEquals((String)s.get("stores"), (String)"-1");
        Assert.assertEquals((String)s.get("retrievals"), (String)"-1");
        Assert.assertEquals((String)s.get("hits"), (String)"-1");
        Assert.assertEquals((String)s.get("misses"), (String)"-1");
        Assert.assertEquals((String)s.get("removeHits"), (String)"-1");
        Assert.assertEquals((String)s.get("removeMisses"), (String)"-1");
    }

    public void testPing(Method m) {
        HotRodTestingUtil.assertStatus(this.client().ping(), OperationStatus.Success);
    }

    public void testPingWithTopologyAwareClient(Method m) {
        TestResponse resp = this.client().ping();
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        resp = this.client().ping((byte)1, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        resp = this.client().ping((byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
        resp = this.client().ping((byte)3, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        Assert.assertEquals((Object)resp.topologyResponse, null);
    }

    public void testBulkGet(Method m) {
        List filtered;
        byte[] key;
        int i;
        int size = 100;
        for (int i2 = 0; i2 < size; ++i2) {
            TestResponse resp = this.client().put(HotRodTestingUtil.k(m, i2 + "k-"), 0, 0, HotRodTestingUtil.v(m, i2 + "v-"));
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        }
        TestBulkGetResponse resp = this.client().bulkGet();
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        Map<byte[], byte[]> bulkData = resp.bulkData;
        Assert.assertEquals((int)size, (int)bulkData.size());
        for (i = 0; i < size; ++i) {
            key = HotRodTestingUtil.k(m, i + "k-");
            filtered = bulkData.entrySet().stream().filter(entry -> Arrays.equals((byte[])entry.getKey(), key)).collect(Collectors.toList());
            Assert.assertEquals((int)1, (int)filtered.size());
        }
        size = 50;
        resp = this.client().bulkGet(size);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        bulkData = resp.bulkData;
        Assert.assertEquals((int)size, (int)bulkData.size());
        for (i = 0; i < size; ++i) {
            key = HotRodTestingUtil.k(m, i + "k-");
            filtered = bulkData.entrySet().stream().filter(entry -> Arrays.equals((byte[])entry.getKey(), key)).collect(Collectors.toList());
            if (filtered.isEmpty()) continue;
            AssertJUnit.assertTrue((boolean)Arrays.equals((byte[])((Map.Entry)filtered.get(0)).getValue(), HotRodTestingUtil.v(m, i + "v-")));
        }
    }

    public void testBulkGetKeys(Method m) {
        List filtered;
        int finalI;
        int size = 100;
        for (int i = 0; i < size; ++i) {
            TestResponse resp = this.client().put(HotRodTestingUtil.k(m, i + "k-"), 0, 0, HotRodTestingUtil.v(m, i + "v-"));
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        }
        TestBulkGetKeysResponse resp = this.client().bulkGetKeys();
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        Set<byte[]> bulkData = resp.bulkData;
        Assert.assertEquals((int)size, (int)bulkData.size());
        int i = 0;
        while (i < size) {
            finalI = i++;
            filtered = bulkData.stream().filter(bytes -> Arrays.equals(bytes, HotRodTestingUtil.k(m, finalI + "k-"))).collect(Collectors.toList());
            Assert.assertEquals((int)1, (int)filtered.size());
        }
        resp = this.client().bulkGetKeys(1);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        bulkData = resp.bulkData;
        Assert.assertEquals((int)size, (int)bulkData.size());
        i = 0;
        while (i < size) {
            finalI = i++;
            filtered = bulkData.stream().filter(bytes -> Arrays.equals(bytes, HotRodTestingUtil.k(m, finalI + "k-"))).collect(Collectors.toList());
            Assert.assertEquals((int)1, (int)filtered.size());
        }
        resp = this.client().bulkGetKeys(2);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        bulkData = resp.bulkData;
        Assert.assertEquals((int)size, (int)bulkData.size());
        i = 0;
        while (i < size) {
            finalI = i++;
            filtered = bulkData.stream().filter(bytes -> Arrays.equals(bytes, HotRodTestingUtil.k(m, finalI + "k-"))).collect(Collectors.toList());
            Assert.assertEquals((int)1, (int)filtered.size());
        }
    }

    public void testPutBigSizeKey(Method m) {
        byte[] key = TestingUtil.generateRandomString((int)1024).getBytes();
        HotRodTestingUtil.assertStatus(this.client().put(key, 0, 0, HotRodTestingUtil.v(m)), OperationStatus.Success);
    }

    public void testPutBigSizeValue(Method m) {
        byte[] value = TestingUtil.generateRandomString((int)1024).getBytes();
        HotRodTestingUtil.assertStatus(this.client().put(HotRodTestingUtil.k(m), 0, 0, value), OperationStatus.Success);
    }

    public void testSize(Method m) {
        TestSizeResponse sizeStart = this.client().size();
        HotRodTestingUtil.assertStatus(sizeStart, OperationStatus.Success);
        Assert.assertEquals((long)0L, (long)sizeStart.size);
        for (int i = 0; i < 20; ++i) {
            this.client().assertPut(m, "k-" + i, "v-" + i);
        }
        TestSizeResponse sizeEnd = this.client().size();
        HotRodTestingUtil.assertStatus(sizeEnd, OperationStatus.Success);
        Assert.assertEquals((long)20L, (long)sizeEnd.size);
    }

    protected boolean assertSuccessPrevious(TestResponseWithPrevious resp, byte[] expected) {
        if (expected == null) {
            Assert.assertEquals(Optional.empty(), resp.previous);
        } else {
            AssertJUnit.assertTrue((boolean)Arrays.equals(expected, resp.previous.get()));
        }
        return HotRodTestingUtil.assertStatus(resp, OperationStatus.SuccessWithPrevious);
    }

    protected boolean assertNotExecutedPrevious(TestResponseWithPrevious resp, byte[] expected) {
        if (expected == null) {
            Assert.assertEquals(Optional.empty(), resp.previous);
        } else {
            AssertJUnit.assertTrue((boolean)Arrays.equals(expected, resp.previous.get()));
        }
        return HotRodTestingUtil.assertStatus(resp, OperationStatus.NotExecutedWithPrevious);
    }
}

