/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;

public abstract class HotRodSingleNodeTest
extends SingleCacheManagerTest {
    protected String cacheName = "HotRodCache";
    protected HotRodServer hotRodServer;
    protected HotRodClient hotRodClient;
    protected AdvancedCache<byte[], byte[]> advancedCache;
    private String hotRodJmxDomain = ((Object)((Object)this)).getClass().getSimpleName();

    public EmbeddedCacheManager createCacheManager() {
        EmbeddedCacheManager cacheManager = this.createTestCacheManager();
        this.advancedCache = cacheManager.getCache(this.cacheName).getAdvancedCache();
        return cacheManager;
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotRodServer = this.createStartHotRodServer(this.cacheManager);
        this.hotRodClient = this.connectClient();
    }

    protected EmbeddedCacheManager createTestCacheManager() {
        return TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)new GlobalConfigurationBuilder().nonClusteredDefault().defaultCacheName(this.cacheName), (ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    protected HotRodServer createStartHotRodServer(EmbeddedCacheManager cacheManager) {
        return HotRodTestingUtil.startHotRodServer(cacheManager);
    }

    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        this.log.debug((Object)"Test finished, close cache, client and Hot Rod server");
        super.destroyAfterClass();
        this.shutdownClient();
        ServerTestingUtil.killServer((AbstractProtocolServer)this.hotRodServer);
    }

    protected HotRodServer server() {
        return this.hotRodServer;
    }

    protected HotRodClient client() {
        return this.hotRodClient;
    }

    protected String jmxDomain() {
        return this.hotRodJmxDomain;
    }

    protected void shutdownClient() {
        HotRodTestingUtil.killClient(this.hotRodClient);
    }

    protected HotRodClient connectClient() {
        return new HotRodClient("127.0.0.1", this.hotRodServer.getPort(), this.cacheName, 60, 21);
    }
}

