/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.hotrod.HotRodFunctionalTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodSslFunctionalTest")
public class HotRodSslFunctionalTest
extends HotRodFunctionalTest {
    private String keyStoreFileName = ((Object)((Object)this)).getClass().getClassLoader().getResource("default_server_keystore.jks").getPath();
    private String trustStoreFileName = ((Object)((Object)this)).getClass().getClassLoader().getResource("default_client_truststore.jks").getPath();

    @Override
    protected HotRodServer createStartHotRodServer(EmbeddedCacheManager cacheManager) {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        builder.proxyHost(HotRodTestingUtil.host()).proxyPort(HotRodTestingUtil.serverPort()).idleTimeout(0);
        builder.ssl().enable().keyStoreFileName(this.keyStoreFileName).keyStorePassword("secret".toCharArray()).trustStoreFileName(this.trustStoreFileName).trustStorePassword("secret".toCharArray());
        return HotRodTestingUtil.startHotRodServer(cacheManager, HotRodTestingUtil.serverPort(), -1L, builder);
    }

    @Override
    protected HotRodClient connectClient() {
        SslConfiguration ssl = ((HotRodServerConfiguration)this.hotRodServer.getConfiguration()).ssl();
        SSLContext sslContext = SslContextFactory.getContext((String)ssl.keyStoreFileName(), (char[])ssl.keyStorePassword(), (String)ssl.trustStoreFileName(), (char[])ssl.trustStorePassword());
        SSLEngine sslEngine = SslContextFactory.getEngine((SSLContext)sslContext, (boolean)true, (boolean)false);
        return new HotRodClient(HotRodTestingUtil.host(), this.hotRodServer.getPort(), this.cacheName, 60, 20, sslEngine);
    }
}

