/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestSizeResponse;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodWithStoreTest")
public class HotRodWithStoreTest
extends HotRodSingleNodeTest {
    @Override
    public EmbeddedCacheManager createCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(((Object)((Object)this)).getClass().getName());
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)new GlobalConfigurationBuilder().nonClusteredDefault().defaultCacheName(this.cacheName), (ConfigurationBuilder)builder);
        this.advancedCache = cacheManager.getCache(this.cacheName).getAdvancedCache();
        return cacheManager;
    }

    public void testSize(Method m) {
        TestSizeResponse sizeStart = this.client().size();
        HotRodTestingUtil.assertStatus(sizeStart, OperationStatus.Success);
        AssertJUnit.assertEquals((long)0L, (long)sizeStart.size);
        for (int i = 0; i < 20; ++i) {
            this.client().assertPut(m, "k-" + i, "v-" + i);
        }
        this.advancedCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).clear();
        TestSizeResponse sizeEnd = this.client().size();
        HotRodTestingUtil.assertStatus(sizeEnd, OperationStatus.Success);
        AssertJUnit.assertEquals((long)20L, (long)sizeEnd.size);
    }
}

