/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.interceptors.base.BaseCustomInterceptor;

class SkipIndexingFlagCheckCommandInterceptor
extends BaseCustomInterceptor {
    volatile boolean expectSkipIndexingFlag = false;

    SkipIndexingFlagCheckCommandInterceptor() {
    }

    protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        if (command instanceof FlagAffectedCommand) {
            FlagAffectedCommand flagAffectedCommand = (FlagAffectedCommand)command;
            boolean hasFlag = flagAffectedCommand.hasAnyFlag(FlagBitSets.SKIP_INDEXING);
            if (this.expectSkipIndexingFlag && !hasFlag) {
                throw new CacheException("SKIP_INDEXING flag is expected!");
            }
            if (!this.expectSkipIndexingFlag && hasFlag) {
                throw new CacheException("SKIP_INDEXING flag is *not* expected!");
            }
        }
        return super.handleDefault(ctx, command);
    }
}

