/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.impl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.server.hotrod.counter.impl.TestCounterEventResponse;
import org.infinispan.server.hotrod.counter.op.CounterListenerOp;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.TestResponse;

public class TestCounterNotificationManager {
    private final WrappedByteArray listenerId;
    private final Map<String, List<UserListener<?>>> userListenerList;
    private final HotRodClient client;

    TestCounterNotificationManager(HotRodClient client) {
        this.client = client;
        byte[] listenerId = new byte[16];
        ThreadLocalRandom.current().nextBytes(listenerId);
        this.listenerId = new WrappedByteArray(listenerId);
        this.userListenerList = new ConcurrentHashMap();
    }

    public WrappedByteArray getListenerId() {
        return this.listenerId;
    }

    public void accept(TestCounterEventResponse event) {
        List<UserListener<?>> list = this.userListenerList.get(event.getCounterName());
        list.parallelStream().forEach(userListener -> userListener.trigger(event.getCounterEvent()));
    }

    public <T extends CounterListener> Handle<T> register(String counterName, T listener) {
        UserListener ul = new UserListener(listener, userListener -> this.remove(counterName, (UserListener<?>)userListener), null);
        this.userListenerList.compute(counterName, (s, userListeners) -> this.add((String)s, (List<UserListener<?>>)userListeners, ul));
        return ul;
    }

    public void start() {
        this.client.registerCounterNotificationManager(this);
    }

    private List<UserListener<?>> add(String counterName, List<UserListener<?>> list, UserListener<?> listener) {
        if (list == null) {
            CounterListenerOp op = CounterListenerOp.createListener(this.client.protocolVersion(), counterName, this.listenerId.getBytes());
            this.client.writeOp(op);
            TestResponse response = this.client.getResponse(op);
            switch (response.getStatus()) {
                case Success: {
                    break;
                }
                case OperationNotExecuted: {
                    break;
                }
                case KeyDoesNotExist: {
                    throw new CounterException("Counter " + counterName + " doesn't exist");
                }
                default: {
                    throw new IllegalStateException("Unknown status " + response.getStatus());
                }
            }
            list = new CopyOnWriteArrayList();
        }
        list.add(listener);
        return list;
    }

    private void remove(String counterName, UserListener<?> listener) {
        this.userListenerList.computeIfPresent(counterName, (name, list) -> {
            list.remove(listener);
            if (list.isEmpty()) {
                CounterListenerOp op = CounterListenerOp.removeListener(this.client.protocolVersion(), counterName, this.listenerId.getBytes());
                this.client.writeOp(op);
                TestResponse response = this.client.getResponse(op);
                switch (response.getStatus()) {
                    case Success: {
                        break;
                    }
                    case OperationNotExecuted: {
                        break;
                    }
                    case KeyDoesNotExist: {
                        throw new CounterException("Counter " + counterName + " doesn't exist");
                    }
                    default: {
                        throw new IllegalStateException("Unknown status " + response.getStatus());
                    }
                }
                return null;
            }
            return list;
        });
    }

    private static class UserListener<T extends CounterListener>
    implements Handle<T> {
        private final T listener;
        private final Consumer<UserListener<?>> removeConsumer;

        private UserListener(T listener, Consumer<UserListener<?>> removeConsumer) {
            this.listener = listener;
            this.removeConsumer = removeConsumer;
        }

        public T getCounterListener() {
            return this.listener;
        }

        public void remove() {
            this.removeConsumer.accept(this);
        }

        void trigger(CounterEvent event) {
            try {
                this.listener.onUpdate(event);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /* synthetic */ UserListener(CounterListener x0, Consumer x1, 1 x2) {
            this(x0, x1);
        }
    }
}

