/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.SyncStrongCounter;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.counter.impl.TestCounterNotificationManager;
import org.infinispan.server.hotrod.counter.op.CounterAddOp;
import org.infinispan.server.hotrod.counter.op.CounterCompareAndSwapOp;
import org.infinispan.server.hotrod.counter.op.CounterOp;
import org.infinispan.server.hotrod.counter.response.CounterValueTestResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.util.concurrent.CompletableFutures;

class TestStrongCounter
implements StrongCounter {
    private final String name;
    private final CounterConfiguration configuration;
    private final HotRodClient client;
    private final TestCounterNotificationManager notificationManager;

    TestStrongCounter(String name, CounterConfiguration configuration, HotRodClient client, TestCounterNotificationManager notificationManager) {
        this.name = name;
        this.configuration = configuration;
        this.client = client;
        this.notificationManager = notificationManager;
    }

    public String getName() {
        return this.name;
    }

    public CompletableFuture<Long> getValue() {
        CounterOp op = new CounterOp(this.client.protocolVersion(), HotRodOperation.COUNTER_GET, this.name);
        return this.executeOp(op, this::handleValue, null);
    }

    public CompletableFuture<Long> addAndGet(long delta) {
        CounterAddOp op = new CounterAddOp(this.client.protocolVersion(), this.name, delta);
        return this.executeOp(op, this::handleValue, () -> delta > 0L);
    }

    public CompletableFuture<Void> reset() {
        CounterOp op = new CounterOp(this.client.protocolVersion(), HotRodOperation.COUNTER_RESET, this.name);
        return this.executeOp(op, this::handleVoid, null);
    }

    public <T extends CounterListener> Handle<T> addListener(T listener) {
        return this.notificationManager.register(this.name, listener);
    }

    public CompletableFuture<Long> compareAndSwap(long expect, long update) {
        CounterCompareAndSwapOp op = new CounterCompareAndSwapOp(this.client.protocolVersion(), this.name, expect, update);
        return this.executeOp(op, this::handleValue, () -> update >= this.configuration.upperBound());
    }

    public CounterConfiguration getConfiguration() {
        return this.configuration;
    }

    public CompletableFuture<Void> remove() {
        CounterOp op = new CounterOp(this.client.protocolVersion(), HotRodOperation.COUNTER_REMOVE, this.name);
        this.client.writeOp(op);
        this.client.getResponse(op);
        return CompletableFutures.completedNull();
    }

    public SyncStrongCounter sync() {
        throw new UnsupportedOperationException();
    }

    private void handleValue(CompletableFuture<Long> future, TestResponse response) {
        future.complete(((CounterValueTestResponse)response).getValue());
    }

    private void handleVoid(CompletableFuture<Void> future, TestResponse unused) {
        future.complete(null);
    }

    private <T> CompletableFuture<T> executeOp(CounterOp op, BiConsumer<CompletableFuture<T>, TestResponse> responseHandler, BooleanSupplier canReachUpperBound) {
        this.client.writeOp(op);
        TestResponse response = this.client.getResponse(op);
        CompletableFuture future = new CompletableFuture();
        switch (response.getStatus()) {
            case Success: {
                responseHandler.accept(future, response);
                break;
            }
            case OperationNotExecuted: {
                responseHandler.accept(future, response);
                break;
            }
            case KeyDoesNotExist: {
                future.completeExceptionally(new IllegalStateException("Counter Not Found!"));
                break;
            }
            case ServerError: {
                future.completeExceptionally((Throwable)new CounterException(((TestErrorResponse)response).msg));
                break;
            }
            case NotExecutedWithPrevious: {
                future.completeExceptionally((Throwable)(canReachUpperBound.getAsBoolean() ? new CounterOutOfBoundsException(String.format("%s reached.", "Upper bound")) : new CounterOutOfBoundsException(String.format("%s reached.", "Lower bound"))));
                break;
            }
            default: {
                future.completeExceptionally(new Exception("unknown response " + (Object)((Object)response)));
            }
        }
        return future;
    }
}

