/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ReplayingDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.counter.util.EncodeUtil;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.counter.impl.TestCounterEventResponse;
import org.infinispan.server.hotrod.counter.response.CounterConfigurationTestResponse;
import org.infinispan.server.hotrod.counter.response.CounterNamesTestResponse;
import org.infinispan.server.hotrod.counter.response.CounterValueTestResponse;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.Op;
import org.infinispan.server.hotrod.test.TestAuthMechListResponse;
import org.infinispan.server.hotrod.test.TestAuthResponse;
import org.infinispan.server.hotrod.test.TestBulkGetKeysResponse;
import org.infinispan.server.hotrod.test.TestBulkGetResponse;
import org.infinispan.server.hotrod.test.TestCustomEvent;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestGetResponse;
import org.infinispan.server.hotrod.test.TestGetWithMetadataResponse;
import org.infinispan.server.hotrod.test.TestGetWithVersionResponse;
import org.infinispan.server.hotrod.test.TestHashDistAware10Response;
import org.infinispan.server.hotrod.test.TestHashDistAware11Response;
import org.infinispan.server.hotrod.test.TestHashDistAware20Response;
import org.infinispan.server.hotrod.test.TestKeyEvent;
import org.infinispan.server.hotrod.test.TestKeyWithVersionEvent;
import org.infinispan.server.hotrod.test.TestQueryResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestResponseWithPrevious;
import org.infinispan.server.hotrod.test.TestSizeResponse;
import org.infinispan.server.hotrod.test.TestStatsResponse;
import org.infinispan.server.hotrod.test.TestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.TxResponse;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;

class Decoder
extends ReplayingDecoder<Void> {
    private final HotRodClient client;
    private static final Log log = (Log)LogFactory.getLog(Decoder.class, Log.class);

    Decoder(HotRodClient client) {
        this.client = client;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        void var11_41;
        AbstractTestTopologyAwareResponse topologyChangeResponse;
        int i;
        log.trace((Object)"Decode response from server");
        buf.readUnsignedByte();
        long id = ExtendedByteBuf.readUnsignedLong((ByteBuf)buf);
        HotRodOperation opCode = HotRodOperation.fromResponseOpCode((byte)((byte)buf.readUnsignedByte()));
        OperationStatus status = OperationStatus.fromCode((byte)((byte)buf.readUnsignedByte()));
        short topologyChangeMarker = buf.readUnsignedByte();
        Op op = this.client.idToOp.get(id);
        if (topologyChangeMarker == 1) {
            int n = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
            if (op.clientIntel == 2) {
                int numberClusterMembers = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
                ServerAddress[] viewArray = new ServerAddress[numberClusterMembers];
                for (i = 0; i < numberClusterMembers; ++i) {
                    String host = ExtendedByteBuf.readString((ByteBuf)buf);
                    int port = ExtendedByteBuf.readUnsignedShort((ByteBuf)buf);
                    viewArray[i] = new ServerAddress(host, port);
                }
                topologyChangeResponse = new TestTopologyAwareResponse(n, Arrays.asList(viewArray));
            } else {
                if (op.clientIntel != 3) throw new UnsupportedOperationException("Client intelligence " + op.clientIntel + " not supported");
                topologyChangeResponse = op.version < 20 ? this.read1xHashDistAwareHeader(buf, n, op) : this.read2xHashDistAwareHeader(buf, n, op);
            }
        } else {
            topologyChangeResponse = null;
        }
        switch (opCode) {
            case STATS: {
                int size = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
                HashMap<String, String> stats = new HashMap<String, String>();
                for (i = 0; i < size; ++i) {
                    stats.put(ExtendedByteBuf.readString((ByteBuf)buf), ExtendedByteBuf.readString((ByteBuf)buf));
                }
                TestStatsResponse testStatsResponse = new TestStatsResponse(op.version, id, op.cacheName, op.clientIntel, op.topologyId, topologyChangeResponse, stats);
                break;
            }
            case PUT: 
            case PUT_IF_ABSENT: 
            case REPLACE: 
            case REPLACE_IF_UNMODIFIED: 
            case REMOVE: 
            case REMOVE_IF_UNMODIFIED: 
            case PUT_STREAM: {
                boolean checkPrevious;
                if (op.version >= 10 && op.version <= 13) {
                    checkPrevious = (op.flags & ProtocolFlag.ForceReturnPreviousValue.getValue()) == 1;
                } else {
                    boolean bl = checkPrevious = status == OperationStatus.SuccessWithPrevious || status == OperationStatus.NotExecutedWithPrevious;
                }
                if (checkPrevious) {
                    int length = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
                    if (length == 0) {
                        TestResponseWithPrevious testResponseWithPrevious = new TestResponseWithPrevious(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, Optional.empty());
                        break;
                    }
                    byte[] previous = new byte[length];
                    buf.readBytes(previous);
                    TestResponseWithPrevious testResponseWithPrevious = new TestResponseWithPrevious(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, Optional.of(previous));
                    break;
                }
                TestResponse testResponse = new TestResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse);
                break;
            }
            case CONTAINS_KEY: 
            case CLEAR: 
            case PING: 
            case ADD_CLIENT_LISTENER: 
            case REMOVE_CLIENT_LISTENER: {
                TestResponse testResponse = new TestResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse);
                break;
            }
            case GET_WITH_VERSION: {
                if (status == OperationStatus.Success) {
                    long version = buf.readLong();
                    Optional<byte[]> data = Optional.of(ExtendedByteBuf.readRangedBytes((ByteBuf)buf));
                    TestGetWithVersionResponse testGetWithVersionResponse = new TestGetWithVersionResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, data, version);
                    break;
                }
                TestGetWithVersionResponse testGetWithVersionResponse = new TestGetWithVersionResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, Optional.empty(), 0L);
                break;
            }
            case GET_WITH_METADATA: 
            case GET_STREAM: {
                if (status == OperationStatus.Success) {
                    long created = -1L;
                    int lifespan = -1;
                    long lastUsed = -1L;
                    int maxIdle = -1;
                    byte flags = buf.readByte();
                    if ((flags & 1) != 1) {
                        created = buf.readLong();
                        lifespan = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
                    }
                    if ((flags & 2) != 2) {
                        lastUsed = buf.readLong();
                        maxIdle = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
                    }
                    long version = buf.readLong();
                    Optional<byte[]> data = Optional.of(ExtendedByteBuf.readRangedBytes((ByteBuf)buf));
                    TestGetWithMetadataResponse testGetWithMetadataResponse = new TestGetWithMetadataResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, data, version, created, lifespan, lastUsed, maxIdle);
                    break;
                }
                TestGetWithMetadataResponse testGetWithMetadataResponse = new TestGetWithMetadataResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, Optional.empty(), 0L, -1L, -1, -1L, -1);
                break;
            }
            case GET: {
                if (status == OperationStatus.Success) {
                    Optional<byte[]> data = Optional.of(ExtendedByteBuf.readRangedBytes((ByteBuf)buf));
                    TestGetResponse testGetResponse = new TestGetResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, data);
                    break;
                }
                TestGetResponse testGetResponse = new TestGetResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, Optional.empty());
                break;
            }
            case BULK_GET: {
                byte done = buf.readByte();
                HashMap<byte[], byte[]> bulkBuffer = new HashMap<byte[], byte[]>();
                while (done == 1) {
                    bulkBuffer.put(ExtendedByteBuf.readRangedBytes((ByteBuf)buf), ExtendedByteBuf.readRangedBytes((ByteBuf)buf));
                    done = buf.readByte();
                }
                TestBulkGetResponse testBulkGetResponse = new TestBulkGetResponse(op.version, id, op.cacheName, op.clientIntel, op.topologyId, topologyChangeResponse, bulkBuffer);
                break;
            }
            case BULK_GET_KEYS: {
                byte done = buf.readByte();
                HashSet<byte[]> bulkKeys = new HashSet<byte[]>();
                while (done == 1) {
                    bulkKeys.add(ExtendedByteBuf.readRangedBytes((ByteBuf)buf));
                    done = buf.readByte();
                }
                TestBulkGetKeysResponse testBulkGetKeysResponse = new TestBulkGetKeysResponse(op.version, id, op.cacheName, op.clientIntel, op.topologyId, topologyChangeResponse, bulkKeys);
                break;
            }
            case QUERY: {
                byte[] result = ExtendedByteBuf.readRangedBytes((ByteBuf)buf);
                TestQueryResponse testQueryResponse = new TestQueryResponse(op.version, id, op.cacheName, op.clientIntel, op.topologyId, topologyChangeResponse, result);
                break;
            }
            case AUTH_MECH_LIST: {
                int size = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
                HashSet<String> mechs = new HashSet<String>();
                for (int i2 = 0; i2 < size; ++i2) {
                    mechs.add(ExtendedByteBuf.readString((ByteBuf)buf));
                }
                TestAuthMechListResponse testAuthMechListResponse = new TestAuthMechListResponse(op.version, id, op.cacheName, op.clientIntel, op.topologyId, topologyChangeResponse, mechs);
                break;
            }
            case AUTH: {
                boolean complete = buf.readBoolean();
                byte[] challenge = ExtendedByteBuf.readRangedBytes((ByteBuf)buf);
                TestAuthResponse testAuthResponse = new TestAuthResponse(op.version, id, op.cacheName, (short)op.clientIntel, op.topologyId, topologyChangeResponse, complete, challenge);
                break;
            }
            case CACHE_ENTRY_CREATED_EVENT: 
            case CACHE_ENTRY_MODIFIED_EVENT: 
            case CACHE_ENTRY_REMOVED_EVENT: {
                boolean isRetried;
                byte[] listenerId = ExtendedByteBuf.readRangedBytes((ByteBuf)buf);
                byte isCustom = buf.readByte();
                boolean bl = isRetried = buf.readByte() == 1;
                if (isCustom == 1 || isCustom == 2) {
                    byte[] eventData = ExtendedByteBuf.readRangedBytes((ByteBuf)buf);
                    TestCustomEvent testCustomEvent = new TestCustomEvent(this.client.protocolVersion, id, this.client.defaultCacheName, opCode, listenerId, isRetried, eventData);
                    break;
                }
                byte[] key = ExtendedByteBuf.readRangedBytes((ByteBuf)buf);
                if (opCode == HotRodOperation.CACHE_ENTRY_REMOVED_EVENT) {
                    TestKeyEvent testKeyEvent = new TestKeyEvent(this.client.protocolVersion, id, this.client.defaultCacheName, listenerId, isRetried, key);
                    break;
                }
                long dataVersion = buf.readLong();
                TestKeyWithVersionEvent testKeyWithVersionEvent = new TestKeyWithVersionEvent(this.client.protocolVersion, id, this.client.defaultCacheName, opCode, listenerId, isRetried, key, dataVersion);
                break;
            }
            case SIZE: {
                long lsize = ExtendedByteBuf.readUnsignedLong((ByteBuf)buf);
                TestSizeResponse testSizeResponse = new TestSizeResponse(op.version, id, op.cacheName, op.clientIntel, op.topologyId, topologyChangeResponse, lsize);
                break;
            }
            case ERROR: {
                if (op == null) {
                    TestErrorResponse testErrorResponse = new TestErrorResponse(10, id, "", 0, status, 0, null, ExtendedByteBuf.readString((ByteBuf)buf));
                    break;
                }
                TestErrorResponse testErrorResponse = new TestErrorResponse(op.version, id, op.cacheName, (short)op.clientIntel, status, op.topologyId, topologyChangeResponse, ExtendedByteBuf.readString((ByteBuf)buf));
                break;
            }
            case PREPARE_TX: 
            case ROLLBACK_TX: 
            case COMMIT_TX: {
                TxResponse txResponse = new TxResponse(this.client.protocolVersion, id, this.client.defaultCacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, status == OperationStatus.Success ? buf.readInt() : 0);
                break;
            }
            case COUNTER_REMOVE: 
            case COUNTER_CREATE: 
            case COUNTER_IS_DEFINED: 
            case COUNTER_RESET: 
            case COUNTER_ADD_LISTENER: 
            case COUNTER_REMOVE_LISTENER: {
                TestResponse testResponse = new TestResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse);
                break;
            }
            case COUNTER_GET_CONFIGURATION: {
                TestResponse testResponse = status == OperationStatus.Success ? new CounterConfigurationTestResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, EncodeUtil.decodeConfiguration(() -> ((ByteBuf)buf).readByte(), () -> ((ByteBuf)buf).readLong(), () -> ExtendedByteBuf.readUnsignedInt((ByteBuf)buf))) : new TestResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse);
                break;
            }
            case COUNTER_GET: 
            case COUNTER_ADD_AND_GET: 
            case COUNTER_CAS: {
                TestResponse testResponse = status == OperationStatus.Success ? new CounterValueTestResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, buf.readLong()) : new TestResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse);
                break;
            }
            case COUNTER_GET_NAMES: {
                TestResponse testResponse = status == OperationStatus.Success ? new CounterNamesTestResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse, buf) : new TestResponse(op.version, id, op.cacheName, op.clientIntel, opCode, status, op.topologyId, topologyChangeResponse);
                break;
            }
            case COUNTER_EVENT: {
                TestCounterEventResponse testCounterEventResponse = new TestCounterEventResponse(this.client.protocolVersion, id, opCode, buf);
                break;
            }
            default: {
                Object var11_40 = null;
            }
        }
        if (var11_41 == null) return;
        log.tracef("Got response from server: %s", (Object)var11_41);
        out.add(var11_41);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.exceptionReported(cause);
    }

    private AbstractTestTopologyAwareResponse read2xHashDistAwareHeader(ByteBuf buf, int topologyId, Op op) {
        int numServersInTopo = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
        ArrayList<ServerAddress> members = new ArrayList<ServerAddress>();
        for (int i = 0; i < numServersInTopo; ++i) {
            ServerAddress node = new ServerAddress(ExtendedByteBuf.readString((ByteBuf)buf), ExtendedByteBuf.readUnsignedShort((ByteBuf)buf));
            members.add(node);
        }
        byte hashFunction = buf.readByte();
        int numSegments = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
        ArrayList<Iterable<ServerAddress>> segments = new ArrayList<Iterable<ServerAddress>>();
        if (hashFunction > 0) {
            for (int i = 1; i <= numSegments; ++i) {
                int owners = buf.readByte();
                ArrayList membersInSegment = new ArrayList();
                for (int j = 1; j <= owners; ++j) {
                    int index = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
                    membersInSegment.add(members.get(index));
                }
                segments.add(membersInSegment);
            }
        }
        return new TestHashDistAware20Response(topologyId, members, segments, hashFunction);
    }

    private AbstractTestTopologyAwareResponse read1xHashDistAwareHeader(ByteBuf buf, int topologyId, Op op) {
        int numOwners = ExtendedByteBuf.readUnsignedShort((ByteBuf)buf);
        byte hashFunction = buf.readByte();
        int hashSpace = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
        int numServersInTopo = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
        if (op.version == 10) {
            return this.read10HashDistAwareHeader(buf, topologyId, numOwners, hashFunction, hashSpace, numServersInTopo);
        }
        return this.read11HashDistAwareHeader(buf, topologyId, numOwners, hashFunction, hashSpace, numServersInTopo);
    }

    private AbstractTestTopologyAwareResponse read10HashDistAwareHeader(ByteBuf buf, int topologyId, int numOwners, byte hashFunction, int hashSpace, int numServersInTopo) {
        HashSet<ServerAddress> members = new HashSet<ServerAddress>();
        HashMap<ServerAddress, List<Integer>> allHashIds = new HashMap<ServerAddress, List<Integer>>();
        ArrayList<Integer> hashIdsOfAddr = new ArrayList<Integer>();
        ServerAddress prevNode = null;
        for (int i = 1; i <= numServersInTopo; ++i) {
            ServerAddress node = new ServerAddress(ExtendedByteBuf.readString((ByteBuf)buf), ExtendedByteBuf.readUnsignedShort((ByteBuf)buf));
            int hashId = buf.readInt();
            if (prevNode == null || node.equals(prevNode)) {
                if (prevNode == null) {
                    prevNode = node;
                }
                hashIdsOfAddr.add(hashId);
            } else {
                allHashIds.put(prevNode, hashIdsOfAddr);
                members.add(prevNode);
                prevNode = node;
                hashIdsOfAddr = new ArrayList();
                hashIdsOfAddr.add(hashId);
            }
            if (i != numServersInTopo) continue;
            allHashIds.put(prevNode, hashIdsOfAddr);
            members.add(prevNode);
        }
        return new TestHashDistAware10Response(topologyId, members, allHashIds, numOwners, hashFunction, hashSpace);
    }

    private AbstractTestTopologyAwareResponse read11HashDistAwareHeader(ByteBuf buf, int topologyId, int numOwners, Byte hashFunction, int hashSpace, int numServersInTopo) {
        int numVirtualNodes = ExtendedByteBuf.readUnsignedInt((ByteBuf)buf);
        HashMap<ServerAddress, Integer> hashToAddress = new HashMap<ServerAddress, Integer>();
        for (int i = 1; i <= numServersInTopo; ++i) {
            hashToAddress.put(new ServerAddress(ExtendedByteBuf.readString((ByteBuf)buf), ExtendedByteBuf.readUnsignedShort((ByteBuf)buf)), buf.readInt());
        }
        return new TestHashDistAware11Response(topologyId, hashToAddress, numOwners, hashFunction, hashSpace, numVirtualNodes);
    }
}

