/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.transaction.xa.Xid;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.TestGetWithMetadataResponse;
import org.infinispan.server.hotrod.test.TxResponse;
import org.infinispan.server.hotrod.test.TxWrite;
import org.infinispan.server.hotrod.tx.ControlByte;
import org.testng.AssertJUnit;

public class RemoteTransaction {
    private static final Log log = (Log)LogFactory.getLog(RemoteTransaction.class, Log.class);
    private static final int FORMAT = -1234;
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(0);
    private final HotRodClient client;
    private final XidImpl xid;
    private final Map<WrappedByteArray, ContextValue> txContext;

    private RemoteTransaction(HotRodClient client) {
        this.client = client;
        byte[] gtxAndBrandId = RemoteTransaction.intToBytes(ID_GENERATOR.incrementAndGet());
        this.xid = XidImpl.create((int)-1234, (byte[])gtxAndBrandId, (byte[])gtxAndBrandId);
        this.txContext = new ConcurrentHashMap<WrappedByteArray, ContextValue>();
    }

    public static RemoteTransaction startTransaction(HotRodClient client) {
        return new RemoteTransaction(Objects.requireNonNull(client));
    }

    private static byte[] intToBytes(long val) {
        byte[] array = new byte[4];
        for (int i = 3; i > 0; --i) {
            array[i] = (byte)val;
            val >>>= 8;
        }
        array[0] = (byte)val;
        return array;
    }

    private static TxWrite transform(Map.Entry<WrappedByteArray, ContextValue> entry) {
        ContextValue contextValue = entry.getValue();
        if (contextValue.removed) {
            return TxWrite.remove(entry.getKey().getBytes(), ControlByte.REMOVE_OP.set(contextValue.control), contextValue.versionRead);
        }
        return TxWrite.put(entry.getKey().getBytes(), contextValue.value, contextValue.lifespan, contextValue.maxIdle, contextValue.control, contextValue.versionRead);
    }

    private static boolean isModifiedFilter(Map.Entry<WrappedByteArray, ContextValue> entry) {
        return entry.getValue().modified;
    }

    private static ContextValue nonExisting() {
        return new ContextValue(0L, ControlByte.NON_EXISTING.bit(), null);
    }

    private static ContextValue notRead(WrappedByteArray ignoredKey) {
        return new ContextValue(0L, ControlByte.NOT_READ.bit(), null);
    }

    public void getAndAssert(byte[] key, byte[] expectedValue) {
        String message = String.format("[XID=%s] Wrong value for key %s", this.xid, Util.printArray((byte[])key, (boolean)true));
        if (expectedValue == null) {
            AssertJUnit.assertEquals((String)message, null, (byte[])this.get(key));
        } else {
            AssertJUnit.assertArrayEquals((String)message, (byte[])expectedValue, (byte[])this.get(key));
        }
    }

    public void set(byte[] key, byte[] value) {
        this.set(key, value, 0, 0);
    }

    public void set(byte[] key, byte[] value, int lifespan, int maxIdle) {
        log.debugf("SET[%s] (%s, %s, %s, &s)", new Object[]{this.xid, Util.printArray((byte[])key, (boolean)true), Util.printArray((byte[])value, (boolean)true), lifespan, maxIdle});
        ContextValue contextValue = this.txContext.computeIfAbsent(new WrappedByteArray(key), RemoteTransaction::notRead);
        contextValue.set(value, lifespan, maxIdle);
    }

    public void remove(byte[] key) {
        ContextValue contextValue = this.txContext.computeIfAbsent(new WrappedByteArray(key), RemoteTransaction::notRead);
        contextValue.remove();
    }

    public void prepareAndAssert(int expectedXaCode) {
        String message = String.format("[XID=%s] Wrong XA return code for prepare", this.xid);
        AssertJUnit.assertEquals((String)message, (int)expectedXaCode, (int)this.prepare().xaCode);
    }

    public void prepareAndAssert(HotRodClient another, int expectedXaCode) {
        String message = String.format("[XID=%s] Wrong XA return code for prepare", this.xid);
        log.debugf("PREPARE[%s]", (Object)this.xid);
        AssertJUnit.assertEquals((String)message, (int)expectedXaCode, (int)((TxResponse)another.prepareTx((Xid)this.xid, (boolean)false, this.modifications())).xaCode);
    }

    public void commitAndAssert(int expectedXaCode) {
        String message = String.format("[XID=%s] Wrong XA return code for commit", this.xid);
        AssertJUnit.assertEquals((String)message, (int)expectedXaCode, (int)this.commit().xaCode);
    }

    public void commitAndAssert(HotRodClient another, int expectedXaCode) {
        String message = String.format("[XID=%s] Wrong XA return code for commit", this.xid);
        log.debugf("COMMIT[%s]", (Object)this.xid);
        AssertJUnit.assertEquals((String)message, (int)expectedXaCode, (int)((TxResponse)another.commitTx((Xid)this.xid)).xaCode);
    }

    public void rollbackAndAssert(int expectedXaCode) {
        String message = String.format("[XID=%s] Wrong XA return code for rollback", this.xid);
        AssertJUnit.assertEquals((String)message, (int)expectedXaCode, (int)this.rollback().xaCode);
    }

    public void rollbackAndAssert(HotRodClient another, int expectedXaCode) {
        String message = String.format("[XID=%s] Wrong XA return code for rollback", this.xid);
        log.debugf("ROLLBACK[%s]", (Object)this.xid);
        AssertJUnit.assertEquals((String)message, (int)expectedXaCode, (int)((TxResponse)another.rollbackTx((Xid)this.xid)).xaCode);
    }

    public XidImpl getXid() {
        return this.xid;
    }

    private TxResponse rollback() {
        log.debugf("ROLLBACK[%s]", (Object)this.xid);
        return (TxResponse)this.client.rollbackTx((Xid)this.xid);
    }

    private byte[] get(byte[] key) {
        log.debugf("GET[%s] (%s)", (Object)this.xid, (Object)Util.printArray((byte[])key, (boolean)true));
        ContextValue value = this.txContext.get(new WrappedByteArray(key));
        if (value != null) {
            return value.value;
        }
        return this.performGet(key).value;
    }

    private TxResponse prepare() {
        log.debugf("PREPARE[%s]", (Object)this.xid);
        return (TxResponse)this.client.prepareTx((Xid)this.xid, false, this.modifications());
    }

    private TxResponse commit() {
        log.debugf("COMMIT[%s]", (Object)this.xid);
        return (TxResponse)this.client.commitTx((Xid)this.xid);
    }

    private List<TxWrite> modifications() {
        return this.txContext.entrySet().stream().filter(RemoteTransaction::isModifiedFilter).map(RemoteTransaction::transform).collect(Collectors.toList());
    }

    private ContextValue performGet(byte[] key) {
        TestGetWithMetadataResponse response = this.client.getWithMetadata(key, 0);
        ContextValue contextValue = response.data.map(bytes -> new ContextValue(response.dataVersion, 0, (byte[])bytes)).orElseGet(RemoteTransaction::nonExisting);
        this.txContext.put(new WrappedByteArray(key), contextValue);
        return contextValue;
    }

    private static class ContextValue {
        private final long versionRead;
        private final byte control;
        private byte[] value;
        private int lifespan;
        private int maxIdle;
        private boolean modified;
        private boolean removed;

        private ContextValue(long versionRead, byte control, byte[] value) {
            this.versionRead = versionRead;
            this.control = control;
            this.value = value;
        }

        public void remove() {
            this.value = null;
            this.modified = true;
            this.removed = true;
        }

        public void set(byte[] value, int lifespan, int maxIdle) {
            this.value = value;
            this.lifespan = lifespan;
            this.maxIdle = maxIdle;
            this.modified = true;
            this.removed = false;
        }
    }
}

