/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.RemoteTransaction;
import org.infinispan.server.hotrod.tx.ServerTransactionTable;
import org.infinispan.server.hotrod.tx.TxState;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.tx.TopologyChangeFunctionalTest")
public class TopologyChangeFunctionalTest
extends HotRodMultiNodeTest {
    private org.infinispan.configuration.cache.TransactionMode transactionMode;

    public Object[] factory() {
        return new Object[]{new TopologyChangeFunctionalTest().transactionMode(org.infinispan.configuration.cache.TransactionMode.NON_XA).lockingMode(LockingMode.PESSIMISTIC), new TopologyChangeFunctionalTest().transactionMode(org.infinispan.configuration.cache.TransactionMode.NON_DURABLE_XA).lockingMode(LockingMode.PESSIMISTIC), new TopologyChangeFunctionalTest().transactionMode(org.infinispan.configuration.cache.TransactionMode.FULL_XA).lockingMode(LockingMode.PESSIMISTIC)};
    }

    public TopologyChangeFunctionalTest transactionMode(org.infinispan.configuration.cache.TransactionMode transactionMode) {
        this.transactionMode = transactionMode;
        return this;
    }

    public void testNonOriginatorLeft(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        this.killNode(1);
        tx.commitAndAssert(0);
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testNodeJoin(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        this.addNewNode();
        tx.commitAndAssert(0);
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    @Test(groups={"unstable"}, description="ISPN-8432")
    public void testOriginatorLeft(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        this.killNode(0);
        tx.commitAndAssert(this.clients().get(0), 0);
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    public void testOriginatorLeftBeforePrepare(Method method) {
        byte[] k1 = HotRodTestingUtil.k(method, "k1");
        byte[] k2 = HotRodTestingUtil.k(method, "k2");
        byte[] v1 = HotRodTestingUtil.v(method, "v1");
        byte[] v2 = HotRodTestingUtil.v(method, "v2");
        RemoteTransaction tx = RemoteTransaction.startTransaction(this.clients().get(0));
        tx.set(k1, v1);
        tx.set(k2, v2);
        tx.getAndAssert(k1, v1);
        tx.getAndAssert(k2, v2);
        tx.prepareAndAssert(0);
        this.killNode(0);
        ServerTransactionTable transactionTable = (ServerTransactionTable)TestingUtil.extractComponent((Cache)this.cache(0, this.cacheName()), ServerTransactionTable.class);
        TxState state = transactionTable.getGlobalState(tx.getXid());
        transactionTable.updateGlobalState(tx.getXid(), state, new TxState(state.getGlobalTransaction()));
        tx.prepareAndAssert(this.clients().get(0), 0);
        tx.commitAndAssert(this.clients().get(0), 0);
        this.assertData(k1, v1);
        this.assertData(k2, v2);
        this.assertServerTransactionTableEmpty();
    }

    @Override
    protected byte protocolVersion() {
        return HotRodVersion.HOTROD_27.getVersion();
    }

    @Override
    protected String cacheName() {
        return "topology-change-tx-cache";
    }

    protected String parameters() {
        return "[" + this.lockingMode + "/" + this.transactionMode + "]";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.transaction().lockingMode(this.lockingMode);
        switch (this.transactionMode) {
            case NON_XA: {
                builder.transaction().useSynchronization(true);
                break;
            }
            case NON_DURABLE_XA: {
                builder.transaction().useSynchronization(false);
                builder.transaction().recovery().disable();
                break;
            }
            case FULL_XA: {
                builder.transaction().useSynchronization(false);
                builder.transaction().recovery().enable();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        builder.clustering().hash().numOwners(2);
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        return builder;
    }

    @Override
    protected int nodeCount() {
        return 3;
    }

    @BeforeMethod(alwaysRun=true)
    private void checkNumberOfNodes() {
        while (this.servers().size() > this.nodeCount()) {
            this.killNode(this.servers().size() - 1);
        }
        while (this.servers().size() < this.nodeCount()) {
            this.addNewNode();
        }
    }

    private void addNewNode() {
        int nextServerPort = this.findHighestPort().orElseGet(HotRodTestingUtil::serverPort);
        HotRodServer server = this.startClusteredServer(nextServerPort += 50);
        this.servers().add(server);
        this.clients().add(this.createClient(server, this.cacheName()));
    }

    private void assertData(byte[] key, byte[] value) {
        for (HotRodClient client : this.clients()) {
            HotRodTestingUtil.assertSuccess(client.get(key, 0), value);
        }
    }

    private void assertServerTransactionTableEmpty() {
        for (Cache cache : this.caches(this.cacheName())) {
            ServerTransactionTable serverTransactionTable = (ServerTransactionTable)TestingUtil.extractComponent((Cache)cache, ServerTransactionTable.class);
            AssertJUnit.assertTrue((boolean)serverTransactionTable.isEmpty());
        }
    }

    private void killNode(int index) {
        HotRodTestingUtil.killClient(this.clients().remove(index));
        this.stopClusteredServer(this.servers().remove(index));
    }
}

