/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.server.hotrod.TransactionWrite;

class PrepareTransactionContext {
    private final XidImpl xid;
    private final boolean onePhaseCommit;
    private final int numberOfWrites;
    private final List<TransactionWrite> writeOperations;

    PrepareTransactionContext(XidImpl xid, boolean onePhaseCommit, int numberOfWrites) {
        this.xid = xid;
        this.onePhaseCommit = onePhaseCommit;
        this.numberOfWrites = numberOfWrites;
        this.writeOperations = new ArrayList<TransactionWrite>(numberOfWrites);
    }

    public boolean isFinished() {
        return this.numberOfWrites == this.writeOperations.size();
    }

    public boolean isEmpty() {
        return this.writeOperations.isEmpty();
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public String toString() {
        return "PrepareTransactionContext{xid=" + this.xid + ", onePhaseCommit=" + this.onePhaseCommit + ", numberOfWrites=" + this.numberOfWrites + '}';
    }

    boolean isOnePhaseCommit() {
        return this.onePhaseCommit;
    }

    List<TransactionWrite> writes() {
        return this.writeOperations;
    }

    void addWrite(TransactionWrite transactionWrite) {
        this.writeOperations.add(transactionWrite);
    }
}

