/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.multimap;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import org.infinispan.server.hotrod.MetadataUtils;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.multimap.MultimapGetWithMetadataResponse;
import org.infinispan.server.hotrod.multimap.MultimapResponse;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;

public final class MultimapResponseHandler {
    private MultimapResponseHandler() {
    }

    public static void handle(Response response, ByteBuf buf) {
        switch (response.getOperation()) {
            case PUT_MULTIMAP: {
                break;
            }
            case GET_MULTIMAP: {
                MultimapResponse r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt(((Collection)r.getResult()).size(), buf);
                ((Collection)r.getResult()).forEach(v -> ExtendedByteBuf.writeRangedBytes(v, buf));
                break;
            }
            case GET_MULTIMAP_WITH_METADATA: {
                MultimapGetWithMetadataResponse r = (MultimapGetWithMetadataResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                MetadataUtils.writeMetadata(r.getLifespan(), r.getMaxIdle(), r.getCreated(), r.getLastUsed(), r.getDataVersion(), buf);
                ExtendedByteBuf.writeUnsignedInt(((Collection)r.getResult()).size(), buf);
                ((Collection)r.getResult()).forEach(v -> ExtendedByteBuf.writeRangedBytes(v, buf));
                break;
            }
            case REMOVE_MULTIMAP: {
                MultimapResponse r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt((Boolean)r.getResult() != false ? 1 : 0, buf);
                break;
            }
            case REMOVE_ENTRY_MULTIMAP: {
                MultimapResponse r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt((Boolean)r.getResult() != false ? 1 : 0, buf);
                break;
            }
            case SIZE_MULTIMAP: {
                MultimapResponse r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedLong((Long)r.getResult(), buf);
                break;
            }
            case CONTAINS_ENTRY_MULTIMAP: {
                MultimapResponse r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt((Boolean)r.getResult() != false ? 1 : 0, buf);
                break;
            }
            case CONTAINS_KEY_MULTIMAP: {
                MultimapResponse r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt((Boolean)r.getResult() != false ? 1 : 0, buf);
                break;
            }
            case CONTAINS_VALUE_MULTIMAP: {
                MultimapResponse r = (MultimapResponse)response;
                if (r.getStatus() != OperationStatus.Success) break;
                ExtendedByteBuf.writeUnsignedInt((Boolean)r.getResult() != false ? 1 : 0, buf);
                break;
            }
            default: {
                throw new UnsupportedOperationException(response.toString());
            }
        }
    }
}

