/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import java.util.concurrent.ExecutorService;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.AuthenticationHandler;
import org.infinispan.server.hotrod.ContextHandler;
import org.infinispan.server.hotrod.HotRodExceptionHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.LocalContextHandler;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.logging.HotRodAccessLoggingHandler;
import org.infinispan.server.hotrod.logging.LoggingContextHandler;

public class HotRodChannelInitializer
extends NettyChannelInitializer {
    protected final HotRodServer hotRodServer;
    protected final NettyTransport transport;
    protected final ExecutorService executor;

    public HotRodChannelInitializer(HotRodServer hotRodServer, NettyTransport transport, ChannelOutboundHandler encoder, ChannelInboundHandler decoder, ExecutorService executor) {
        super((ProtocolServer)hotRodServer, transport, encoder, decoder);
        this.hotRodServer = hotRodServer;
        this.transport = transport;
        this.executor = executor;
    }

    public void initializeChannel(Channel ch) throws Exception {
        AuthenticationHandler authHandler;
        super.initializeChannel(ch);
        AuthenticationHandler authenticationHandler = authHandler = ((HotRodServerConfiguration)this.hotRodServer.getConfiguration()).authentication().enabled() ? new AuthenticationHandler(this.hotRodServer) : null;
        if (authHandler != null) {
            ch.pipeline().addLast("authentication-1", (ChannelHandler)authHandler);
        }
        ch.pipeline().addLast("local-handler", (ChannelHandler)new LocalContextHandler(this.transport));
        ch.pipeline().addLast("handler", (ChannelHandler)new ContextHandler(this.hotRodServer, this.transport, this.executor));
        ch.pipeline().addLast("exception", (ChannelHandler)new HotRodExceptionHandler());
        if (HotRodAccessLoggingHandler.isEnabled()) {
            ch.pipeline().addBefore("decoder", "logging", (ChannelHandler)new HotRodAccessLoggingHandler());
            ch.pipeline().addAfter("encoder", "logging-context", (ChannelHandler)LoggingContextHandler.getInstance());
        }
    }
}

