/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.EmptyResponse;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.Response;
import org.infinispan.server.hotrod.counter.CounterAddDecodeContext;
import org.infinispan.server.hotrod.counter.CounterCompareAndSetDecodeContext;
import org.infinispan.server.hotrod.counter.CounterCreateDecodeContext;
import org.infinispan.server.hotrod.counter.CounterListenerDecodeContext;
import org.infinispan.server.hotrod.counter.listener.ClientCounterManagerNotificationManager;
import org.infinispan.server.hotrod.counter.listener.ListenerOperationStatus;
import org.infinispan.server.hotrod.counter.response.CounterConfigurationResponse;
import org.infinispan.server.hotrod.counter.response.CounterNamesResponse;
import org.infinispan.server.hotrod.counter.response.CounterValueResponse;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.LogFactory;

class CounterRequestProcessor
extends BaseRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(CounterRequestProcessor.class, Log.class);
    private final ClientCounterManagerNotificationManager notificationManager;
    private final EmbeddedCounterManager counterManager;
    private final BiConsumer<CacheDecodeContext, StrongCounter> handleStrongGet = this::handleGetStrong;
    private final BiConsumer<CacheDecodeContext, WeakCounter> handleWeakGet = this::handleGetWeak;
    private final BiConsumer<CacheDecodeContext, StrongCounter> handleStrongReset = this::handleResetStrong;
    private final BiConsumer<CacheDecodeContext, WeakCounter> handleWeakReset = this::handleResetWeak;

    CounterRequestProcessor(Channel channel, EmbeddedCounterManager counterManager, Executor executor, HotRodServer server) {
        super(channel, executor);
        this.counterManager = counterManager;
        this.notificationManager = server.getClientCounterNotificationManager();
    }

    private EmbeddedCounterManager counterManager(CacheDecodeContext cdc) {
        cdc.header.cacheName = "org.infinispan.COUNTER";
        return this.counterManager;
    }

    void removeCounterListener(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.removeCounterListenerInternal(cdc));
    }

    private void removeCounterListenerInternal(CacheDecodeContext cdc) {
        try {
            CounterListenerDecodeContext opCtx = (CounterListenerDecodeContext)cdc.operationContext();
            this.writeResponse(this.createResponseFrom(cdc, this.notificationManager.removeCounterListener(opCtx.getListenerId(), opCtx.getCounterName())));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void addCounterListener(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.addCounterListenerInternal(cdc));
    }

    private void addCounterListenerInternal(CacheDecodeContext cdc) {
        try {
            CounterListenerDecodeContext opCtx = (CounterListenerDecodeContext)cdc.operationContext();
            this.writeResponse(this.createResponseFrom(cdc, this.notificationManager.addCounterListener(opCtx.getListenerId(), cdc.header.getVersion(), opCtx.getCounterName(), this.channel)));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void getCounterNames(CacheDecodeContext cdc) {
        this.writeResponse(new CounterNamesResponse(cdc.header, this.counterManager(cdc).getCounterNames()));
    }

    void counterRemove(CacheDecodeContext cdc) {
        this.executor.execute(() -> this.counterRemoveInternal(cdc));
    }

    private void counterRemoveInternal(CacheDecodeContext cdc) {
        try {
            String counterName = (String)cdc.operationContext();
            this.counterManager(cdc).remove(counterName);
            this.writeResponse(Response.createEmptyResponse(cdc.header, OperationStatus.Success));
        }
        catch (Throwable t) {
            this.writeException(cdc, t);
        }
    }

    void counterCompareAndSwap(CacheDecodeContext cdc) {
        CounterCompareAndSetDecodeContext decodeContext = (CounterCompareAndSetDecodeContext)cdc.operationContext();
        long expect = decodeContext.getExpected();
        long update = decodeContext.getUpdate();
        String name = decodeContext.getCounterName();
        this.applyCounter(cdc, name, (cdcx, counter) -> counter.compareAndSwap(expect, update).whenComplete((value, throwable) -> this.longResultHandler((CacheDecodeContext)cdcx, (Long)value, (Throwable)throwable)), (cdcx, counter) -> this.writeException((CacheDecodeContext)cdcx, (Throwable)log.invalidWeakCounter(name)));
    }

    void counterGet(CacheDecodeContext cdc) {
        this.applyCounter(cdc, (String)cdc.operationContext(), this.handleStrongGet, this.handleWeakGet);
    }

    private void handleGetStrong(CacheDecodeContext cdc, StrongCounter counter) {
        counter.getValue().whenComplete((value, throwable) -> this.longResultHandler(cdc, (Long)value, (Throwable)throwable));
    }

    private void handleGetWeak(CacheDecodeContext cdc, WeakCounter counter) {
        this.longResultHandler(cdc, counter.getValue(), null);
    }

    void counterReset(CacheDecodeContext cdc) {
        this.applyCounter(cdc, (String)cdc.operationContext(), this.handleStrongReset, this.handleWeakReset);
    }

    private void handleResetStrong(CacheDecodeContext cdc, StrongCounter counter) {
        counter.reset().whenComplete((value, throwable) -> this.voidResultHandler(cdc, (Throwable)throwable));
    }

    private void handleResetWeak(CacheDecodeContext cdc, WeakCounter counter) {
        counter.reset().whenComplete((value, throwable) -> this.voidResultHandler(cdc, (Throwable)throwable));
    }

    void counterAddAndGet(CacheDecodeContext cdc) {
        CounterAddDecodeContext decodeContext = (CounterAddDecodeContext)cdc.operationContext();
        long value = decodeContext.getValue();
        this.applyCounter(cdc, decodeContext.getCounterName(), (cdcx, counter) -> counter.addAndGet(value).whenComplete((value1, throwable) -> this.longResultHandler((CacheDecodeContext)cdcx, (Long)value1, (Throwable)throwable)), (cdcx, counter) -> counter.add(value).whenComplete((value2, throwable1) -> this.longResultHandler((CacheDecodeContext)cdcx, 0L, (Throwable)throwable1)));
    }

    void getCounterConfiguration(CacheDecodeContext cdc) {
        this.counterManager(cdc).getConfigurationAsync((String)cdc.operationContext()).whenComplete((configuration, throwable) -> this.handleGetCounterConfiguration(cdc, (CounterConfiguration)configuration, (Throwable)throwable));
    }

    private void handleGetCounterConfiguration(CacheDecodeContext cdc, CounterConfiguration configuration, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(cdc, throwable);
        } else {
            Response response = configuration == null ? this.missingCounterResponse(cdc) : new CounterConfigurationResponse(cdc.header, configuration);
            this.writeResponse(response);
        }
    }

    void isCounterDefined(CacheDecodeContext cdc) {
        this.counterManager(cdc).isDefinedAsync((String)cdc.operationContext()).whenComplete((value, throwable) -> this.booleanResultHandler(cdc, (Boolean)value, (Throwable)throwable));
    }

    void createCounter(CacheDecodeContext cdc) {
        CounterCreateDecodeContext decodeContext = (CounterCreateDecodeContext)cdc.operationContext();
        this.counterManager(cdc).defineCounterAsync(decodeContext.getCounterName(), decodeContext.getConfiguration()).whenComplete((value, throwable) -> this.booleanResultHandler(cdc, (Boolean)value, (Throwable)throwable));
    }

    private void applyCounter(CacheDecodeContext cdc, String counterName, BiConsumer<CacheDecodeContext, StrongCounter> applyStrong, BiConsumer<CacheDecodeContext, WeakCounter> applyWeak) {
        EmbeddedCounterManager counterManager = this.counterManager(cdc);
        CounterConfiguration config = counterManager.getConfiguration(counterName);
        if (config == null) {
            this.writeResponse(this.missingCounterResponse(cdc));
            return;
        }
        switch (config.type()) {
            case UNBOUNDED_STRONG: 
            case BOUNDED_STRONG: {
                applyStrong.accept(cdc, counterManager.getStrongCounter(counterName));
                break;
            }
            case WEAK: {
                applyWeak.accept(cdc, counterManager.getWeakCounter(counterName));
            }
        }
    }

    private Response createResponseFrom(CacheDecodeContext cdc, ListenerOperationStatus status) {
        switch (status) {
            case OK: {
                return Response.createEmptyResponse(cdc.header, OperationStatus.OperationNotExecuted);
            }
            case OK_AND_CHANNEL_IN_USE: {
                return Response.createEmptyResponse(cdc.header, OperationStatus.Success);
            }
            case COUNTER_NOT_FOUND: {
                return this.missingCounterResponse(cdc);
            }
        }
        throw new IllegalStateException();
    }

    private void checkCounterThrowable(CacheDecodeContext cdc, Throwable throwable) {
        Throwable cause = CompletableFutures.extractException((Throwable)throwable);
        if (cause instanceof CounterOutOfBoundsException) {
            this.writeResponse(Response.createEmptyResponse(cdc.header, OperationStatus.NotExecutedWithPrevious));
        } else {
            this.writeException(cdc, cause);
        }
    }

    private Response missingCounterResponse(CacheDecodeContext cdc) {
        return Response.createEmptyResponse(cdc.header, OperationStatus.KeyDoesNotExist);
    }

    private void booleanResultHandler(CacheDecodeContext cdc, Boolean value, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(cdc, throwable);
        } else {
            EmptyResponse response = Response.createEmptyResponse(cdc.header, value != false ? OperationStatus.Success : OperationStatus.OperationNotExecuted);
            this.writeResponse(response);
        }
    }

    private void longResultHandler(CacheDecodeContext cdc, Long value, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(cdc, throwable);
        } else {
            this.writeResponse(new CounterValueResponse(cdc.header, value));
        }
    }

    private void voidResultHandler(CacheDecodeContext cdc, Throwable throwable) {
        if (throwable != null) {
            this.checkCounterThrowable(cdc, throwable);
        } else {
            this.writeResponse(Response.createEmptyResponse(cdc.header, OperationStatus.Success));
        }
    }
}

