/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.iteration;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.server.hotrod.iteration.IterationFilter;

class MarshallerBuilder {
    MarshallerBuilder() {
    }

    static <K, V, C> Class<?> toClass(IterationFilter<K, V, C> filter) {
        return filter.marshaller.map(Object::getClass).orElse(null);
    }

    static Marshaller fromClass(Optional<Class<Marshaller>> marshallerClass, Optional<KeyValueFilterConverter> filter) {
        return filter.flatMap(f -> marshallerClass.map(m -> {
            try {
                return m.getConstructor(ClassLoader.class);
            }
            catch (NoSuchMethodException e) {
                throw new CacheException((Throwable)e);
            }
        }).map(c -> {
            try {
                return (Marshaller)c.newInstance(f.getClass().getClassLoader());
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new CacheException((Throwable)e);
            }
        })).orElseGet(() -> marshallerClass.map(c -> {
            try {
                return (Marshaller)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CacheException((Throwable)e);
            }
        }).orElseGet(() -> MarshallerBuilder.genericFromInstance(filter)));
    }

    static Marshaller genericFromInstance(Optional<?> instance) {
        return new GenericJBossMarshaller((ClassLoader)instance.map(i -> i.getClass().getClassLoader()).orElse(null));
    }
}

