/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.counter.CounterDecodeContext;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;

public class CounterListenerDecodeContext
extends CounterDecodeContext {
    private static final Log log = (Log)LogFactory.getLog(CounterListenerDecodeContext.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private byte[] listenerId;
    private boolean done = false;

    public byte[] getListenerId() {
        return this.listenerId;
    }

    @Override
    CounterDecodeContext.DecodeStep nextStep() {
        return this.done ? null : this::decodeListenerId;
    }

    @Override
    boolean trace() {
        return trace;
    }

    @Override
    Log log() {
        return log;
    }

    private boolean decodeListenerId(ByteBuf buffer) {
        Optional<byte[]> optValue = ExtendedByteBuf.readMaybeRangedBytes(buffer);
        optValue.ifPresent(value -> {
            this.listenerId = value;
            this.logDecoded("listener-id", Util.printArray((byte[])value));
            this.done = true;
        });
        return !optValue.isPresent();
    }
}

