/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.util.Objects;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.xa.Xid;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.server.hotrod.command.tx.ForwardRollbackCommand;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.tx.SecondPhaseTransactionDecodeContext;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.util.ByteString;

public class RollbackTransactionDecodeContext
extends SecondPhaseTransactionDecodeContext {
    private static final Log log = (Log)LogFactory.getLog(RollbackTransactionDecodeContext.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();

    public RollbackTransactionDecodeContext(AdvancedCache<byte[], byte[]> cache, XidImpl xid) {
        super(cache, xid);
    }

    @Override
    final Log log() {
        return log;
    }

    @Override
    final boolean isTrace() {
        return trace;
    }

    @Override
    protected void performRemote() {
        if (this.txState.status() != 4) {
            this.advance(this.txState.rollback());
        }
        this.rollbackRemoteTransaction();
    }

    @Override
    protected void performLocal() throws HeuristicRollbackException, HeuristicMixedException, RollbackException {
        try {
            EmbeddedTransaction tx = Objects.requireNonNull(this.serverTransactionTable.getLocalTx((Xid)this.xid));
            if (this.txState.status() != 4) {
                this.advance(this.txState.rollback());
            }
            tx.runCommit(true);
        }
        catch (RollbackException rollbackException) {
        }
        finally {
            this.serverTransactionTable.removeGlobalStateAndLocalTx(this.xid);
        }
    }

    @Override
    protected CacheRpcCommand buildForwardCommand(ByteString cacheName) {
        return new ForwardRollbackCommand(cacheName, XidImpl.copy((Xid)this.xid));
    }
}

