/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.tx.Util;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.tx.ClientAddress;
import org.infinispan.transaction.xa.GlobalTransaction;

@Immutable
public class TxState {
    public static final AdvancedExternalizer<TxState> EXTERNALIZER = new Externalizer();
    private final GlobalTransaction globalTransaction;
    private final int status;
    private final List<WriteCommand> modifications;

    TxState(GlobalTransaction globalTransaction) {
        this(globalTransaction, 0, null);
    }

    private TxState(GlobalTransaction globalTransaction, int status, List<WriteCommand> modifications) {
        this.globalTransaction = globalTransaction;
        this.status = status;
        this.modifications = modifications;
    }

    private static List<WriteCommand> copyModifications(Collection<WriteCommand> modifications) {
        return modifications == null || modifications.isEmpty() ? null : Collections.unmodifiableList(new ArrayList<WriteCommand>(modifications));
    }

    public int status() {
        return this.status;
    }

    public Address getOriginator() {
        return ((ClientAddress)this.globalTransaction.getAddress()).getLocalAddress();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxState txState = (TxState)o;
        return Objects.equals(this.status, txState.status) && Objects.equals(this.globalTransaction, txState.globalTransaction);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.globalTransaction);
        result = 31 * result + Objects.hashCode(this.status);
        return result;
    }

    public String toString() {
        return "TxState{globalTransaction=" + this.globalTransaction + ", status=" + Util.transactionStatusToString((int)this.status) + ", modifications=" + this.modifications + '}';
    }

    GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    List<WriteCommand> getModifications() {
        return this.modifications;
    }

    TxState prepare(Collection<WriteCommand> modifications) {
        return this.status == 0 ? new TxState(this.globalTransaction, 2, TxState.copyModifications(modifications)) : null;
    }

    TxState commit() {
        return this.status == 2 ? new TxState(this.globalTransaction, 3, null) : null;
    }

    TxState rollback() {
        return this.status == 0 || this.status == 2 ? new TxState(this.globalTransaction, 4, null) : null;
    }

    private static class Externalizer
    implements AdvancedExternalizer<TxState> {
        private Externalizer() {
        }

        public Set<Class<? extends TxState>> getTypeClasses() {
            return Collections.singleton(TxState.class);
        }

        public Integer getId() {
            return 1113;
        }

        public void writeObject(ObjectOutput output, TxState object) throws IOException {
            output.writeObject(object.globalTransaction);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)object.status);
            MarshallUtil.marshallCollection((Collection)object.modifications, (ObjectOutput)output);
        }

        public TxState readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new TxState((GlobalTransaction)input.readObject(), UnsignedNumeric.readUnsignedInt((ObjectInput)input), (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new));
        }
    }
}

