/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import java.util.concurrent.Executor;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.CacheDecodeContext;
import org.infinispan.server.hotrod.ExecRequestContext;
import org.infinispan.server.hotrod.ExecResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.SecurityActions;
import org.infinispan.tasks.TaskContext;
import org.infinispan.tasks.TaskManager;

public class TaskRequestProcessor
extends BaseRequestProcessor {
    private final HotRodServer server;
    private final TaskManager taskManager;

    TaskRequestProcessor(Channel channel, Executor executor, HotRodServer server) {
        super(channel, executor);
        this.server = server;
        this.taskManager = (TaskManager)SecurityActions.getGlobalComponentRegistry(server.getCacheManager()).getComponent(TaskManager.class);
    }

    public void exec(CacheDecodeContext cdc) {
        ExecRequestContext execContext = (ExecRequestContext)cdc.operationDecodeContext;
        Object marshaller = this.server.getMarshaller() != null ? this.server.getMarshaller() : new GenericJBossMarshaller(this.server.getCacheManager().getClassWhiteList());
        TaskContext taskContext = new TaskContext().marshaller(marshaller).cache(cdc.cache()).parameters(execContext.getParams()).subject(cdc.subject);
        this.taskManager.runTask(execContext.getName(), taskContext).whenComplete((result, throwable) -> this.handleExec(cdc, result, (Throwable)throwable));
    }

    private void handleExec(CacheDecodeContext cdc, Object result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(cdc, throwable);
        } else {
            HotRodHeader h = cdc.header;
            this.writeResponse(new ExecResponse(h.version, h.messageId, h.cacheName, h.clientIntel, h.topologyId, result == null ? new byte[]{} : (byte[])result));
        }
    }
}

