/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRod11LocalCacheTest")
public class HotRod11LocalCacheTest
extends HotRodMultiNodeTest {
    @Override
    protected String cacheName() {
        return "localVersion11";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        return HotRodTestingUtil.hotRodCacheConfiguration(HotRod11LocalCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.LOCAL, (boolean)false));
    }

    @Override
    protected byte protocolVersion() {
        return 11;
    }

    protected int virtualNodes() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedPutWithTopologyChanges(Method m) {
        HotRodClient client1 = this.clients().get(0);
        HotRodClient client2 = this.clients().get(1);
        TestResponse resp = client1.ping((byte)3, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        resp = client1.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), (byte)1, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil.assertKeyDoesNotExist(client2.get(HotRodTestingUtil.k(m), 0));
        resp = client2.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v1-"), (byte)2, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil.assertSuccess(client1.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
        HotRodServer newServer = this.startClusteredServer(this.servers().get(1).getPort() + 25);
        HotRodClient newClient = new HotRodClient("127.0.0.1", newServer.getPort(), this.cacheName(), 60, this.protocolVersion());
        List allServers = Stream.concat(Stream.of(newServer), this.servers().stream()).collect(Collectors.toList());
        try {
            this.log.trace((Object)"New client started, modify key to be v6-*");
            resp = newClient.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v2-"), (byte)3, 0);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
            this.log.trace((Object)"Get key from the other clients and verify that it hasn't changed");
            HotRodTestingUtil.assertSuccess(client1.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
            HotRodTestingUtil.assertSuccess(client2.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v1-"));
            resp = client2.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v3-"), (byte)3, 0);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
            HotRodTestingUtil.assertSuccess(newClient.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v2-"));
        }
        finally {
            this.log.trace((Object)"Stopping new server");
            HotRodTestingUtil.killClient(newClient);
            this.stopClusteredServer(newServer);
            this.log.trace((Object)"New server stopped");
        }
        resp = client2.put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m, "v4-"), (byte)3, 2);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        AssertJUnit.assertEquals((Object)resp.topologyResponse, null);
        HotRodTestingUtil.assertSuccess(client1.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m));
        HotRodTestingUtil.assertSuccess(client2.get(HotRodTestingUtil.k(m), 0), HotRodTestingUtil.v(m, "v4-"));
    }
}

