/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestResourceTracker;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodConcurrentStartTest")
public class HotRodConcurrentStartTest
extends MultipleCacheManagersTest {
    private int numberOfServers = 2;
    private String cacheName = "hotRodConcurrentStart";

    protected void createCacheManagers() {
        for (int i = 0; i < this.numberOfServers; ++i) {
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
            this.cacheManagers.add(cm);
            ConfigurationBuilder cfg = HotRodTestingUtil.hotRodCacheConfiguration(HotRodConcurrentStartTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
            cm.defineConfiguration(this.cacheName, cfg.build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentStartup() throws InterruptedException, ExecutionException, TimeoutException {
        int initialPort = HotRodTestingUtil.serverPort();
        ArrayList servers = new ArrayList();
        try {
            ArrayList<Future> futures = new ArrayList<Future>();
            futures.add(this.fork(() -> {
                TestResourceTracker.testThreadStarted((AbstractInfinispanTest)this);
                HotRodServer server = HotRodTestingUtil.startHotRodServerWithDelay((EmbeddedCacheManager)this.getCacheManagers().get(0), initialPort, 2000L);
                servers.add(server);
                return server;
            }));
            int i = 1;
            while (i < this.numberOfServers) {
                int finalI = i++;
                futures.add(this.fork(() -> {
                    TestResourceTracker.testThreadStarted((AbstractInfinispanTest)this);
                    HotRodServer server = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.getCacheManagers().get(finalI), initialPort + finalI * 10);
                    servers.add(server);
                    return server;
                }));
            }
            for (Future hotRodServerFuture : futures) {
                hotRodServerFuture.get(30L, TimeUnit.SECONDS);
            }
        }
        finally {
            servers.forEach(ServerTestingUtil::killServer);
        }
    }
}

