/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.server.core.test.ServerTestingUtil;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.topology.CacheTopology;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodMergeTest")
public class HotRodMergeTest
extends BasePartitionHandlingTest {
    private List<HotRodServer> servers = new ArrayList<HotRodServer>();
    private HotRodClient client;

    public HotRodMergeTest() {
        this.numMembersInCluster = 2;
        this.cacheMode = CacheMode.DIST_SYNC;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_TEST;
    }

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        super.createBeforeClass();
        int nextServerPort = HotRodTestingUtil.serverPort();
        for (int i = 0; i < this.numMembersInCluster; ++i) {
            this.servers.add(HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManagers.get(i), nextServerPort));
            nextServerPort += 50;
        }
        this.client = new HotRodClient("127.0.0.1", this.servers.get(0).getPort(), "___defaultcache", 60, 21);
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(0), this.cache(1)});
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        try {
            HotRodTestingUtil.killClient(this.client);
            this.servers.forEach(ServerTestingUtil::killServer);
        }
        finally {
            super.destroy();
        }
    }

    protected void createCacheManagers() {
        ConfigurationBuilder dcc = HotRodTestingUtil.hotRodCacheConfiguration(new ConfigurationBuilder());
        dcc.clustering().cacheMode(this.cacheMode).hash().numOwners(1);
        this.createClusteredCaches(this.numMembersInCluster, dcc, new TransportFlags().withFD(true).withMerge(true));
        this.waitForClusterToForm();
    }

    public void testNewTopologySentAfterCleanMerge() {
        TestingUtil.waitForNoRebalanceAcrossManagers((EmbeddedCacheManager[])this.managers());
        int initialTopology = this.advancedCache(0).getRpcManager().getTopologyId();
        this.expectCompleteTopology(this.client, initialTopology);
        BasePartitionHandlingTest.PartitionDescriptor p0 = new BasePartitionHandlingTest.PartitionDescriptor(new int[]{0});
        BasePartitionHandlingTest.PartitionDescriptor p1 = new BasePartitionHandlingTest.PartitionDescriptor(new int[]{1});
        this.splitCluster(new int[][]{p0.getNodes(), p1.getNodes()});
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(p1.node(0))});
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(p0.node(0))});
        this.expectPartialTopology(this.client, initialTopology + 1);
        this.partition(0).merge(this.partition(1));
        this.eventuallyExpectCompleteTopology(this.client, initialTopology + 8);
        LocalizedCacheTopology newTopology = this.advancedCache(0).getDistributionManager().getCacheTopology();
        AssertJUnit.assertEquals((Object)CacheTopology.Phase.NO_REBALANCE, (Object)newTopology.getPhase());
        AssertJUnit.assertEquals((int)(initialTopology + 8), (int)newTopology.getTopologyId());
    }

    public void testNewTopologySentAfterOverlappingMerge() {
        TestingUtil.waitForNoRebalanceAcrossManagers((EmbeddedCacheManager[])this.managers());
        int initialTopology = this.advancedCache(0).getRpcManager().getTopologyId();
        this.expectCompleteTopology(this.client, initialTopology);
        BasePartitionHandlingTest.PartitionDescriptor p1 = new BasePartitionHandlingTest.PartitionDescriptor(new int[]{0});
        this.isolatePartition(p1.getNodes());
        TestingUtil.waitForNoRebalance((Cache[])new Cache[]{this.cache(p1.node(0))});
        this.eventuallyExpectPartialTopology(this.client, initialTopology + 1);
        this.partition(0).merge(this.partition(1));
        this.eventuallyExpectCompleteTopology(this.client, initialTopology + 7);
        LocalizedCacheTopology newTopology = this.advancedCache(0).getDistributionManager().getCacheTopology();
        AssertJUnit.assertEquals((Object)CacheTopology.Phase.NO_REBALANCE, (Object)newTopology.getPhase());
    }

    private void eventuallyExpectCompleteTopology(HotRodClient c, int expectedTopologyId) {
        this.eventually(() -> {
            TestResponse resp = c.ping((byte)3, 0);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            if (resp.topologyResponse == null || resp.topologyResponse.topologyId < expectedTopologyId) {
                return false;
            }
            HotRodTestingUtil.assertHashTopology20Received(resp.topologyResponse, this.servers, "___defaultcache", expectedTopologyId);
            return true;
        });
    }

    private void expectCompleteTopology(HotRodClient c, int expectedTopologyId) {
        TestResponse resp = c.ping((byte)3, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertHashTopology20Received(resp.topologyResponse, this.servers, "___defaultcache", expectedTopologyId);
    }

    private void eventuallyExpectPartialTopology(HotRodClient c, int expectedTopologyId) {
        this.eventually(() -> {
            TestResponse resp = c.ping((byte)3, 0);
            HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
            if (resp.topologyResponse == null || resp.topologyResponse.topologyId < expectedTopologyId) {
                return false;
            }
            HotRodTestingUtil.assertHashTopology20Received(resp.topologyResponse, Arrays.asList(this.servers.get(0)), "___defaultcache", expectedTopologyId);
            return true;
        });
    }

    private void expectPartialTopology(HotRodClient c, int expectedTopologyId) {
        TestResponse resp = c.ping((byte)3, 0);
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        HotRodTestingUtil.assertHashTopology20Received(resp.topologyResponse, Arrays.asList(this.servers.get(0)), "___defaultcache", expectedTopologyId);
    }
}

