/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.test.TestGetWithMetadataResponse;
import org.infinispan.server.hotrod.test.TestResponse;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.test.HotRodStreamingTest")
public class HotRodStreamingTest
extends HotRodSingleNodeTest {
    private final byte[] K1 = "K1".getBytes();
    private final byte[] V1 = this.fillArray(32000);
    private final byte[] V2 = this.fillArray(16000);
    private final int V1_SIZE = 32000;
    private final int V2_SIZE = 16000;

    private byte[] fillArray(int size) {
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (byte)(i % 256);
        }
        return array;
    }

    public void testPutGetStream() {
        TestResponse putResponse = this.client().putStream(this.K1, this.V1, 0L, -1, -1);
        AssertJUnit.assertEquals((Object)OperationStatus.Success, (Object)putResponse.getStatus());
        TestGetWithMetadataResponse getResponse = this.client().getStream(this.K1, 0);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.lifespan);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.maxIdle);
        AssertJUnit.assertEquals((byte[])this.V1, (byte[])((byte[])getResponse.data.get()));
    }

    public void testPutStreamIfAbsent() {
        TestResponse putResponse = this.client().putStream(this.K1, this.V1, -1L, -1, -1);
        AssertJUnit.assertEquals((Object)OperationStatus.Success, (Object)putResponse.getStatus());
        TestGetWithMetadataResponse getResponse = this.client().getStream(this.K1, 0);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.lifespan);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.maxIdle);
        AssertJUnit.assertEquals((byte[])this.V1, (byte[])((byte[])getResponse.data.get()));
        putResponse = this.client().putStream(this.K1, this.V2, -1L, -1, -1);
        AssertJUnit.assertEquals((Object)OperationStatus.OperationNotExecuted, (Object)putResponse.getStatus());
        getResponse = this.client().getStream(this.K1, 0);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.lifespan);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.maxIdle);
        AssertJUnit.assertEquals((byte[])this.V1, (byte[])((byte[])getResponse.data.get()));
    }

    public void testReplaceStream() {
        TestResponse putResponse = this.client().putStream(this.K1, this.V1, -1L, -1, -1);
        AssertJUnit.assertEquals((Object)OperationStatus.Success, (Object)putResponse.getStatus());
        TestGetWithMetadataResponse getResponse = this.client().getStream(this.K1, 0);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.lifespan);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.maxIdle);
        AssertJUnit.assertEquals((byte[])this.V1, (byte[])((byte[])getResponse.data.get()));
        long k1version = getResponse.dataVersion;
        putResponse = this.client().putStream(this.K1, this.V2, k1version + 3L, -1, -1);
        AssertJUnit.assertEquals((Object)OperationStatus.OperationNotExecuted, (Object)putResponse.getStatus());
        getResponse = this.client().getStream(this.K1, 0);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.lifespan);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.maxIdle);
        AssertJUnit.assertEquals((byte[])this.V1, (byte[])((byte[])getResponse.data.get()));
        putResponse = this.client().putStream(this.K1, this.V2, k1version, -1, -1);
        AssertJUnit.assertEquals((Object)OperationStatus.Success, (Object)putResponse.getStatus());
        getResponse = this.client().getStream(this.K1, 0);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.lifespan);
        AssertJUnit.assertEquals((int)-1, (int)getResponse.maxIdle);
        AssertJUnit.assertEquals((byte[])this.V2, (byte[])((byte[])getResponse.data.get()));
    }
}

