/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.test;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.JBossMarshaller;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.test.AbstractTestTopologyAwareResponse;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.TestClientListener;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TestGetResponse;
import org.infinispan.server.hotrod.test.TestGetWithMetadataResponse;
import org.infinispan.server.hotrod.test.TestGetWithVersionResponse;
import org.infinispan.server.hotrod.test.TestHashDistAware10Response;
import org.infinispan.server.hotrod.test.TestHashDistAware11Response;
import org.infinispan.server.hotrod.test.TestHashDistAware20Response;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.hotrod.test.TestTopologyAwareResponse;
import org.infinispan.server.hotrod.transport.SingleByteFrameDecoderChannelInitializer;
import org.infinispan.server.hotrod.transport.TimeoutEnabledChannelInitializer;
import org.infinispan.test.fwk.TestResourceTracker;
import org.infinispan.util.KeyValuePair;
import org.testng.AssertJUnit;

public class HotRodTestingUtil {
    private static final Log log = (Log)LogFactory.getLog(HotRodTestingUtil.class, Log.class);
    private static final UniquePortThreadLocal uptl = new UniquePortThreadLocal();
    public static final byte EXPECTED_HASH_FUNCTION_VERSION = 2;
    static final AtomicInteger uniqueAddr = new AtomicInteger(12411);

    private HotRodTestingUtil() {
    }

    public static String host() {
        return "127.0.0.1";
    }

    public static int serverPort() {
        return (Integer)uptl.get();
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.serverPort());
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, String defaultCacheName) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.serverPort(), 0, HotRodTestingUtil.host(), HotRodTestingUtil.serverPort(), 0L, defaultCacheName);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, String proxyHost, int proxyPort) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.serverPort(), 0, proxyHost, proxyPort);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port) {
        return HotRodTestingUtil.startHotRodServer(manager, port, 0);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, String proxyHost, int proxyPort) {
        return HotRodTestingUtil.startHotRodServer(manager, port, 0, proxyHost, proxyPort);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout) {
        return HotRodTestingUtil.startHotRodServer(manager, port, idleTimeout, HotRodTestingUtil.host(), port);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout, String proxyHost, int proxyPort) {
        return HotRodTestingUtil.startHotRodServer(manager, port, idleTimeout, proxyHost, proxyPort, -1L);
    }

    public static HotRodServer startHotRodServerWithDelay(EmbeddedCacheManager manager, int port, long delay) {
        return HotRodTestingUtil.startHotRodServer(manager, port, 0, HotRodTestingUtil.host(), port, delay);
    }

    public static HotRodServer startHotRodServerWithoutTransport(String ... definedCaches) {
        return HotRodTestingUtil.startHotRodServerWithoutTransport(new HotRodServerConfigurationBuilder(), definedCaches);
    }

    public static HotRodServer startHotRodServerWithoutTransport(HotRodServerConfigurationBuilder builder, String ... definedCaches) {
        GlobalConfigurationBuilder globalConfiguration = new GlobalConfigurationBuilder();
        Configuration cacheConfiguration = new ConfigurationBuilder().compatibility().enable().build();
        builder.startTransport(false);
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfiguration.build(), cacheConfiguration);
        for (String cache : definedCaches) {
            cacheManager.defineConfiguration(cache, cacheConfiguration);
        }
        return HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)cacheManager, builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout, String proxyHost, int proxyPort, long delay, String defaultCacheName) {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        ((HotRodServerConfigurationBuilder)builder.proxyHost(proxyHost).proxyPort(proxyPort).idleTimeout(idleTimeout)).defaultCacheName(defaultCacheName);
        return HotRodTestingUtil.startHotRodServer(manager, port, delay, builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, int idleTimeout, String proxyHost, int proxyPort, long delay) {
        return HotRodTestingUtil.startHotRodServer(manager, port, idleTimeout, proxyHost, proxyPort, delay, "___defaultcache");
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, HotRodServerConfigurationBuilder builder) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.host(), port, 0L, false, builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, HotRodServerConfigurationBuilder builder) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.serverPort(), 0L, builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, int port, long delay, HotRodServerConfigurationBuilder builder) {
        return HotRodTestingUtil.startHotRodServer(manager, HotRodTestingUtil.host(), port, delay, false, builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, String host, int port, long delay, HotRodServerConfigurationBuilder builder) {
        return HotRodTestingUtil.startHotRodServer(manager, host, port, delay, false, builder);
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager manager, String host, int port, final long delay, final boolean perf, HotRodServerConfigurationBuilder builder) {
        log.infof("Start server in port %d", (Object)port);
        HotRodServer server = new HotRodServer(){

            protected ConfigurationBuilder createTopologyCacheConfig(long distSyncTimeout) {
                if (delay > 0L) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        throw new CacheException((Throwable)e);
                    }
                }
                return super.createTopologyCacheConfig(distSyncTimeout);
            }

            public ChannelInitializer<Channel> getInitializer() {
                if (perf) {
                    if (((HotRodServerConfiguration)this.configuration).idleTimeout() > 0) {
                        return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), (ChannelInboundHandler)this.getDecoder()), new TimeoutEnabledChannelInitializer((ProtocolServer)this)});
                    }
                    return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), (ChannelInboundHandler)this.getDecoder())});
                }
                if (((HotRodServerConfiguration)this.configuration).idleTimeout() > 0) {
                    return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), (ChannelInboundHandler)this.getDecoder()), new TimeoutEnabledChannelInitializer((ProtocolServer)this), new SingleByteFrameDecoderChannelInitializer()});
                }
                return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, this.getEncoder(), (ChannelInboundHandler)this.getDecoder()), new SingleByteFrameDecoderChannelInitializer()});
            }
        };
        String shortTestName = TestResourceTracker.getCurrentTestShortName();
        if (!builder.name().contains(shortTestName)) {
            builder.name(shortTestName + builder.name());
        }
        ((HotRodServerConfigurationBuilder)builder.host(host)).port(port);
        builder.ioThreads(3);
        server.start((ProtocolServerConfiguration)builder.build(), manager);
        return server;
    }

    public static HotRodServerConfigurationBuilder getDefaultHotRodConfiguration() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        int port = HotRodTestingUtil.serverPort();
        ((HotRodServerConfigurationBuilder)((HotRodServerConfigurationBuilder)builder.host(HotRodTestingUtil.host())).port(port)).proxyHost(HotRodTestingUtil.host()).proxyPort(port);
        return builder;
    }

    public static Iterator<NetworkInterface> findNetworkInterfaces(boolean loopback) {
        try {
            ArrayList<NetworkInterface> matchingInterfaces = new ArrayList<NetworkInterface>();
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                if (!ni.isUp() || ni.isLoopback() != loopback || !ni.getInetAddresses().hasMoreElements()) continue;
                matchingInterfaces.add(ni);
            }
            return matchingInterfaces.iterator();
        }
        catch (SocketException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static byte[] k(Method m, String prefix) {
        byte[] bytes = (prefix + m.getName()).getBytes();
        log.tracef("String %s is converted to %s bytes", (Object)(prefix + m.getName()), (Object)Util.printArray((byte[])bytes, (boolean)true));
        return bytes;
    }

    public static byte[] v(Method m, String prefix) {
        return HotRodTestingUtil.k(m, prefix);
    }

    public static byte[] k(Method m) {
        return HotRodTestingUtil.k(m, "k-");
    }

    public static byte[] v(Method m) {
        return HotRodTestingUtil.v(m, "v-");
    }

    public static boolean assertStatus(TestResponse resp, OperationStatus expected) {
        boolean isSuccess;
        OperationStatus status = resp.getStatus();
        boolean bl = isSuccess = status == expected;
        if (resp instanceof TestErrorResponse) {
            AssertJUnit.assertTrue((String)String.format("Status should have been '%s' but instead was: '%s', and the error message was: %s", expected, status, ((TestErrorResponse)resp).msg), (boolean)isSuccess);
        } else {
            AssertJUnit.assertTrue((String)String.format("Status should have been '%s' but instead was: '%s'", expected, status), (boolean)isSuccess);
        }
        return isSuccess;
    }

    public static boolean assertSuccess(TestGetResponse resp, byte[] expected) {
        HotRodTestingUtil.assertStatus(resp, OperationStatus.Success);
        boolean isArrayEquals = Arrays.equals(expected, resp.data.get());
        AssertJUnit.assertTrue((String)("Retrieved data should have contained " + Util.printArray((byte[])expected, (boolean)true) + " (" + new String(expected) + "), but instead we received " + Util.printArray((byte[])resp.data.get(), (boolean)true) + " (" + new String(resp.data.get()) + ")"), (boolean)isArrayEquals);
        return isArrayEquals;
    }

    public static void assertByteArrayEquals(byte[] expected, byte[] actual) {
        boolean isArrayEquals = Arrays.equals(expected, actual);
        AssertJUnit.assertTrue((String)("Retrieved data should have contained " + Util.printArray((byte[])expected, (boolean)true) + " (" + new String(expected) + "), but instead we received " + Util.printArray((byte[])actual, (boolean)true) + " (" + new String(actual) + ")"), (boolean)isArrayEquals);
    }

    public static boolean assertSuccess(TestGetWithVersionResponse resp, byte[] expected, int expectedVersion) {
        AssertJUnit.assertTrue((resp.getVersion() != expectedVersion ? 1 : 0) != 0);
        return HotRodTestingUtil.assertSuccess(resp, expected);
    }

    public static boolean assertSuccess(TestGetWithMetadataResponse resp, byte[] expected, int expectedLifespan, int expectedMaxIdle) {
        AssertJUnit.assertEquals((int)resp.lifespan, (int)expectedLifespan);
        AssertJUnit.assertEquals((int)resp.maxIdle, (int)expectedMaxIdle);
        return HotRodTestingUtil.assertSuccess(resp, expected);
    }

    public static boolean assertKeyDoesNotExist(TestGetResponse resp) {
        OperationStatus status = resp.getStatus();
        AssertJUnit.assertTrue((String)("Status should have been 'KeyDoesNotExist' but instead was: " + status), (status == OperationStatus.KeyDoesNotExist ? 1 : 0) != 0);
        AssertJUnit.assertEquals(resp.data, Optional.empty());
        return status == OperationStatus.KeyDoesNotExist;
    }

    public static void assertTopologyReceived(AbstractTestTopologyAwareResponse resp, List<HotRodServer> servers, int expectedTopologyId) {
        AssertJUnit.assertEquals((int)resp.topologyId, (int)expectedTopologyId);
        if (resp instanceof TestHashDistAware10Response) {
            TestHashDistAware10Response h10 = (TestHashDistAware10Response)resp;
            AssertJUnit.assertEquals(new HashSet(h10.members), servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet()));
        } else if (resp instanceof TestHashDistAware11Response) {
            TestHashDistAware11Response h11 = (TestHashDistAware11Response)resp;
            AssertJUnit.assertEquals(new HashSet(h11.members), servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet()));
        } else if (resp instanceof TestTopologyAwareResponse) {
            TestTopologyAwareResponse t = (TestTopologyAwareResponse)resp;
            AssertJUnit.assertEquals(new HashSet(t.members), servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet()));
        } else {
            throw new IllegalArgumentException("Unsupported response!");
        }
    }

    public static void assertHashTopology20Received(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName, int expectedTopologyId) {
        TestHashDistAware20Response hashTopologyResp = (TestHashDistAware20Response)topoResp;
        AssertJUnit.assertEquals((int)expectedTopologyId, (int)hashTopologyResp.topologyId);
        Set serverAddresses = servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet());
        AssertJUnit.assertEquals(new HashSet(hashTopologyResp.members), serverAddresses);
        AssertJUnit.assertEquals((int)hashTopologyResp.hashFunction, (int)3);
        Cache cache = servers.get(0).getCacheManager().getCache(cacheName);
        DistributionManager distributionManager = cache.getAdvancedCache().getDistributionManager();
        ConsistentHash ch = distributionManager.getCacheTopology().getCurrentCH();
        int numSegments = ch.getNumSegments();
        int numOwners = ch.getNumOwners();
        AssertJUnit.assertEquals((int)hashTopologyResp.segments.size(), (int)numSegments);
        for (int i = 0; i < numSegments; ++i) {
            List segment = ch.locateOwnersForSegment(i);
            Iterable<ServerAddress> members = hashTopologyResp.segments.get(i);
            AssertJUnit.assertEquals((int)numOwners, (int)segment.size());
            int count = 0;
            for (ServerAddress member : members) {
                ++count;
                AssertJUnit.assertTrue((boolean)serverAddresses.contains(member));
            }
            AssertJUnit.assertEquals((int)numOwners, (int)count);
        }
    }

    public static void assertHashTopology10Received(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName, int expectedTopologyId) {
        HotRodTestingUtil.assertHashTopology10Received(topoResp, servers, cacheName, 2, 2, Integer.MAX_VALUE, expectedTopologyId);
    }

    public static void assertNoHashTopologyReceived(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName, int expectedTopologyId) {
        if (topoResp instanceof TestHashDistAware10Response) {
            HotRodTestingUtil.assertHashTopology10Received(topoResp, servers, cacheName, 0, 0, 0, expectedTopologyId);
        } else if (topoResp instanceof TestHashDistAware20Response) {
            TestHashDistAware20Response t = (TestHashDistAware20Response)topoResp;
            AssertJUnit.assertEquals((int)t.topologyId, (int)expectedTopologyId);
            AssertJUnit.assertEquals(new HashSet(t.members), servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet()));
            AssertJUnit.assertEquals((int)t.hashFunction, (int)0);
            AssertJUnit.assertEquals((int)t.segments.size(), (int)0);
        } else {
            throw new IllegalArgumentException("Unsupported response!");
        }
    }

    public static void assertHashTopology10Received(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName, int expectedNumOwners, int expectedHashFct, int expectedHashSpace, int expectedTopologyId) {
        TestHashDistAware10Response hashTopologyResp = (TestHashDistAware10Response)topoResp;
        AssertJUnit.assertEquals((int)hashTopologyResp.topologyId, (int)expectedTopologyId);
        AssertJUnit.assertEquals(new HashSet(hashTopologyResp.members), servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet()));
        AssertJUnit.assertEquals((int)hashTopologyResp.numOwners, (int)expectedNumOwners);
        AssertJUnit.assertEquals((int)hashTopologyResp.hashFunction, (int)expectedHashFct);
        AssertJUnit.assertEquals((int)hashTopologyResp.hashSpace, (int)expectedHashSpace);
        if (expectedNumOwners != 0) {
            HotRodTestingUtil.assertHashIds(hashTopologyResp.hashIds, servers, cacheName);
        }
    }

    public static void assertHashTopologyReceived(AbstractTestTopologyAwareResponse topoResp, List<HotRodServer> servers, String cacheName, int expectedNumOwners, int expectedVirtualNodes, int expectedTopologyId) {
        TestHashDistAware11Response hashTopologyResp = (TestHashDistAware11Response)topoResp;
        AssertJUnit.assertEquals((int)hashTopologyResp.topologyId, (int)expectedTopologyId);
        AssertJUnit.assertEquals(new HashSet(hashTopologyResp.members), servers.stream().map(HotRodServer::getAddress).collect(Collectors.toSet()));
        AssertJUnit.assertEquals((int)hashTopologyResp.numOwners, (int)expectedNumOwners);
        AssertJUnit.assertEquals((byte)hashTopologyResp.hashFunction, (byte)(expectedNumOwners != 0 ? (byte)2 : 0));
        AssertJUnit.assertEquals((int)hashTopologyResp.hashSpace, (int)(expectedNumOwners != 0 ? Integer.MAX_VALUE : 0));
        AssertJUnit.assertEquals((int)hashTopologyResp.numVirtualNodes, (int)expectedVirtualNodes);
    }

    public static void assertHashIds(Map<ServerAddress, List<Integer>> hashIds, List<HotRodServer> servers, String cacheName) {
        Cache cache = servers.get(0).getCacheManager().getCache(cacheName);
        DistributionManager distributionManager = cache.getAdvancedCache().getDistributionManager();
        ConsistentHash consistentHash = distributionManager.getCacheTopology().getCurrentCH();
        int numSegments = consistentHash.getNumSegments();
        int numOwners = consistentHash.getNumOwners();
        AssertJUnit.assertEquals((int)hashIds.size(), (int)servers.size());
        int segmentSize = (int)Math.ceil(2.147483647E9 / (double)numSegments);
        Map[] owners = new Map[numSegments];
        for (Map.Entry<ServerAddress, List<Integer>> entry : hashIds.entrySet()) {
            ServerAddress serverAddress = entry.getKey();
            List<Integer> serverHashIds = entry.getValue();
            for (Integer hashId : serverHashIds) {
                int segmentIdx = (hashId / segmentSize + numSegments - 1) % numSegments;
                int ownerIdx = hashId % segmentSize;
                if (owners[segmentIdx] == null) {
                    owners[segmentIdx] = new HashMap();
                }
                owners[segmentIdx].put(ownerIdx, serverAddress);
            }
        }
        for (int i = 0; i < numSegments; ++i) {
            List segmentOwners = owners[i].entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList());
            AssertJUnit.assertEquals((int)segmentOwners.size(), (int)numOwners);
            List chOwners = consistentHash.locateOwnersForSegment(i).stream().map(a -> HotRodTestingUtil.clusterAddressToServerAddress(servers, a)).collect(Collectors.toList());
            AssertJUnit.assertEquals(segmentOwners, chOwners);
        }
    }

    public static void assertReplicatedHashIds(Map<ServerAddress, List<Integer>> hashIds, List<HotRodServer> servers, String cacheName) {
        Cache cache = servers.get(0).getCacheManager().getCache(cacheName);
        DistributionManager distributionManager = cache.getAdvancedCache().getDistributionManager();
        ConsistentHash consistentHash = distributionManager.getCacheTopology().getCurrentCH();
        int numSegments = consistentHash.getNumSegments();
        int numOwners = consistentHash.getNumOwners();
        AssertJUnit.assertEquals((int)hashIds.size(), (int)servers.size());
        AssertJUnit.assertEquals((int)numSegments, (int)1);
        for (Map.Entry<ServerAddress, List<Integer>> entry : hashIds.entrySet()) {
            List<Integer> serverHashIds = entry.getValue();
            AssertJUnit.assertEquals((int)serverHashIds.size(), (int)1);
            AssertJUnit.assertEquals((int)serverHashIds.get(0), (int)0);
        }
    }

    private static ServerAddress clusterAddressToServerAddress(List<HotRodServer> servers, Address clusterAddress) {
        Optional<HotRodServer> match = servers.stream().filter(a -> a.getCacheManager().getAddress().equals(clusterAddress)).findFirst();
        return match.get().getAddress();
    }

    public static int getServerTopologyId(EmbeddedCacheManager cm, String cacheName) {
        return cm.getCache(cacheName).getAdvancedCache().getRpcManager().getTopologyId();
    }

    public static Future<?> killClient(HotRodClient client) {
        try {
            if (client != null) {
                return client.stop();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error stopping client", t);
        }
        return null;
    }

    public static ConfigurationBuilder hotRodCacheConfiguration() {
        return new ConfigurationBuilder();
    }

    public static ConfigurationBuilder hotRodCacheConfiguration(ConfigurationBuilder builder) {
        return builder;
    }

    public static CacheEntry assertHotRodEquals(EmbeddedCacheManager cm, byte[] key, byte[] expectedValue) {
        return HotRodTestingUtil.assertHotRodEquals(cm, (Cache<byte[], byte[]>)cm.getCache(), key, expectedValue);
    }

    public static CacheEntry assertHotRodEquals(EmbeddedCacheManager cm, String cacheName, byte[] key, byte[] expectedValue) {
        return HotRodTestingUtil.assertHotRodEquals(cm, (Cache<byte[], byte[]>)cm.getCache(cacheName), key, expectedValue);
    }

    public static CacheEntry assertHotRodEquals(EmbeddedCacheManager cm, String key, String expectedValue) {
        return HotRodTestingUtil.assertHotRodEquals(cm, (Cache<byte[], byte[]>)cm.getCache(), HotRodTestingUtil.marshall(key), HotRodTestingUtil.marshall(expectedValue));
    }

    public static CacheEntry assertHotRodEquals(EmbeddedCacheManager cm, String cacheName, String key, String expectedValue) {
        return HotRodTestingUtil.assertHotRodEquals(cm, (Cache<byte[], byte[]>)cm.getCache(cacheName), HotRodTestingUtil.marshall(key), HotRodTestingUtil.marshall(expectedValue));
    }

    private static CacheEntry assertHotRodEquals(EmbeddedCacheManager cm, Cache<byte[], byte[]> cache, byte[] key, byte[] expectedValue) {
        CacheEntry entry = cache.getAdvancedCache().getCacheEntry((Object)key);
        if (expectedValue == null) {
            AssertJUnit.assertNull((Object)entry);
        } else {
            byte[] value = (byte[])entry.getValue();
            AssertJUnit.assertEquals((byte[])expectedValue, (byte[])value);
        }
        return entry;
    }

    public static byte[] marshall(Object obj) {
        try {
            return obj == null ? null : new JBossMarshaller().objectToByteBuffer(obj, 64);
        }
        catch (IOException | InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static <T> T unmarshall(byte[] key) {
        try {
            return (T)new JBossMarshaller().objectFromByteBuffer(key);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static void withClientListener(HotRodClient client, TestClientListener listener, Optional<KeyValuePair<String, List<byte[]>>> filterFactory, Optional<KeyValuePair<String, List<byte[]>>> converterFactory, Runnable fn) {
        HotRodTestingUtil.withClientListener(client, listener, filterFactory, converterFactory, false, true, fn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withClientListener(HotRodClient client, TestClientListener listener, Optional<KeyValuePair<String, List<byte[]>>> filterFactory, Optional<KeyValuePair<String, List<byte[]>>> converterFactory, boolean includeState, boolean useRawData, Runnable fn) {
        HotRodTestingUtil.assertStatus(client.addClientListener(listener, includeState, filterFactory == null ? Optional.empty() : filterFactory, converterFactory == null ? Optional.empty() : converterFactory, useRawData), OperationStatus.Success);
        try {
            fn.run();
        }
        finally {
            HotRodTestingUtil.assertStatus(client.removeClientListener(listener.getId()), OperationStatus.Success);
        }
    }

    static class UniquePortThreadLocal
    extends ThreadLocal<Integer> {
        UniquePortThreadLocal() {
        }

        @Override
        protected Integer initialValue() {
            log.debugf("Before incrementing, server port is: %d", uniqueAddr.get());
            int port = uniqueAddr.getAndAdd(110);
            log.debugf("For next thread, server port will be: %d", uniqueAddr.get());
            return port;
        }
    }

    @Listener
    public static class AddressRemovalListener {
        private final CountDownLatch latch;

        private AddressRemovalListener(CountDownLatch latch) {
            this.latch = latch;
        }

        @CacheEntryRemoved
        public void addressRemoved(CacheEntryRemovedEvent<Address, ServerAddress> event) {
            if (!event.isPre()) {
                this.latch.countDown();
            }
        }
    }
}

