/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.VersionedEncoder;
import org.infinispan.server.hotrod.logging.Log;

public class HotRodHeader {
    private static final Log log = (Log)LogFactory.getLog(HotRodHeader.class, Log.class);
    HotRodOperation op;
    byte version;
    long messageId;
    String cacheName;
    int flag;
    short clientIntel;
    int topologyId;
    MediaType keyType;
    MediaType valueType;

    public HotRodHeader(HotRodHeader header) {
        this(header.op, header.version, header.messageId, header.cacheName, header.flag, header.clientIntel, header.topologyId, header.keyType, header.valueType);
    }

    public HotRodHeader(HotRodOperation op, byte version, long messageId, String cacheName, int flag, short clientIntel, int topologyId, MediaType keyType, MediaType valueType) {
        this.op = op;
        this.version = version;
        this.messageId = messageId;
        this.cacheName = cacheName;
        this.flag = flag;
        this.clientIntel = clientIntel;
        this.topologyId = topologyId;
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public boolean hasFlag(ProtocolFlag f) {
        return (this.flag & f.getValue()) == f.getValue();
    }

    public HotRodOperation getOp() {
        return this.op;
    }

    public MediaType getKeyMediaType() {
        return this.keyType == null ? MediaType.APPLICATION_UNKNOWN : this.keyType;
    }

    public MediaType getValueMediaType() {
        return this.valueType == null ? MediaType.APPLICATION_UNKNOWN : this.valueType;
    }

    public byte getVersion() {
        return this.version;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public int getFlag() {
        return this.flag;
    }

    public short getClientIntel() {
        return this.clientIntel;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    public VersionedEncoder encoder() {
        return HotRodVersion.getEncoder(this.version);
    }

    boolean isSkipCacheLoad() {
        if (this.version < 20) {
            return false;
        }
        return this.op.canSkipCacheLoading() && this.hasFlag(ProtocolFlag.SkipCacheLoader);
    }

    boolean isSkipIndexing() {
        if (this.version < 20) {
            return false;
        }
        return this.op.canSkipIndexing() && this.hasFlag(ProtocolFlag.SkipIndexing);
    }

    AdvancedCache<byte[], byte[]> getOptimizedCache(AdvancedCache<byte[], byte[]> c, Configuration cacheCfg) {
        if (this.version < 20) {
            if (!this.hasFlag(ProtocolFlag.ForceReturnPreviousValue)) {
                switch (this.op) {
                    case PUT: 
                    case PUT_IF_ABSENT: {
                        return c.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
                    }
                }
            }
            return c;
        }
        boolean isTransactional = cacheCfg.transaction().transactionMode().isTransactional();
        boolean isClustered = cacheCfg.clustering().cacheMode().isClustered();
        AdvancedCache optCache = c;
        if (isClustered && !isTransactional && this.op.isConditional()) {
            log.warnConditionalOperationNonTransactional(this.op.toString());
        }
        if (this.op.canSkipCacheLoading() && this.hasFlag(ProtocolFlag.SkipCacheLoader)) {
            optCache = c.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD});
        }
        if (this.op.canSkipIndexing() && this.hasFlag(ProtocolFlag.SkipIndexing)) {
            optCache = c.withFlags(new Flag[]{Flag.SKIP_INDEXING});
        }
        if (!this.hasFlag(ProtocolFlag.ForceReturnPreviousValue)) {
            if (this.op.isNotConditionalAndCanReturnPrevious()) {
                optCache = optCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
            }
        } else if (!isTransactional && this.op.canReturnPreviousValue()) {
            log.warnForceReturnPreviousNonTransactional(this.op.toString());
        }
        return optCache;
    }

    public String toString() {
        return "HotRodHeader{op=" + (Object)((Object)this.op) + ", version=" + this.version + ", messageId=" + this.messageId + ", cacheName='" + this.cacheName + '\'' + ", flag=" + this.flag + ", clientIntel=" + this.clientIntel + ", topologyId=" + this.topologyId + ", keyType=" + this.keyType + ", valueType=" + this.valueType + '}';
    }
}

