/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.command.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.tx.operation.Util;
import org.infinispan.util.ByteString;

public class ForwardRollbackCommand
extends BaseRpcCommand {
    private XidImpl xid;
    private long timeout;
    private AdvancedCache<byte[], byte[]> cache;

    public ForwardRollbackCommand(ByteString cacheName) {
        super(cacheName);
    }

    public ForwardRollbackCommand(ByteString cacheName, XidImpl xid, long timeout) {
        super(cacheName);
        this.xid = xid;
        this.timeout = timeout;
    }

    public byte getCommandId() {
        return -115;
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    public boolean canBlock() {
        return true;
    }

    public void writeTo(ObjectOutput output) throws IOException {
        XidImpl.writeTo((ObjectOutput)output, (XidImpl)this.xid);
        output.writeLong(this.timeout);
    }

    public void readFrom(ObjectInput input) throws IOException {
        this.xid = XidImpl.readFrom((ObjectInput)input);
        this.timeout = input.readLong();
    }

    public Object invoke() throws Throwable {
        Util.rollbackLocalTransaction(this.cache, this.xid, this.timeout);
        return null;
    }

    public void inject(EmbeddedCacheManager cacheManager) {
        this.cache = cacheManager.getCache(this.cacheName.toString()).getAdvancedCache();
    }

    public String toString() {
        return "ForwardRollbackCommand{cacheName=" + this.cacheName + ", xid=" + this.xid + '}';
    }
}

