/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;

@BuiltBy(value=HotRodServerConfigurationBuilder.class)
public class HotRodServerConfiguration
extends ProtocolServerConfiguration {
    public static final String TOPOLOGY_CACHE_NAME_PREFIX = "___hotRodTopologyCache";
    public static final AttributeDefinition<String> PROXY_HOST = AttributeDefinition.builder((String)"proxy-host", null, String.class).immutable().build();
    public static final AttributeDefinition<Integer> PROXY_PORT = AttributeDefinition.builder((String)"proxy-port", (Object)-1).immutable().build();
    public static final AttributeDefinition<Boolean> TOPOLOGY_AWAIT_INITIAL_TRANSFER = AttributeDefinition.builder((String)"topology-await-initial-transfer", (Object)true).immutable().build();
    public static final AttributeDefinition<Long> TOPOLOGY_LOCK_TIMEOUT = AttributeDefinition.builder((String)"topology-lock-timeout", (Object)10000L).immutable().build();
    public static final AttributeDefinition<Long> TOPOLOGY_REPL_TIMEOUT = AttributeDefinition.builder((String)"topology-repl-timeout", (Object)10000L).immutable().build();
    public static final AttributeDefinition<Boolean> TOPOLOGY_STATE_TRANSFER = AttributeDefinition.builder((String)"topology-state-transfer", (Object)true).immutable().build();
    private final Attribute<String> proxyHost;
    private final Attribute<Integer> proxyPort;
    private final Attribute<Long> topologyLockTimeout;
    private final Attribute<Long> topologyReplTimeout;
    private final Attribute<Boolean> topologyAwaitInitialTransfer;
    private final Attribute<Boolean> topologyStateTransfer;
    private final AuthenticationConfiguration authentication;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(HotRodServerConfiguration.class, ProtocolServerConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{PROXY_HOST, PROXY_PORT, TOPOLOGY_STATE_TRANSFER, TOPOLOGY_AWAIT_INITIAL_TRANSFER, TOPOLOGY_LOCK_TIMEOUT, TOPOLOGY_REPL_TIMEOUT});
    }

    HotRodServerConfiguration(AttributeSet attributes, SslConfiguration ssl, AuthenticationConfiguration authentication) {
        super(attributes, ssl);
        this.authentication = authentication;
        this.proxyHost = attributes.attribute(PROXY_HOST);
        this.proxyPort = attributes.attribute(PROXY_PORT);
        this.topologyLockTimeout = attributes.attribute(TOPOLOGY_LOCK_TIMEOUT);
        this.topologyReplTimeout = attributes.attribute(TOPOLOGY_REPL_TIMEOUT);
        this.topologyAwaitInitialTransfer = attributes.attribute(TOPOLOGY_AWAIT_INITIAL_TRANSFER);
        this.topologyStateTransfer = attributes.attribute(TOPOLOGY_STATE_TRANSFER);
    }

    public String proxyHost() {
        return (String)this.proxyHost.get();
    }

    public String publicHost() {
        return this.proxyHost.isNull() ? this.host() : (String)this.proxyHost.get();
    }

    public int proxyPort() {
        return (Integer)this.proxyPort.get();
    }

    public int publicPort() {
        return this.proxyPort.isModified() ? ((Integer)this.proxyPort.get()).intValue() : this.port();
    }

    public String topologyCacheName() {
        String name = this.name();
        return TOPOLOGY_CACHE_NAME_PREFIX + (name.length() > 0 ? "_" + name : name);
    }

    public long topologyLockTimeout() {
        return (Long)this.topologyLockTimeout.get();
    }

    public long topologyReplTimeout() {
        return (Long)this.topologyReplTimeout.get();
    }

    public boolean topologyAwaitInitialTransfer() {
        return (Boolean)this.topologyAwaitInitialTransfer.get();
    }

    public boolean topologyStateTransfer() {
        return (Boolean)this.topologyStateTransfer.get();
    }

    public AuthenticationConfiguration authentication() {
        return this.authentication;
    }

    public String toString() {
        return "HotRodServerConfiguration[" + this.attributes + "]";
    }
}

