/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;
import org.infinispan.distribution.group.impl.GroupingPartitioner;
import org.infinispan.distribution.group.impl.PartitionerConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.hotrod.AbstractHashDistAwareResponse;
import org.infinispan.server.hotrod.AbstractTopologyResponse;
import org.infinispan.server.hotrod.Events;
import org.infinispan.server.hotrod.HashDistAwareResponse;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.MetadataUtils;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.TopologyAwareResponse;
import org.infinispan.server.hotrod.VersionedEncoder;
import org.infinispan.server.hotrod.counter.listener.ClientCounterEvent;
import org.infinispan.server.hotrod.iteration.IterableIterationResult;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.transport.ExtendedByteBuf;
import org.infinispan.stats.Stats;
import org.infinispan.util.KeyValuePair;

public abstract class AbstractEncoder1x
implements VersionedEncoder {
    protected static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    protected final boolean trace = log.isTraceEnabled();

    @Override
    public void writeEvent(Events.Event e, ByteBuf buf) {
    }

    @Override
    public void writeCounterEvent(ClientCounterEvent event, ByteBuf buffer) {
    }

    @Override
    public ByteBuf authResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, byte[] challenge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf authMechListResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, Set<String> mechs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf notExecutedResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, byte[] prev) {
        return this.valueResponse(header, server, alloc, OperationStatus.OperationNotExecuted, prev);
    }

    @Override
    public ByteBuf notExistResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc) {
        if (header.hasFlag(ProtocolFlag.ForceReturnPreviousValue)) {
            return this.valueResponse(header, server, alloc, OperationStatus.KeyDoesNotExist, null);
        }
        return this.emptyResponse(header, server, alloc, OperationStatus.KeyDoesNotExist);
    }

    @Override
    public ByteBuf valueResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, OperationStatus status, byte[] prev) {
        ByteBuf buf = this.writeHeader(header, server, alloc, status);
        if (prev == null) {
            buf.writeByte(0);
        } else {
            ExtendedByteBuf.writeRangedBytes(prev, buf);
        }
        if (this.trace) {
            log.tracef("Write response to %s messageId=%d status=%s prev=%s", new Object[]{header.op, header.messageId, status, Util.printArray((byte[])prev)});
        }
        return buf;
    }

    @Override
    public ByteBuf successResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, byte[] result) {
        return this.valueResponse(header, server, alloc, OperationStatus.Success, result);
    }

    @Override
    public ByteBuf transactionResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, int xaReturnCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf recoveryResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, Collection<Xid> xids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf errorResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, String message, OperationStatus status) {
        ByteBuf buf = this.writeHeader(header, server, alloc, status);
        ExtendedByteBuf.writeString(message, buf);
        return buf;
    }

    @Override
    public ByteBuf bulkGetResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, int size, CacheSet<Map.Entry<byte[], byte[]>> entries) {
        int count;
        ByteBuf buf = this.writeHeader(header, server, alloc, OperationStatus.Success);
        if (size != 0) {
            log.tracef("About to write (max) %d messages to the client", size);
            count = size;
        } else {
            count = Integer.MAX_VALUE;
        }
        CloseableIterator iterator = entries.iterator();
        while (iterator.hasNext() && count-- > 0) {
            Map.Entry entry = (Map.Entry)iterator.next();
            buf.writeByte(1);
            ExtendedByteBuf.writeRangedBytes((byte[])entry.getKey(), buf);
            ExtendedByteBuf.writeRangedBytes((byte[])entry.getValue(), buf);
        }
        buf.writeByte(0);
        return buf;
    }

    @Override
    public ByteBuf emptyResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, OperationStatus status) {
        return this.writeHeader(header, server, alloc, status);
    }

    @Override
    public ByteBuf statsResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, Stats stats, NettyTransport transport, ComponentRegistry cacheRegistry) {
        ByteBuf buf = this.writeHeader(header, server, alloc, OperationStatus.Success);
        ExtendedByteBuf.writeUnsignedInt(11, buf);
        this.writePair(buf, "timeSinceStart", String.valueOf(stats.getTimeSinceStart()));
        this.writePair(buf, "currentNumberOfEntries", String.valueOf(stats.getCurrentNumberOfEntries()));
        this.writePair(buf, "totalNumberOfEntries", String.valueOf(stats.getTotalNumberOfEntries()));
        this.writePair(buf, "stores", String.valueOf(stats.getStores()));
        this.writePair(buf, "retrievals", String.valueOf(stats.getRetrievals()));
        this.writePair(buf, "hits", String.valueOf(stats.getHits()));
        this.writePair(buf, "misses", String.valueOf(stats.getMisses()));
        this.writePair(buf, "removeHits", String.valueOf(stats.getRemoveHits()));
        this.writePair(buf, "removeMisses", String.valueOf(stats.getRemoveMisses()));
        this.writePair(buf, "totalBytesRead", String.valueOf(transport.getTotalBytesRead()));
        this.writePair(buf, "totalBytesWritten", String.valueOf(transport.getTotalBytesWritten()));
        return buf;
    }

    private void writePair(ByteBuf buf, String key, String value) {
        ExtendedByteBuf.writeString(key, buf);
        ExtendedByteBuf.writeString(value, buf);
    }

    @Override
    public ByteBuf getWithMetadataResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, CacheEntry<byte[], byte[]> entry) {
        ByteBuf buf = this.writeHeader(header, server, alloc, OperationStatus.Success);
        int lifespan = MetadataUtils.extractLifespan(entry);
        int maxIdle = MetadataUtils.extractMaxIdle(entry);
        int flags = lifespan < 0 ? 1 : 0;
        flags = (byte)(flags | (maxIdle < 0 ? 2 : 0));
        buf.writeByte(flags);
        if (lifespan >= 0) {
            buf.writeLong(MetadataUtils.extractCreated(entry));
            ExtendedByteBuf.writeUnsignedInt(lifespan, buf);
        }
        if (maxIdle >= 0) {
            buf.writeLong(MetadataUtils.extractLastUsed(entry));
            ExtendedByteBuf.writeUnsignedInt(maxIdle, buf);
        }
        buf.writeLong(MetadataUtils.extractVersion(entry));
        ExtendedByteBuf.writeRangedBytes((byte[])entry.getValue(), buf);
        return buf;
    }

    @Override
    public ByteBuf getStreamResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, int offset, CacheEntry<byte[], byte[]> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf getAllResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, Map<byte[], byte[]> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf bulkGetKeysResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, CloseableIterator<byte[]> iterator) {
        ByteBuf buf = this.writeHeader(header, server, alloc, OperationStatus.Success);
        while (iterator.hasNext()) {
            byte[] key = (byte[])iterator.next();
            buf.writeByte(1);
            ExtendedByteBuf.writeRangedBytes(key, buf);
        }
        buf.writeByte(0);
        return buf;
    }

    @Override
    public ByteBuf iterationStartResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, String iterationId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf iterationNextResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, IterableIterationResult iterationResult) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf counterConfigurationResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, CounterConfiguration configuration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf counterNamesResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, Collection<String> counterNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf multimapCollectionResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, OperationStatus status, Collection<byte[]> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf multimapEntryResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, OperationStatus status, CacheEntry<WrappedByteArray, Collection<WrappedByteArray>> ce, Collection<byte[]> result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf booleanResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, boolean result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf unsignedLongResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuf valueWithVersionResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, byte[] value, long version) {
        ByteBuf buf = this.writeHeader(header, server, alloc, OperationStatus.Success);
        buf.writeLong(version);
        ExtendedByteBuf.writeRangedBytes(value, buf);
        return buf;
    }

    @Override
    public ByteBuf longResponse(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OperationStatus errorStatus(Throwable t) {
        return OperationStatus.ServerError;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ByteBuf writeHeader(HotRodHeader header, HotRodServer server, ByteBufAllocator alloc, OperationStatus status) {
        ByteBuf buf = alloc.ioBuffer();
        AbstractTopologyResponse topologyResp = this.getTopologyResponse(header, server.getAddressCache(), server);
        buf.writeByte(161);
        ExtendedByteBuf.writeUnsignedLong(header.messageId, buf);
        buf.writeByte(header.op.getResponseOpCode());
        buf.writeByte((int)status.getCode());
        if (topologyResp != null) {
            if (topologyResp instanceof TopologyAwareResponse) {
                TopologyAwareResponse tar = (TopologyAwareResponse)topologyResp;
                if (header.clientIntel == 2) {
                    this.writeTopologyUpdate(tar, buf);
                    return buf;
                } else {
                    this.writeLimitedHashTopologyUpdate(tar, buf);
                }
                return buf;
            } else {
                if (!(topologyResp instanceof AbstractHashDistAwareResponse)) throw new IllegalArgumentException("Unsupported response instance: " + topologyResp);
                this.writeHashTopologyUpdate((AbstractHashDistAwareResponse)topologyResp, server, header, buf);
            }
            return buf;
        } else {
            this.writeNoTopologyUpdate(buf);
        }
        return buf;
    }

    private AbstractTopologyResponse getTopologyResponse(HotRodHeader header, Cache<Address, ServerAddress> addressCache, HotRodServer server) {
        if (addressCache != null) {
            switch (header.clientIntel) {
                case 2: 
                case 3: {
                    int currentTopologyId;
                    AdvancedCache cache = server.getCacheInstance(HotRodServer.UNKNOWN_TYPES, null, header.cacheName, addressCache.getCacheManager(), false, true);
                    RpcManager rpcManager = cache.getRpcManager();
                    int n = currentTopologyId = rpcManager == null ? -1 : rpcManager.getTopologyId();
                    if (currentTopologyId < -1 || header.topologyId >= currentTopologyId) break;
                    return this.generateTopologyResponse(header, addressCache, server, currentTopologyId);
                }
            }
        }
        return null;
    }

    private AbstractTopologyResponse generateTopologyResponse(HotRodHeader header, Cache<Address, ServerAddress> addressCache, HotRodServer server, int currentTopologyId) {
        AdvancedCache cache = server.getCacheInstance(HotRodServer.UNKNOWN_TYPES, null, header.cacheName, addressCache.getCacheManager(), false, true);
        List cacheMembers = cache.getRpcManager().getMembers();
        int responseTopologyId = currentTopologyId;
        if (!addressCache.keySet().containsAll((Collection)cacheMembers)) {
            int clientTopologyId = header.topologyId;
            if (currentTopologyId - clientTopologyId < 2) {
                return null;
            }
            --responseTopologyId;
        }
        Configuration config = cache.getCacheConfiguration();
        if (header.clientIntel == 2 || !config.clustering().cacheMode().isDistributed()) {
            return new TopologyAwareResponse(responseTopologyId, (Map<Address, ServerAddress>)addressCache, 0);
        }
        return this.createHashDistAwareResp(responseTopologyId, (Map<Address, ServerAddress>)addressCache, config);
    }

    protected AbstractHashDistAwareResponse createHashDistAwareResp(int topologyId, Map<Address, ServerAddress> serverEndpointsMap, Configuration cfg) {
        return new HashDistAwareResponse(topologyId, serverEndpointsMap, 0, cfg.clustering().hash().numOwners(), 2, Integer.MAX_VALUE);
    }

    void writeHashTopologyUpdate(AbstractHashDistAwareResponse h, HotRodServer server, HotRodHeader header, ByteBuf buffer) {
        AdvancedCache cache = server.getCacheInstance(HotRodServer.UNKNOWN_TYPES, null, header.cacheName, server.getCacheManager(), false, true);
        DistributionManager distManager = cache.getDistributionManager();
        ConsistentHash ch = distManager.getWriteConsistentHash();
        Map topologyMap = h.serverEndpointsMap;
        if (topologyMap.isEmpty()) {
            log.noMembersInHashTopology(ch, topologyMap.toString());
            buffer.writeByte(0);
        } else {
            log.tracef("Write hash distribution change response header %s", h);
            int numSegments = ch.getNumSegments();
            KeyPartitioner keyPartitioner = ((PartitionerConsistentHash)ch).getKeyPartitioner();
            List<Integer> segmentHashIds = this.extractSegmentEndHashes(keyPartitioner);
            ArrayList<KeyValuePair> serverHashes = new ArrayList<KeyValuePair>(numSegments);
            for (Map.Entry entry : topologyMap.entrySet()) {
                for (int segmentIdx = 0; segmentIdx < numSegments; ++segmentIdx) {
                    int ownerIdx = ch.locateOwnersForSegment(segmentIdx).indexOf(entry.getKey());
                    if (ownerIdx < 0) continue;
                    Integer segmentHashId = segmentHashIds.get(segmentIdx);
                    int hashId = segmentHashId + ownerIdx & Integer.MAX_VALUE;
                    serverHashes.add(new KeyValuePair((Object)((ServerAddress)entry.getValue()), (Object)hashId));
                }
            }
            int totalNumServers = serverHashes.size();
            this.writeCommonHashTopologyHeader(buffer, h.topologyId, h.numOwners, h.hashFunction, h.hashSpace, totalNumServers);
            for (KeyValuePair serverHash : serverHashes) {
                ExtendedByteBuf.writeString(((ServerAddress)serverHash.getKey()).getHost(), buffer);
                ExtendedByteBuf.writeUnsignedShort(((ServerAddress)serverHash.getKey()).getPort(), buffer);
                int hashId = (Integer)serverHash.getValue();
                if (this.trace) {
                    log.tracef("Writing hash id %d for %s:%s", hashId, ((ServerAddress)serverHash.getKey()).getHost(), ((ServerAddress)serverHash.getKey()).getPort());
                }
                buffer.writeInt(hashId);
            }
        }
    }

    private List<Integer> extractSegmentEndHashes(KeyPartitioner keyPartitioner) {
        if (keyPartitioner instanceof HashFunctionPartitioner) {
            return ((HashFunctionPartitioner)keyPartitioner).getSegmentEndHashes();
        }
        if (keyPartitioner instanceof GroupingPartitioner) {
            return this.extractSegmentEndHashes(((GroupingPartitioner)keyPartitioner).unwrap());
        }
        return Collections.emptyList();
    }

    void writeLimitedHashTopologyUpdate(AbstractTopologyResponse t, ByteBuf buffer) {
        log.tracef("Return limited hash distribution aware header because the client %s doesn't ", t);
        Map<Address, ServerAddress> topologyMap = t.serverEndpointsMap;
        if (topologyMap.isEmpty()) {
            log.noMembersInTopology();
            buffer.writeByte(0);
        } else {
            this.writeCommonHashTopologyHeader(buffer, t.topologyId, 0, (byte)0, 0, topologyMap.size());
            for (ServerAddress address : topologyMap.values()) {
                ExtendedByteBuf.writeString(address.getHost(), buffer);
                ExtendedByteBuf.writeUnsignedShort(address.getPort(), buffer);
                buffer.writeInt(0);
            }
        }
    }

    private void writeTopologyUpdate(TopologyAwareResponse t, ByteBuf buffer) {
        Map topologyMap = t.serverEndpointsMap;
        if (topologyMap.isEmpty()) {
            log.noMembersInTopology();
            buffer.writeByte(0);
        } else {
            log.tracef("Write topology change response header %s", t);
            buffer.writeByte(1);
            ExtendedByteBuf.writeUnsignedInt(t.topologyId, buffer);
            ExtendedByteBuf.writeUnsignedInt(topologyMap.size(), buffer);
            for (ServerAddress address : topologyMap.values()) {
                ExtendedByteBuf.writeString(address.getHost(), buffer);
                ExtendedByteBuf.writeUnsignedShort(address.getPort(), buffer);
            }
        }
    }

    private void writeNoTopologyUpdate(ByteBuf buffer) {
        log.trace("Write topology response header with no change");
        buffer.writeByte(0);
    }

    void writeCommonHashTopologyHeader(ByteBuf buffer, int viewId, int numOwners, byte hashFct, int hashSpace, int numServers) {
        buffer.writeByte(1);
        ExtendedByteBuf.writeUnsignedInt(viewId, buffer);
        ExtendedByteBuf.writeUnsignedShort(numOwners, buffer);
        buffer.writeByte((int)hashFct);
        ExtendedByteBuf.writeUnsignedInt(hashSpace, buffer);
        ExtendedByteBuf.writeUnsignedInt(numServers, buffer);
        log.tracef("Topology will contain %d addresses", numServers);
    }
}

