/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.resp.Resp3AuthHandler;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.SubscriberHandler;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;

public class Resp3Handler
extends Resp3AuthHandler {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private static final ByteBuf OK = RespRequestHandler.stringToByteBuf("+OK\r\n", ByteBufAllocator.DEFAULT);

    Resp3Handler(RespServer respServer) {
        super(respServer);
    }

    static ByteBuf statusOK() {
        return OK.retain();
    }

    @Override
    public RespRequestHandler handleRequest(ChannelHandlerContext ctx, String type, List<byte[]> arguments) {
        switch (type) {
            case "PING": {
                if (arguments.size() == 0) {
                    ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("$4\r\nPONG\r\n", ctx.alloc()));
                    break;
                }
            }
            case "ECHO": {
                byte[] argument = arguments.get(0);
                ByteBuf bufferToWrite = RespRequestHandler.stringToByteBufWithExtra("$" + argument.length + "\r\n", ctx.alloc(), argument.length + 2);
                bufferToWrite.writeBytes(argument);
                bufferToWrite.writeByte(13).writeByte(10);
                ctx.writeAndFlush((Object)bufferToWrite);
                break;
            }
            case "SET": {
                this.performSet(ctx, (Cache<byte[], byte[]>)this.cache, arguments.get(0), arguments.get(1), -1L, type, Resp3Handler.statusOK());
                break;
            }
            case "GET": {
                byte[] keyBytes = arguments.get(0);
                this.cache.getAsync((Object)keyBytes).whenComplete((innerValueBytes, t) -> {
                    if (t != null) {
                        log.trace((Object)"Exception encountered while performing GET", t);
                        Resp3Handler.handleThrowable(ctx, t);
                    } else if (innerValueBytes != null) {
                        int length = ((byte[])innerValueBytes).length;
                        ByteBuf buf = RespRequestHandler.stringToByteBufWithExtra("$" + length + "\r\n", ctx.alloc(), length + 2);
                        buf.writeBytes(innerValueBytes);
                        buf.writeByte(13).writeByte(10);
                        ctx.writeAndFlush((Object)buf);
                    } else {
                        ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("$-1\r\n", ctx.alloc()));
                    }
                });
                break;
            }
            case "DEL": {
                int keysToRemove = arguments.size();
                if (keysToRemove == 1) {
                    byte[] keyBytes = arguments.get(0);
                    this.cache.removeAsync((Object)keyBytes).whenComplete((prev, t) -> {
                        if (t != null) {
                            log.trace((Object)"Exception encountered while performing DEL", t);
                            Resp3Handler.handleThrowable(ctx, t);
                            return;
                        }
                        ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf(":" + (prev == null ? "0" : "1") + "\r\n", ctx.alloc()));
                    });
                    break;
                }
                if (keysToRemove == 0) {
                    ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf(":0\r\n", ctx.alloc()));
                    break;
                }
                AtomicInteger removes = new AtomicInteger();
                AggregateCompletionStage deleteStages = CompletionStages.aggregateCompletionStage((Object)removes);
                for (byte[] keyBytesLoop : arguments) {
                    deleteStages.dependsOn(this.cache.removeAsync((Object)keyBytesLoop).thenAccept(prev -> {
                        if (prev != null) {
                            removes.incrementAndGet();
                        }
                    }));
                }
                deleteStages.freeze().whenComplete((removals, t) -> {
                    if (t != null) {
                        log.trace((Object)"Exception encountered while performing multiple DEL", t);
                        Resp3Handler.handleThrowable(ctx, t);
                        return;
                    }
                    ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf(":" + removals.get() + "\r\n", ctx.alloc()));
                });
                break;
            }
            case "MGET": {
                int keysToRetrieve = arguments.size();
                if (keysToRetrieve == 0) {
                    ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("*0\r\n", ctx.alloc()));
                    break;
                }
                List results = Collections.synchronizedList(Arrays.asList(new byte[keysToRetrieve][]));
                AtomicInteger resultBytesSize = new AtomicInteger();
                AggregateCompletionStage getStage = CompletionStages.aggregateCompletionStage();
                for (int i = 0; i < keysToRetrieve; ++i) {
                    int innerCount = i;
                    byte[] keyBytes = arguments.get(i);
                    getStage.dependsOn(this.cache.getAsync((Object)keyBytes).whenComplete((returnValue, t) -> {
                        if (returnValue != null) {
                            results.set(innerCount, returnValue);
                            int length = ((byte[])returnValue).length;
                            if (length > 0) {
                                resultBytesSize.addAndGet(((byte[])returnValue).length + (int)Math.log10(length) + 1 + 1);
                            } else {
                                resultBytesSize.addAndGet(2);
                            }
                        } else {
                            resultBytesSize.addAndGet(3);
                        }
                        resultBytesSize.addAndGet(2);
                    }));
                }
                getStage.freeze().whenComplete((ignore, t) -> {
                    if (t != null) {
                        log.trace((Object)"Exception encountered while performing multiple DEL", t);
                        Resp3Handler.handleThrowable(ctx, t);
                        return;
                    }
                    int elements = results.size();
                    ByteBuf byteBuf = ctx.alloc().buffer(resultBytesSize.addAndGet(1 + (int)Math.log10(elements) + 1 + 2));
                    byteBuf.writeCharSequence((CharSequence)("*" + results.size()), CharsetUtil.UTF_8);
                    byteBuf.writeByte(13);
                    byteBuf.writeByte(10);
                    for (byte[] value : results) {
                        if (value == null) {
                            byteBuf.writeCharSequence((CharSequence)"$-1", CharsetUtil.UTF_8);
                        } else {
                            byteBuf.writeCharSequence((CharSequence)("$" + value.length), CharsetUtil.UTF_8);
                            byteBuf.writeByte(13);
                            byteBuf.writeByte(10);
                            byteBuf.writeBytes(value);
                        }
                        byteBuf.writeByte(13);
                        byteBuf.writeByte(10);
                    }
                    ctx.writeAndFlush((Object)byteBuf);
                });
                break;
            }
            case "MSET": {
                int keyValuePairCount = arguments.size();
                if ((keyValuePairCount & 1) == 1) {
                    log.tracef("Received: %s count for keys and values combined, should be even for MSET", keyValuePairCount);
                    ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-ERR Missing a value for a key\r\n", ctx.alloc()));
                    break;
                }
                AggregateCompletionStage setStage = CompletionStages.aggregateCompletionStage();
                for (int i = 0; i < keyValuePairCount; i += 2) {
                    byte[] keyBytes = arguments.get(i);
                    byte[] valueBytes = arguments.get(i + 1);
                    setStage.dependsOn((CompletionStage)this.cache.putAsync((Object)keyBytes, (Object)valueBytes));
                }
                setStage.freeze().whenComplete((ignore, t) -> {
                    if (t != null) {
                        log.trace((Object)"Exception encountered while performing MSET", t);
                        Resp3Handler.handleThrowable(ctx, t);
                    } else {
                        ctx.writeAndFlush((Object)Resp3Handler.statusOK());
                    }
                });
                break;
            }
            case "INCR": {
                Resp3Handler.counterIncOrDec((Cache<byte[], byte[]>)this.cache, arguments.get(0), true).whenComplete((longValue, t) -> {
                    if (t != null) {
                        Resp3Handler.handleThrowable(ctx, t);
                    } else {
                        Resp3Handler.handleLongResult(ctx, longValue);
                    }
                });
                break;
            }
            case "DECR": {
                Resp3Handler.counterIncOrDec((Cache<byte[], byte[]>)this.cache, arguments.get(0), false).whenComplete((longValue, t) -> {
                    if (t != null) {
                        Resp3Handler.handleThrowable(ctx, t);
                    } else {
                        Resp3Handler.handleLongResult(ctx, longValue);
                    }
                });
                break;
            }
            case "INFO": {
                ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-ERR not implemented yet\r\n", ctx.alloc()));
                break;
            }
            case "PUBLISH": {
                this.performSet(ctx, (Cache<byte[], byte[]>)this.cache, SubscriberHandler.keyToChannel(arguments.get(0)), arguments.get(1), 3L, type, RespRequestHandler.stringToByteBuf(":0\r\n", ctx.alloc()));
                break;
            }
            case "SUBSCRIBE": {
                SubscriberHandler subscriberHandler = new SubscriberHandler(this.respServer, this);
                return subscriberHandler.handleRequest(ctx, type, arguments);
            }
            case "SELECT": {
                ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-ERR Select not supported in cluster mode\r\n", ctx.alloc()));
                break;
            }
            case "READWRITE": 
            case "READONLY": {
                ctx.writeAndFlush((Object)Resp3Handler.statusOK());
                break;
            }
            case "RESET": {
                ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("+RESET\r\n", ctx.alloc()));
                if (!((RespServerConfiguration)this.respServer.getConfiguration()).authentication().enabled()) break;
                return new Resp3AuthHandler(this.respServer);
            }
            case "COMMAND": {
                if (!arguments.isEmpty()) {
                    ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-ERR COMMAND does not currently support arguments\r\n", ctx.alloc()));
                    break;
                }
                StringBuilder commandBuilder = new StringBuilder();
                commandBuilder.append("*20\r\n");
                Resp3Handler.addCommand(commandBuilder, "HELLO", -1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "AUTH", -2, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "PING", -2, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "ECHO", 2, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "GET", 2, 1, 1, 1);
                Resp3Handler.addCommand(commandBuilder, "SET", -3, 1, 1, 1);
                Resp3Handler.addCommand(commandBuilder, "DEL", -2, 1, -1, 1);
                Resp3Handler.addCommand(commandBuilder, "MGET", -2, 1, -1, 1);
                Resp3Handler.addCommand(commandBuilder, "MSET", -3, 1, 1, 2);
                Resp3Handler.addCommand(commandBuilder, "INCR", 2, 1, 1, 1);
                Resp3Handler.addCommand(commandBuilder, "DECR", 2, 1, 1, 1);
                Resp3Handler.addCommand(commandBuilder, "INFO", -1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "PUBLISH", 3, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "SUBSCRIBE", -2, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "SELECT", -1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "READWRITE", 1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "READONLY", 1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "RESET", 1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "QUIT", 1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "COMMAND", -1, 0, 0, 0);
                ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf(commandBuilder.toString(), ctx.alloc()));
                break;
            }
            default: {
                return super.handleRequest(ctx, type, arguments);
            }
        }
        return this;
    }

    private static void addCommand(StringBuilder builder, String name, int arity, int firstKeyPos, int lastKeyPos, int steps) {
        builder.append("*6\r\n");
        builder.append("$").append(ByteBufUtil.utf8Bytes((CharSequence)name)).append("\r\n").append(name).append("\r\n");
        builder.append(":").append(arity).append("\r\n");
        builder.append("*0\r\n");
        builder.append(":").append(firstKeyPos).append("\r\n");
        builder.append(":").append(lastKeyPos).append("\r\n");
        builder.append(":").append(steps).append("\r\n");
    }

    private static void handleLongResult(ChannelHandlerContext ctx, Long result) {
        ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf(":" + result + "\r\n", ctx.alloc()));
    }

    static void handleThrowable(ChannelHandlerContext ctx, Throwable t) {
        ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-ERR" + t.getMessage() + "\r\n", ctx.alloc()));
    }

    private static CompletionStage<Long> counterIncOrDec(Cache<byte[], byte[]> cache, byte[] key, boolean increment) {
        return cache.getAsync((Object)key).thenCompose(currentValueBytes -> {
            if (currentValueBytes != null) {
                long prevIntValue;
                String prevValue = new String((byte[])currentValueBytes, CharsetUtil.UTF_8);
                try {
                    prevIntValue = Long.parseLong(prevValue) + (long)(increment ? 1 : -1);
                }
                catch (NumberFormatException e) {
                    throw new CacheException("value is not an integer or out of range");
                }
                String newValueString = String.valueOf(prevIntValue);
                byte[] newValueBytes = newValueString.getBytes(CharsetUtil.UTF_8);
                return cache.replaceAsync((Object)key, currentValueBytes, (Object)newValueBytes).thenCompose(replaced -> {
                    if (replaced.booleanValue()) {
                        return CompletableFuture.completedFuture(prevIntValue);
                    }
                    return Resp3Handler.counterIncOrDec(cache, key, increment);
                });
            }
            long longValue = increment ? 1L : -1L;
            byte[] valueToPut = String.valueOf(longValue).getBytes(CharsetUtil.UTF_8);
            return cache.putIfAbsentAsync((Object)key, (Object)valueToPut).thenCompose(prev -> {
                if (prev != null) {
                    return Resp3Handler.counterIncOrDec(cache, key, increment);
                }
                return CompletableFuture.completedFuture(longValue);
            });
        });
    }

    private void performSet(ChannelHandlerContext ctx, Cache<byte[], byte[]> cache, byte[] key, byte[] value, long lifespan, String type, ByteBuf messageOnSuccess) {
        cache.putAsync((Object)key, (Object)value, lifespan, TimeUnit.SECONDS).whenComplete((ignore, t) -> {
            if (t != null) {
                log.trace((Object)("Exception encountered while performing " + type), t);
                Resp3Handler.handleThrowable(ctx, t);
            } else {
                ctx.writeAndFlush((Object)messageOnSuccess);
            }
        });
    }
}

