/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.PushOutput;
import io.lettuce.core.protocol.RedisStateMachine;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.logging.Log;

public class RespLettuceHandler
extends ByteToMessageDecoder {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private final RedisStateMachine stateMachine = new RedisStateMachine(ByteBufAllocator.DEFAULT);
    private RespRequestHandler requestHandler;

    public RespLettuceHandler(RespRequestHandler initialHandler) {
        this.requestHandler = initialHandler;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        PushOutput pushOutput = new PushOutput((RedisCodec)ByteArrayCodec.INSTANCE);
        if (this.stateMachine.decode(in, (CommandOutput)pushOutput)) {
            String type = pushOutput.getType().toUpperCase();
            List content = pushOutput.getContent();
            this.requestHandler = this.requestHandler.handleRequest(ctx, type, content.subList(1, content.size()));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.unexpectedException(cause);
        ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-ERR Server Error Encountered: " + cause.getMessage() + "\r\n", ctx.alloc()));
        ctx.close();
    }
}

