/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.CharsetUtil;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.context.Flag;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.Resp3AuthHandler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.SubscriberHandler;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.operation.SetOperation;
import org.infinispan.server.resp.response.SetResponse;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;

public class Resp3Handler
extends Resp3AuthHandler {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    static final byte[] OK = "+OK\r\n".getBytes(StandardCharsets.US_ASCII);
    protected AdvancedCache<byte[], byte[]> ignorePreviousValueCache;
    protected static final BiConsumer<byte[], ByteBufPool> GET_BICONSUMER = (innerValueBytes, alloc) -> {
        if (innerValueBytes != null) {
            Resp3Handler.bytesToResult(innerValueBytes, alloc);
        } else {
            Resp3Handler.stringToByteBuf("$-1\r\n", alloc);
        }
    };
    protected static final BiConsumer<Object, ByteBufPool> OK_BICONSUMER = (ignore, alloc) -> alloc.acquire(OK.length).writeBytes(OK);
    protected static final BiConsumer<SetResponse, ByteBufPool> SET_BICONSUMER = (res, alloc) -> {
        if (res.isReturnValue()) {
            GET_BICONSUMER.accept(res.value(), (ByteBufPool)alloc);
            return;
        }
        if (res.isSuccess()) {
            OK_BICONSUMER.accept(res, (ByteBufPool)alloc);
            return;
        }
        GET_BICONSUMER.accept((byte[])null, (ByteBufPool)alloc);
    };
    protected static final BiConsumer<Long, ByteBufPool> LONG_BICONSUMER = Resp3Handler::handleLongResult;
    protected static final BiConsumer<byte[], ByteBufPool> DELETE_BICONSUMER = (prev, alloc) -> Resp3Handler.stringToByteBuf(":" + (prev == null ? "0" : "1") + "\r\n", alloc);

    Resp3Handler(RespServer respServer) {
        super(respServer);
    }

    @Override
    protected void setCache(AdvancedCache<byte[], byte[]> cache) {
        super.setCache(cache);
        this.ignorePreviousValueCache = cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.IGNORE_RETURN_VALUES});
    }

    @Override
    protected CompletionStage<RespRequestHandler> actualHandleRequest(ChannelHandlerContext ctx, RespCommand type, List<byte[]> arguments) {
        switch (type) {
            case PING: {
                if (arguments.size() == 0) {
                    Resp3Handler.stringToByteBuf("$4\r\nPONG\r\n", this.allocatorToUse);
                    break;
                }
            }
            case ECHO: {
                byte[] argument = arguments.get(0);
                ByteBuf bufferToWrite = Resp3Handler.stringToByteBufWithExtra("$" + argument.length + "\r\n", this.allocatorToUse, argument.length + 2);
                bufferToWrite.writeBytes(argument);
                bufferToWrite.writeByte(13).writeByte(10);
                break;
            }
            case SET: {
                if (arguments.size() != 2) {
                    return this.stageToReturn(SetOperation.performOperation((AdvancedCache<byte[], byte[]>)this.cache, arguments), ctx, SET_BICONSUMER);
                }
                return this.stageToReturn(this.ignorePreviousValueCache.putAsync((Object)arguments.get(0), (Object)arguments.get(1)), ctx, OK_BICONSUMER);
            }
            case GET: {
                byte[] keyBytes = arguments.get(0);
                return this.stageToReturn(this.cache.getAsync((Object)keyBytes), ctx, GET_BICONSUMER);
            }
            case DEL: {
                return this.performDelete(ctx, (Cache<byte[], byte[]>)this.cache, arguments);
            }
            case MGET: {
                return this.performMget(ctx, (Cache<byte[], byte[]>)this.cache, arguments);
            }
            case MSET: {
                return this.performMset(ctx, (Cache<byte[], byte[]>)this.cache, arguments);
            }
            case INCR: {
                return this.stageToReturn(Resp3Handler.counterIncOrDec((Cache<byte[], byte[]>)this.cache, arguments.get(0), true), ctx, LONG_BICONSUMER);
            }
            case DECR: {
                return this.stageToReturn(Resp3Handler.counterIncOrDec((Cache<byte[], byte[]>)this.cache, arguments.get(0), false), ctx, LONG_BICONSUMER);
            }
            case CONFIG: {
                String getOrSet = new String(arguments.get(0), StandardCharsets.UTF_8);
                String name = new String(arguments.get(1), StandardCharsets.UTF_8);
                if ("GET".equalsIgnoreCase(getOrSet)) {
                    if ("appendonly".equalsIgnoreCase(name)) {
                        Resp3Handler.stringToByteBuf("*2\r\n+" + name + "\r\n+no\r\n", this.allocatorToUse);
                        break;
                    }
                    if (name.indexOf(42) != -1 || name.indexOf(63) != -1) {
                        Resp3Handler.stringToByteBuf("-ERR CONFIG blob pattern matching not implemented\r\n", this.allocatorToUse);
                        break;
                    }
                    Resp3Handler.stringToByteBuf("*2\r\n+" + name + "\r\n+\r\n", this.allocatorToUse);
                    break;
                }
                if ("SET".equalsIgnoreCase(getOrSet)) {
                    OK_BICONSUMER.accept(null, this.allocatorToUse);
                    break;
                }
                Resp3Handler.stringToByteBuf("-ERR CONFIG " + getOrSet + " not implemented\r\n", this.allocatorToUse);
                break;
            }
            case INFO: {
                Resp3Handler.stringToByteBuf("-ERR not implemented yet\r\n", this.allocatorToUse);
                break;
            }
            case PUBLISH: {
                return this.stageToReturn(this.ignorePreviousValueCache.putAsync((Object)SubscriberHandler.keyToChannel(arguments.get(0)), (Object)arguments.get(1), 3L, TimeUnit.SECONDS), ctx, (? super E ignore, ByteBufPool alloc) -> Resp3Handler.stringToByteBuf(":0\r\n", alloc));
            }
            case SUBSCRIBE: {
                SubscriberHandler subscriberHandler = new SubscriberHandler(this.respServer, this);
                return subscriberHandler.handleRequest(ctx, type, arguments);
            }
            case SELECT: {
                Resp3Handler.stringToByteBuf("-ERR Select not supported in cluster mode\r\n", this.allocatorToUse);
                break;
            }
            case READWRITE: 
            case READONLY: {
                OK_BICONSUMER.accept(null, this.allocatorToUse);
                break;
            }
            case RESET: {
                Resp3Handler.stringToByteBuf("+RESET\r\n", this.allocatorToUse);
                if (!((RespServerConfiguration)this.respServer.getConfiguration()).authentication().enabled()) break;
                return CompletableFuture.completedFuture(new Resp3AuthHandler(this.respServer));
            }
            case COMMAND: {
                if (!arguments.isEmpty()) {
                    Resp3Handler.stringToByteBuf("-ERR COMMAND does not currently support arguments\r\n", this.allocatorToUse);
                    break;
                }
                StringBuilder commandBuilder = new StringBuilder();
                commandBuilder.append("*21\r\n");
                Resp3Handler.addCommand(commandBuilder, "HELLO", -1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "AUTH", -2, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "PING", -2, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "ECHO", 2, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "GET", 2, 1, 1, 1);
                Resp3Handler.addCommand(commandBuilder, "SET", -3, 1, 1, 1);
                Resp3Handler.addCommand(commandBuilder, "DEL", -2, 1, -1, 1);
                Resp3Handler.addCommand(commandBuilder, "CONFIG", -2, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "MGET", -2, 1, -1, 1);
                Resp3Handler.addCommand(commandBuilder, "MSET", -3, 1, 1, 2);
                Resp3Handler.addCommand(commandBuilder, "INCR", 2, 1, 1, 1);
                Resp3Handler.addCommand(commandBuilder, "DECR", 2, 1, 1, 1);
                Resp3Handler.addCommand(commandBuilder, "INFO", -1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "PUBLISH", 3, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "SUBSCRIBE", -2, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "SELECT", -1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "READWRITE", 1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "READONLY", 1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "RESET", 1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "QUIT", 1, 0, 0, 0);
                Resp3Handler.addCommand(commandBuilder, "COMMAND", -1, 0, 0, 0);
                Resp3Handler.stringToByteBuf(commandBuilder.toString(), this.allocatorToUse);
                break;
            }
            default: {
                return super.actualHandleRequest(ctx, type, arguments);
            }
        }
        return this.myStage;
    }

    private static void addCommand(StringBuilder builder, String name, int arity, int firstKeyPos, int lastKeyPos, int steps) {
        builder.append("*6\r\n");
        builder.append("$").append(ByteBufUtil.utf8Bytes((CharSequence)name)).append("\r\n").append(name).append("\r\n");
        builder.append(":").append(arity).append("\r\n");
        builder.append("*0\r\n");
        builder.append(":").append(firstKeyPos).append("\r\n");
        builder.append(":").append(lastKeyPos).append("\r\n");
        builder.append(":").append(steps).append("\r\n");
    }

    protected static void handleLongResult(Long result, ByteBufPool alloc) {
        Resp3Handler.stringToByteBuf(":" + result + "\r\n", alloc);
    }

    protected static void handleThrowable(ByteBufPool alloc, Throwable t) {
        Resp3Handler.stringToByteBuf("-ERR " + t.getMessage() + "\r\n", alloc);
    }

    private static CompletionStage<Long> counterIncOrDec(Cache<byte[], byte[]> cache, byte[] key, boolean increment) {
        return cache.getAsync((Object)key).thenCompose(currentValueBytes -> {
            if (currentValueBytes != null) {
                long prevIntValue;
                String prevValue = new String((byte[])currentValueBytes, CharsetUtil.US_ASCII);
                try {
                    prevIntValue = Long.parseLong(prevValue) + (long)(increment ? 1 : -1);
                }
                catch (NumberFormatException e) {
                    throw new CacheException("value is not an integer or out of range");
                }
                String newValueString = String.valueOf(prevIntValue);
                byte[] newValueBytes = newValueString.getBytes(CharsetUtil.US_ASCII);
                return cache.replaceAsync((Object)key, currentValueBytes, (Object)newValueBytes).thenCompose(replaced -> {
                    if (replaced.booleanValue()) {
                        return CompletableFuture.completedFuture(prevIntValue);
                    }
                    return Resp3Handler.counterIncOrDec(cache, key, increment);
                });
            }
            long longValue = increment ? 1L : -1L;
            byte[] valueToPut = String.valueOf(longValue).getBytes(CharsetUtil.US_ASCII);
            return cache.putIfAbsentAsync((Object)key, (Object)valueToPut).thenCompose(prev -> {
                if (prev != null) {
                    return Resp3Handler.counterIncOrDec(cache, key, increment);
                }
                return CompletableFuture.completedFuture(longValue);
            });
        });
    }

    private CompletionStage<RespRequestHandler> performDelete(ChannelHandlerContext ctx, Cache<byte[], byte[]> cache, List<byte[]> arguments) {
        int keysToRemove = arguments.size();
        if (keysToRemove == 1) {
            byte[] keyBytes = arguments.get(0);
            return this.stageToReturn(cache.removeAsync((Object)keyBytes), ctx, DELETE_BICONSUMER);
        }
        if (keysToRemove == 0) {
            Resp3Handler.stringToByteBuf(":0\r\n", this.allocatorToUse);
            return this.myStage;
        }
        AtomicInteger removes = new AtomicInteger();
        AggregateCompletionStage deleteStages = CompletionStages.aggregateCompletionStage((Object)removes);
        for (byte[] keyBytesLoop : arguments) {
            deleteStages.dependsOn(cache.removeAsync((Object)keyBytesLoop).thenAccept(prev -> {
                if (prev != null) {
                    removes.incrementAndGet();
                }
            }));
        }
        return this.stageToReturn(deleteStages.freeze(), ctx, (? super E removals, ByteBufPool alloc) -> Resp3Handler.stringToByteBuf(":" + removals.get() + "\r\n", alloc));
    }

    private CompletionStage<RespRequestHandler> performMget(ChannelHandlerContext ctx, Cache<byte[], byte[]> cache, List<byte[]> arguments) {
        int keysToRetrieve = arguments.size();
        if (keysToRetrieve == 0) {
            Resp3Handler.stringToByteBuf("*0\r\n", this.allocatorToUse);
            return this.myStage;
        }
        List results = Collections.synchronizedList(Arrays.asList(new byte[keysToRetrieve][]));
        AtomicInteger resultBytesSize = new AtomicInteger();
        AggregateCompletionStage getStage = CompletionStages.aggregateCompletionStage();
        for (int i = 0; i < keysToRetrieve; ++i) {
            int innerCount = i;
            byte[] keyBytes = arguments.get(i);
            getStage.dependsOn(cache.getAsync((Object)keyBytes).whenComplete((returnValue, t) -> {
                if (returnValue != null) {
                    results.set(innerCount, returnValue);
                    int length = ((byte[])returnValue).length;
                    if (length > 0) {
                        resultBytesSize.addAndGet(1 + (int)Math.log10(length) + 1 + 2 + ((byte[])returnValue).length);
                    } else {
                        resultBytesSize.addAndGet(4);
                    }
                } else {
                    resultBytesSize.addAndGet(3);
                }
                resultBytesSize.addAndGet(2);
            }));
        }
        return this.stageToReturn(getStage.freeze(), ctx, (? super E ignore, ByteBufPool alloc) -> {
            int elements = results.size();
            int byteAmount = 1 + (int)Math.log10(elements) + 1 + 2 + resultBytesSize.get();
            ByteBuf byteBuf = (ByteBuf)alloc.apply(byteAmount);
            byteBuf.writeCharSequence((CharSequence)("*" + results.size()), CharsetUtil.US_ASCII);
            byteBuf.writeByte(13);
            byteBuf.writeByte(10);
            for (byte[] value : results) {
                if (value == null) {
                    byteBuf.writeCharSequence((CharSequence)"$-1", CharsetUtil.US_ASCII);
                } else {
                    byteBuf.writeCharSequence((CharSequence)("$" + value.length), CharsetUtil.US_ASCII);
                    byteBuf.writeByte(13);
                    byteBuf.writeByte(10);
                    byteBuf.writeBytes(value);
                }
                byteBuf.writeByte(13);
                byteBuf.writeByte(10);
            }
            assert (byteBuf.writerIndex() == byteAmount);
        });
    }

    private CompletionStage<RespRequestHandler> performMset(ChannelHandlerContext ctx, Cache<byte[], byte[]> cache, List<byte[]> arguments) {
        int keyValuePairCount = arguments.size();
        if ((keyValuePairCount & 1) == 1) {
            log.tracef("Received: %s count for keys and values combined, should be even for MSET", keyValuePairCount);
            Resp3Handler.stringToByteBuf("-ERR Missing a value for a key\r\n", this.allocatorToUse);
            return this.myStage;
        }
        AggregateCompletionStage setStage = CompletionStages.aggregateCompletionStage();
        for (int i = 0; i < keyValuePairCount; i += 2) {
            byte[] keyBytes = arguments.get(i);
            byte[] valueBytes = arguments.get(i + 1);
            setStage.dependsOn((CompletionStage)cache.putAsync((Object)keyBytes, (Object)valueBytes));
        }
        return this.stageToReturn(setStage.freeze(), ctx, OK_BICONSUMER);
    }
}

