/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import java.nio.charset.StandardCharsets;
import org.infinispan.server.resp.RespCommand;

public class Intrinsics {
    private static final int TERMINATOR_LENGTH = 2;

    public static byte singleByte(ByteBuf buffer) {
        if (buffer.isReadable()) {
            return buffer.readByte();
        }
        return 0;
    }

    public static String simpleString(ByteBuf buf) {
        int offset = buf.forEachByte(ByteProcessor.FIND_LF);
        if (offset <= 0) {
            return null;
        }
        if (buf.getByte(offset - 1) != 13) {
            throw new IllegalStateException("No matching \r character found before \n");
        }
        String simpleString = buf.toString(buf.readerIndex(), offset - 1 - buf.readerIndex(), StandardCharsets.US_ASCII);
        buf.readerIndex(offset + 1);
        return simpleString;
    }

    public static RespCommand simpleCommand(ByteBuf buf) {
        int offset = buf.forEachByte(ByteProcessor.FIND_LF);
        if (offset <= 0) {
            return null;
        }
        if (buf.getByte(offset - 1) != 13) {
            throw new IllegalStateException("No matching \r character found before \n");
        }
        return RespCommand.fromByteBuf(buf, offset - 1 - buf.readerIndex());
    }

    public static long readNumber(ByteBuf buf, Resp2LongProcessor longProcessor) {
        long value = longProcessor.getValue(buf);
        if (longProcessor.complete && buf.readableBytes() >= longProcessor.bytesRead + 2) {
            buf.skipBytes(longProcessor.bytesRead + 2);
        }
        return value;
    }

    public static byte[] readTerminatedBytes(ByteBuf buf) {
        int offset = buf.forEachByte(ByteProcessor.FIND_LF);
        if (offset <= 0) {
            return null;
        }
        if (buf.getByte(offset - 1) != 13) {
            throw new IllegalStateException("No matching \r character found before \n");
        }
        byte[] data = new byte[offset - 1 - buf.readerIndex()];
        buf.readBytes(data);
        buf.skipBytes(2);
        return data;
    }

    private static int readSizeAndCheckRemainder(ByteBuf buf, Resp2LongProcessor longProcessor) {
        buf.markReaderIndex();
        int pos = buf.readerIndex();
        long longSize = Intrinsics.readNumber(buf, longProcessor);
        if (longSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Bytes cannot be longer than 2147483647");
        }
        if (pos == buf.readerIndex()) {
            return -1;
        }
        int size = (int)longSize;
        if (size < 0) {
            throw new IllegalArgumentException("Number cannot be negative");
        }
        if (buf.readableBytes() < size + 2) {
            buf.resetReaderIndex();
            return -1;
        }
        return size;
    }

    public static String bulkString(ByteBuf buf, Resp2LongProcessor longProcessor) {
        int size = Intrinsics.readSizeAndCheckRemainder(buf, longProcessor);
        if (size == -1) {
            return null;
        }
        String stringValue = buf.toString(buf.readerIndex(), size, StandardCharsets.US_ASCII);
        buf.skipBytes(size + 2);
        return stringValue;
    }

    public static RespCommand bulkCommand(ByteBuf buf, Resp2LongProcessor longProcessor) {
        int size = Intrinsics.readSizeAndCheckRemainder(buf, longProcessor);
        if (size == -1) {
            return null;
        }
        return RespCommand.fromByteBuf(buf, size);
    }

    public static byte[] bulkArray(ByteBuf buf, Resp2LongProcessor longProcessor) {
        int size = Intrinsics.readSizeAndCheckRemainder(buf, longProcessor);
        if (size == -1) {
            return null;
        }
        byte[] array = new byte[size];
        buf.readBytes(array);
        buf.skipBytes(2);
        return array;
    }

    static class Resp2LongProcessor
    implements ByteProcessor {
        long result;
        int bytesRead;
        boolean complete;
        boolean negative;
        boolean first;

        Resp2LongProcessor() {
        }

        public long getValue(ByteBuf buffer) {
            this.result = 0L;
            this.bytesRead = 0;
            this.complete = false;
            this.first = true;
            if (buffer.forEachByte((ByteProcessor)this) == -1) {
                this.complete = false;
                return -1L;
            }
            this.complete = true;
            if (!this.negative) {
                this.result = -this.result;
            }
            return this.result;
        }

        public boolean process(byte value) {
            if (value == 13) {
                return false;
            }
            ++this.bytesRead;
            if (this.first) {
                this.first = false;
                if (value == 45) {
                    this.negative = true;
                } else {
                    this.negative = false;
                    int digit = value - 48;
                    this.result = this.result * 10L - (long)digit;
                }
                return true;
            }
            int digit = value - 48;
            this.result = this.result * 10L - (long)digit;
            return true;
        }
    }
}

