/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.resp.Authenticator;
import org.infinispan.server.resp.RespSingleNodeTest;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional"}, testName="server.resp.RespAuthSingleNodeTest")
public class RespAuthSingleNodeTest
extends RespSingleNodeTest {
    private static final String USERNAME = "admin";
    private static final String PASSWORD = "super-password";

    @Override
    protected RespServerConfigurationBuilder serverConfiguration() {
        RespServerConfigurationBuilder builder = super.serverConfiguration();
        builder.authentication().enable().authenticator((Authenticator)new FakeRespAuthenticator());
        return builder;
    }

    @BeforeMethod(alwaysRun=true)
    public void authenticateBefore(Method method) {
        if (method.getName().endsWith("Auth")) {
            return;
        }
        RedisCommands redis = this.redisConnection.sync();
        redis.auth(USERNAME, (CharSequence)PASSWORD);
    }

    protected void teardown() {
        super.destroyAfterClass();
    }

    @Override
    public void testAuth() {
        super.testAuth();
        RedisCommands redis = this.redisConnection.sync();
        Exceptions.expectException(RedisCommandExecutionException.class, (String)"WRONGPASS invalid username-password pair or user is disabled\\.", () -> redis.set((Object)"k", (Object)"v"));
    }

    @Override
    protected RedisPubSubCommands<String, String> createPubSubConnection() {
        RedisPubSubCommands<String, String> connection = super.createPubSubConnection();
        connection.auth(USERNAME, (CharSequence)PASSWORD);
        return connection;
    }

    public static class FakeRespAuthenticator
    implements Authenticator {
        public CompletionStage<Subject> authenticate(String username, char[] password) {
            if (username.equals(RespAuthSingleNodeTest.USERNAME) && new String(password).equals(RespAuthSingleNodeTest.PASSWORD)) {
                return CompletableFuture.completedFuture(new Subject());
            }
            return CompletableFutures.completedNull();
        }
    }
}

