/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.PushOutput;
import io.lettuce.core.protocol.RedisStateMachine;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.logging.Log;
import org.infinispan.util.concurrent.CompletionStages;

public class RespLettuceHandler
extends ByteToMessageDecoder {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private final RedisStateMachine stateMachine = new RedisStateMachine(ByteBufAllocator.DEFAULT);
    private RespRequestHandler requestHandler;
    private boolean disabledRead = false;

    public RespLettuceHandler(RespRequestHandler initialHandler) {
        this.requestHandler = initialHandler;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        this.requestHandler.handleChannelDisconnect(ctx);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.disabledRead) {
            return;
        }
        PushOutput pushOutput = new PushOutput((RedisCodec)ByteArrayCodec.INSTANCE);
        if (this.stateMachine.decode(in, (CommandOutput)pushOutput)) {
            String type = pushOutput.getType().toUpperCase();
            List content = pushOutput.getContent();
            List<byte[]> contentToUse = content.subList(1, content.size());
            log.tracef("Received command: %s with arguments %s", type, Util.toStr(contentToUse));
            CompletionStage<RespRequestHandler> stage = this.requestHandler.handleRequest(ctx, type, contentToUse);
            if (CompletionStages.isCompletedSuccessfully(stage)) {
                this.requestHandler = (RespRequestHandler)CompletionStages.join(stage);
            } else {
                log.tracef("Disabling auto read for channel %s until previous command is complete", ctx.channel());
                ctx.channel().config().setAutoRead(false);
                this.disabledRead = true;
                stage.whenComplete((handler, t) -> {
                    assert (ctx.channel().eventLoop().inEventLoop());
                    log.tracef("Re-enabling auto read for channel %s as previous command is complete", ctx.channel());
                    ctx.channel().config().setAutoRead(true);
                    this.disabledRead = false;
                    if (t != null) {
                        this.exceptionCaught(ctx, (Throwable)t);
                    } else {
                        this.requestHandler = handler;
                    }
                    ByteBuf buf = this.internalBuffer();
                    if (buf.isReadable()) {
                        log.tracef("Bytes available from previous read for channel %s, trying decode directly", ctx.channel());
                        this.callDecode(ctx, buf, List.of());
                    }
                });
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.unexpectedException(cause);
        ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-ERR Server Error Encountered: " + cause.getMessage() + "\r\n", ctx.alloc()));
        ctx.close();
    }
}

