/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;

public abstract class RespRequestHandler {
    protected final CompletionStage<RespRequestHandler> myStage = CompletableFuture.completedStage(this);

    public CompletionStage<RespRequestHandler> handleRequest(ChannelHandlerContext ctx, String type, List<byte[]> arguments) {
        if ("QUIT".equals(type)) {
            ctx.close();
            return this.myStage;
        }
        ctx.writeAndFlush((Object)RespRequestHandler.stringToByteBuf("-ERR unknown command\r\n", ctx.alloc()));
        return this.myStage;
    }

    public void handleChannelDisconnect(ChannelHandlerContext ctx) {
    }

    protected <E> CompletionStage<RespRequestHandler> stageToReturn(CompletionStage<E> stage, ChannelHandlerContext ctx, BiConsumer<? super E, Throwable> biConsumer) {
        return this.stageToReturn(stage, ctx, Objects.requireNonNull(biConsumer), null);
    }

    protected <E> CompletionStage<RespRequestHandler> stageToReturn(CompletionStage<E> stage, ChannelHandlerContext ctx, Function<E, RespRequestHandler> handlerWhenComplete) {
        return this.stageToReturn(stage, ctx, null, Objects.requireNonNull(handlerWhenComplete));
    }

    private <E> CompletionStage<RespRequestHandler> stageToReturn(CompletionStage<E> stage, ChannelHandlerContext ctx, BiConsumer<? super E, Throwable> biConsumer, Function<E, RespRequestHandler> handlerWhenComplete) {
        assert (ctx.channel().eventLoop().inEventLoop());
        assert (biConsumer != null && handlerWhenComplete == null || biConsumer == null && handlerWhenComplete != null) : "biConsumer was: " + biConsumer + " and handlerWhenComplete was: " + handlerWhenComplete;
        if (CompletionStages.isCompletedSuccessfully(stage)) {
            Object result = CompletionStages.join(stage);
            try {
                if (handlerWhenComplete != null) {
                    return CompletableFuture.completedFuture(handlerWhenComplete.apply(result));
                }
                biConsumer.accept(result, null);
            }
            catch (Throwable t2) {
                return CompletableFutures.completedExceptionFuture((Throwable)t2);
            }
            return this.myStage;
        }
        if (biConsumer != null) {
            return CompletionStages.handleAndComposeAsync(stage, (e, t) -> {
                try {
                    biConsumer.accept((Object)e, (Throwable)t);
                    return this.myStage;
                }
                catch (Throwable innerT) {
                    if (t != null) {
                        innerT.addSuppressed((Throwable)t);
                    }
                    return CompletableFutures.completedExceptionFuture((Throwable)innerT);
                }
            }, (Executor)ctx.channel().eventLoop());
        }
        return stage.handle((value, t) -> {
            if (t != null) {
                return this;
            }
            return (RespRequestHandler)handlerWhenComplete.apply(value);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteBuf stringToByteBufWithExtra(CharSequence string, ByteBufAllocator allocator, int extraBytes) {
        boolean release = true;
        ByteBuf buffer = allocator.buffer(ByteBufUtil.utf8Bytes((CharSequence)string) + extraBytes);
        try {
            ByteBufUtil.writeUtf8((ByteBuf)buffer, (CharSequence)string);
            release = false;
        }
        finally {
            if (release) {
                buffer.release();
            }
        }
        return buffer;
    }

    static ByteBuf stringToByteBuf(CharSequence string, ByteBufAllocator allocator) {
        return RespRequestHandler.stringToByteBufWithExtra(string, allocator, 0);
    }
}

