/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.group.ChannelMatcher;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyChannelInitializer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespChannelInitializer;
import org.infinispan.server.resp.RespLettuceHandler;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.logging.Log;

public class RespServer
extends AbstractProtocolServer<RespServerConfiguration> {
    public static final String RESP_SERVER_FEATURE = "resp-server";
    private static final Log log = (Log)LogFactory.getLog(RespServer.class, Log.class);

    public RespServer() {
        super("Resp");
    }

    protected void startInternal() {
        ExpirationConfiguration expConfig;
        if (!this.cacheManager.getCacheManagerConfiguration().features().isAvailable(RESP_SERVER_FEATURE)) {
            throw org.infinispan.commons.logging.Log.CONFIG.featureDisabled(RESP_SERVER_FEATURE);
        }
        if (this.cacheManager.getCacheConfiguration(((RespServerConfiguration)this.configuration).defaultCacheName()) == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            Configuration defaultCacheConfiguration = this.cacheManager.getDefaultCacheConfiguration();
            if (defaultCacheConfiguration != null) {
                builder.read(defaultCacheConfiguration);
            } else {
                if (this.cacheManager.getCacheManagerConfiguration().isClustered()) {
                    builder.clustering().cacheMode(CacheMode.REPL_SYNC);
                }
                builder.encoding().key().mediaType("application/octet-stream");
                builder.encoding().value().mediaType("application/octet-stream");
            }
            this.cacheManager.defineConfiguration(((RespServerConfiguration)this.configuration).defaultCacheName(), builder.build());
        }
        if ((expConfig = this.cacheManager.getCacheConfiguration(((RespServerConfiguration)this.configuration).defaultCacheName()).expiration()).lifespan() >= 0L || expConfig.maxIdle() >= 0L) {
            throw log.invalidExpiration(((RespServerConfiguration)this.configuration).defaultCacheName());
        }
        super.startInternal();
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public ChannelInitializer<Channel> getInitializer() {
        return new NettyInitializers(new NettyInitializer[]{new NettyChannelInitializer((ProtocolServer)this, this.transport, null, null), new RespChannelInitializer(this)});
    }

    public ChannelMatcher getChannelMatcher() {
        return channel -> channel.pipeline().get(RespLettuceHandler.class) != null;
    }

    public void stop() {
        super.stop();
    }

    public AdvancedCache<byte[], byte[]> getCache() {
        return this.cacheManager.getCache(((RespServerConfiguration)this.configuration).defaultCacheName()).getAdvancedCache();
    }

    public Resp3Handler newHandler() {
        return new Resp3Handler(this);
    }
}

