/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.configuration;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.configuration.EncryptionConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.resp.configuration.AuthenticationConfigurationBuilder;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RespServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<RespServerConfiguration, RespServerConfigurationBuilder>
implements Builder<RespServerConfiguration> {
    static final Log logger = (Log)LogFactory.getLog(RespServerConfigurationBuilder.class, Log.class);
    private final AuthenticationConfigurationBuilder authentication = new AuthenticationConfigurationBuilder(this);
    private final EncryptionConfigurationBuilder encryption = new EncryptionConfigurationBuilder(this.ssl());

    public RespServerConfigurationBuilder() {
        super(6379, RespServerConfiguration.attributeDefinitionSet());
        this.defaultCacheName("respCache");
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public RespServerConfigurationBuilder self() {
        return this;
    }

    @Deprecated(forRemoval=true)
    public RespServerConfigurationBuilder cache(String cache) {
        this.defaultCacheName(cache);
        return this;
    }

    public RespServerConfigurationBuilder adminOperationsHandler(AdminOperationsHandler handler) {
        return this;
    }

    public AuthenticationConfigurationBuilder authentication() {
        return this.authentication;
    }

    public EncryptionConfigurationBuilder encryption() {
        return this.encryption;
    }

    public RespServerConfiguration create() {
        return new RespServerConfiguration(this.attributes.protect(), this.ipFilter.create(), this.ssl.create(), this.authentication.create(), this.encryption.create());
    }

    public RespServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public RespServerConfiguration build() {
        return this.build(true);
    }

    public Builder<?> read(RespServerConfiguration template, Combine combine) {
        super.read((ProtocolServerConfiguration)template, combine);
        this.authentication.read(template.authentication(), combine);
        this.encryption.read(template.encryption(), combine);
        return this;
    }
}

