/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import java.util.ArrayList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.resp.RespSingleNodeTest;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespMediaTypesTest")
public class RespMediaTypesTest
extends RespSingleNodeTest {
    private MediaType keyType;
    private MediaType valueType;

    @Override
    protected EmbeddedCacheManager createCacheManager() {
        this.cacheManager = this.createTestCacheManager();
        Configuration configuration = new ConfigurationBuilder().encoding().key().mediaType(this.keyType.toString()).encoding().value().mediaType(this.valueType.toString()).build();
        RespServerConfiguration serverConfiguration = this.serverConfiguration().build();
        this.cacheManager.defineConfiguration(serverConfiguration.defaultCacheName(), configuration);
        this.server = RespTestingUtil.startServer(this.cacheManager, serverConfiguration);
        this.client = RespTestingUtil.createClient(30000L, this.server.getPort());
        this.redisConnection = this.client.connect();
        this.cache = this.cacheManager.getCache(((RespServerConfiguration)this.server.getConfiguration()).defaultCacheName());
        return this.cacheManager;
    }

    private RespMediaTypesTest withKeyType(MediaType type) {
        this.keyType = type;
        return this;
    }

    private RespMediaTypesTest withValueType(MediaType type) {
        this.valueType = type;
        return this;
    }

    @Factory
    public Object[] factory() {
        MediaType[] types;
        ArrayList<RespMediaTypesTest> instances = new ArrayList<RespMediaTypesTest>();
        for (MediaType key : types = new MediaType[]{MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_OBJECT, MediaType.TEXT_PLAIN}) {
            for (MediaType value : types) {
                instances.add(new RespMediaTypesTest().withKeyType(key).withValueType(value));
            }
        }
        return instances.toArray();
    }

    protected String parameters() {
        return String.format("[key=%s, type=%s]", this.keyType, this.valueType);
    }
}

