/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.infinispan.server.resp.test.CommonRespTests;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.infinispan.test.Mocks;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.mockito.ArgumentMatchers;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespTwoNodeTest")
public class RespTwoNodeTest
extends MultipleCacheManagersTest {
    protected RedisClient client1;
    protected RespServer server1;
    protected RespServer server2;
    protected StatefulRedisConnection<String, String> redisConnection1;
    protected static final int timeout = 60;

    protected void createCacheManagers() {
        ConfigurationBuilder cacheBuilder = RespTwoNodeTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.createCluster(cacheBuilder, 2);
        this.waitForClusterToForm();
        this.server1 = RespTestingUtil.startServer((EmbeddedCacheManager)this.cacheManagers.get(0), this.serverConfiguration(0).build());
        this.server2 = RespTestingUtil.startServer((EmbeddedCacheManager)this.cacheManagers.get(1), this.serverConfiguration(1).build());
        this.client1 = RespTestingUtil.createClient(30000L, this.server1.getPort());
        this.redisConnection1 = this.client1.connect();
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        log.debug((Object)"Test finished, close resp server");
        RespTestingUtil.killClient(this.client1);
        RespTestingUtil.killServer(this.server1);
        RespTestingUtil.killServer(this.server2);
        super.destroy();
    }

    protected RespServerConfigurationBuilder serverConfiguration(int offset) {
        String serverName = TestResourceTracker.getCurrentTestShortName();
        return (RespServerConfigurationBuilder)((RespServerConfigurationBuilder)((RespServerConfigurationBuilder)new RespServerConfigurationBuilder().name(serverName)).host("127.0.0.1")).port(RespTestingUtil.port() + offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentOperations() throws ExecutionException, InterruptedException, TimeoutException {
        CheckPoint checkPoint = new CheckPoint();
        checkPoint.triggerForever("after_release");
        String blockedKey = "foo";
        Cache nonOwner = DistributionTestHelper.getFirstBackupOwner((Object)blockedKey, (List)this.caches(((RespServerConfiguration)this.server1.getConfiguration()).defaultCacheName()));
        ClusteringDependentLogic original = (ClusteringDependentLogic)Mocks.blockingMock((CheckPoint)checkPoint, ClusteringDependentLogic.class, (Cache)nonOwner, (stubber, clusteringDependentLogic) -> ((ClusteringDependentLogic)stubber.when(clusteringDependentLogic)).commitEntry((CacheEntry)ArgumentMatchers.any(), (FlagAffectedCommand)ArgumentMatchers.any(), (InvocationContext)ArgumentMatchers.any(), (Flag)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean()), (Class[])new Class[0]);
        RedisAsyncCommands redis = this.redisConnection1.async();
        try {
            RedisFuture futureSet = redis.set((Object)blockedKey, (Object)"bar");
            checkPoint.awaitStrict("before_invocation", 10L, TimeUnit.SECONDS);
            RedisFuture futurePing = redis.ping();
            RedisFuture futureCommand = redis.command();
            checkPoint.triggerForever("before_release");
            String getResponse = (String)futurePing.get(10L, TimeUnit.SECONDS);
            AssertJUnit.assertEquals((String)"OK", (String)((String)futureSet.get(10L, TimeUnit.SECONDS)));
            AssertJUnit.assertEquals((String)"PONG", (String)getResponse);
            List results = (List)futureCommand.get(10L, TimeUnit.SECONDS);
            AssertJUnit.assertTrue((String)("Results were: " + results), (results.size() > 10 ? 1 : 0) != 0);
        }
        finally {
            TestingUtil.replaceComponent((Cache)nonOwner, ClusteringDependentLogic.class, (Object)original, (boolean)true);
        }
        RedisFuture getFuture = redis.get((Object)blockedKey);
        AssertJUnit.assertEquals((String)"bar", (String)((String)getFuture.get(10L, TimeUnit.SECONDS)));
    }

    public void testPipeline() throws ExecutionException, InterruptedException, TimeoutException {
        CommonRespTests.testPipeline(this.redisConnection1);
    }
}

