/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.string;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.Util;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.Resp3Response;

public class GETRANGE
extends RespCommand
implements Resp3Command {
    public GETRANGE() {
        super(4, 1, 1, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] keyBytes = arguments.get(0);
        long beginIndex = ArgumentUtils.toLong(arguments.get(1));
        long lastIndex = ArgumentUtils.toLong(arguments.get(2));
        CompletionStage objectCompletableFuture = handler.cache().getAsync((Object)keyBytes).thenApply(value -> this.subrange((byte[])value, beginIndex, lastIndex));
        return handler.stageToReturn(objectCompletableFuture, ctx, Resp3Response.BULK_STRING_BYTES);
    }

    private byte[] subrange(byte[] arr, long begin, long end) {
        if (arr == null) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        if (begin < 0L) {
            begin = Math.max(0L, (long)arr.length + begin);
        }
        if (begin > (end = end < 0L ? (long)arr.length + end : Math.min((long)(arr.length - 1), end)) || begin >= (long)arr.length) {
            return Util.EMPTY_BYTE_ARRAY;
        }
        int b = (int)begin;
        int e = (int)end;
        return Arrays.copyOfRange(arr, b, e + 1);
    }
}

